/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.print.dicompm.dicom;

import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.print.BasicAnnotationBox;
import com.agfa.pacs.listtext.dicomobject.print.BasicFilmBox;
import com.agfa.pacs.listtext.dicomobject.print.BasicFilmSession;
import com.agfa.pacs.listtext.dicomobject.print.BasicImageBox;
import com.agfa.pacs.listtext.dicomobject.print.PresentationLookupTable;
import com.agfa.pacs.listtext.dicomobject.print.PrintJob;
import com.agfa.pacs.listtext.dicomobject.print.Printer;
import com.agfa.pacs.listtext.dicomobject.print.PrinterConfiguration;
import com.agfa.pacs.listtext.print.PrintColor;
import com.agfa.pacs.listtext.print.dicompm.dicom.DicomPrintNServiceSCU;
import com.agfa.pacs.logging.ALogger;
import java.util.Collection;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.util.UIDUtils;

public class DicomPrintClient {
    private DicomPrintNServiceSCU nservice;
    private String abstractUID;
    private boolean setCharacterSet;
    private static ALogger log = ALogger.getLogger(DicomPrintClient.class);

    public DicomPrintClient(IDicomNode iDicomNode, DicomService dicomService) throws DicomException {
        this.nservice = new DicomPrintNServiceSCU(iDicomNode, dicomService);
    }

    public void disconnect() throws Exception {
        this.nservice.close();
    }

    public void connect() throws Exception {
        this.checkConnection();
    }

    public void setSetCharacterSet(boolean bl) {
        this.setCharacterSet = bl;
    }

    public boolean isConnected() {
        return this.nservice.isConnected();
    }

    private void checkConnection() throws Exception {
        if (this.nservice.isConnected()) {
            return;
        }
        this.nservice.connect();
    }

    public boolean supportsColor() {
        try {
            this.checkConnection();
            return this.nservice.supportsColor();
        }
        catch (Exception exception) {
            log.error("Color query error", (Throwable)exception);
            return false;
        }
    }

    public boolean supportsGrayscale() {
        try {
            this.checkConnection();
            return this.nservice.supportsGrayscale();
        }
        catch (Exception exception) {
            log.error("Color query error", (Throwable)exception);
            return false;
        }
    }

    public void setPrintColor(PrintColor printColor) {
        try {
            this.checkConnection();
            if (printColor == PrintColor.Color && this.nservice.supportsColor()) {
                this.abstractUID = "1.2.840.10008.5.1.1.18";
            }
            if (printColor == PrintColor.Gray && this.nservice.supportsGrayscale()) {
                this.abstractUID = "1.2.840.10008.5.1.1.9";
            }
            if (this.abstractUID != null) {
                return;
            }
            Collection collection = this.nservice.getSupportedUIDs().getClassUIDs();
            if (collection.contains("1.2.840.10008.5.1.1.18")) {
                this.abstractUID = "1.2.840.10008.5.1.1.18";
            }
            if (this.abstractUID != null) {
                return;
            }
            if (collection.contains("1.2.840.10008.5.1.1.9")) {
                this.abstractUID = "1.2.840.10008.5.1.1.9";
            }
            if (this.abstractUID != null) {
                return;
            }
        }
        catch (Exception exception) {
            log.error("Color set error", (Throwable)exception);
        }
    }

    public PrinterConfiguration getPrinterConfiguration() {
        try {
            log.info("Get Printer Configuration");
            this.checkConnection();
            Attributes attributes = this.nservice.nGet(this.abstractUID, "1.2.840.10008.5.1.1.16.376", "1.2.840.10008.5.1.1.17.376");
            log.info("Status = " + Integer.toHexString(this.nservice.getLastStatus()));
            return new PrinterConfiguration(attributes);
        }
        catch (Exception exception) {
            log.error("Printer Configuration Get Error", (Throwable)exception);
            return null;
        }
    }

    public Printer getPrinter() {
        try {
            log.info("Get Printer");
            this.checkConnection();
            if (this.abstractUID == null) {
                this.setPrintColor(null);
            }
            Attributes attributes = this.nservice.nGet(this.abstractUID, "1.2.840.10008.5.1.1.16", "1.2.840.10008.5.1.1.17");
            log.info("Status = " + Integer.toHexString(this.nservice.getLastStatus()));
            return new Printer(attributes);
        }
        catch (Exception exception) {
            log.error("Printer Get Error", (Throwable)exception);
            return null;
        }
    }

    public PrintJob getPrintJob(ReferencedSOP referencedSOP) {
        try {
            log.info("Get PrintJob");
            this.checkConnection();
            if (this.abstractUID == null) {
                this.setPrintColor(null);
            }
            Attributes attributes = this.nservice.nGet(this.abstractUID, referencedSOP.getSOPClassUID(), referencedSOP.getSOPInstanceUID());
            log.info("Status = " + Integer.toHexString(this.nservice.getLastStatus()));
            return new PrintJob(attributes);
        }
        catch (Exception exception) {
            log.error("PrintJob Get Error", (Throwable)exception);
            return null;
        }
    }

    public void createBasicFilmSession(BasicFilmSession basicFilmSession) {
        try {
            log.info("Create Basic Film Session");
            this.checkConnection();
            if (this.abstractUID == null) {
                this.setPrintColor(null);
            }
            basicFilmSession.setSOPInstanceUID(UIDUtils.createUID());
            Attributes attributes = this.nservice.nCreate(this.abstractUID, "1.2.840.10008.5.1.1.1", basicFilmSession.getSOPInstanceUID(), basicFilmSession.getNServiceDicomObject(), !this.setCharacterSet);
            log.info("Status = " + Integer.toHexString(this.nservice.getLastStatus()));
            if (attributes == null) {
                return;
            }
            basicFilmSession.updateFrom(attributes);
        }
        catch (Exception exception) {
            log.error("Basic Film Session Create Error", (Throwable)exception);
        }
    }

    public void updateBasicFilmSession(BasicFilmSession basicFilmSession) {
        try {
            log.info("Update Basic Film Session");
            this.checkConnection();
            if (this.abstractUID == null) {
                this.setPrintColor(null);
            }
            this.nservice.nSet(this.abstractUID, basicFilmSession.getSOPClassUID(), basicFilmSession.getSOPInstanceUID(), basicFilmSession.getNServiceDicomObject());
            log.info("Status = " + Integer.toHexString(this.nservice.getLastStatus()));
        }
        catch (Exception exception) {
            log.error("Basic Film Session Update Error", (Throwable)exception);
        }
    }

    public void deleteBasicFilmSession(BasicFilmSession basicFilmSession) {
        try {
            log.info("Delete Basic Film Session");
            this.checkConnection();
            if (this.abstractUID == null) {
                this.setPrintColor(null);
            }
            this.nservice.nDelete(this.abstractUID, basicFilmSession.getSOPClassUID(), basicFilmSession.getSOPInstanceUID());
            log.info("Status = " + Integer.toHexString(this.nservice.getLastStatus()));
        }
        catch (Exception exception) {
            log.error("Basic Film Session Delete Error", (Throwable)exception);
        }
    }

    public ReferencedSOP printBasicFilmSession(BasicFilmSession basicFilmSession) {
        Attributes attributes;
        block4: {
            try {
                log.info("Print Basic Film Session");
                this.checkConnection();
                if (this.abstractUID == null) {
                    this.setPrintColor(null);
                }
                attributes = this.nservice.nAction(this.abstractUID, basicFilmSession.getSOPClassUID(), basicFilmSession.getSOPInstanceUID(), 1, new Attributes());
                log.info("Status = " + Integer.toHexString(this.nservice.getLastStatus()));
                if (attributes != null) break block4;
                return null;
            }
            catch (Exception exception) {
                log.error("Basic Film Session Print Error", (Throwable)exception);
                return null;
            }
        }
        return ReferencedSOP.create((Attributes)attributes.getNestedDataset(553649408));
    }

    public void createBasicFilmBox(BasicFilmBox basicFilmBox) {
        try {
            log.info("Create Basic Film Box");
            this.checkConnection();
            if (this.abstractUID == null) {
                this.setPrintColor(null);
            }
            basicFilmBox.setSOPInstanceUID(UIDUtils.createUID());
            Attributes attributes = this.nservice.nCreate(this.abstractUID, "1.2.840.10008.5.1.1.2", basicFilmBox.getSOPInstanceUID(), basicFilmBox.getNCreateDicomObject(), !this.setCharacterSet);
            log.info("Status = " + Integer.toHexString(this.nservice.getLastStatus()));
            if (attributes == null) {
                return;
            }
            basicFilmBox.updateFrom(attributes);
        }
        catch (Exception exception) {
            log.error("Basic Film Box Create Error", (Throwable)exception);
        }
    }

    public void updateBasicFilmBox(BasicFilmBox basicFilmBox) {
        try {
            log.info("Update Basic Film Box");
            this.checkConnection();
            if (this.abstractUID == null) {
                this.setPrintColor(null);
            }
            this.nservice.nSet(this.abstractUID, basicFilmBox.getSOPClassUID(), basicFilmBox.getSOPInstanceUID(), basicFilmBox.getNSetDicomObject());
            log.info("Status = " + Integer.toHexString(this.nservice.getLastStatus()));
        }
        catch (Exception exception) {
            log.error("Basic Film Box Update Error", (Throwable)exception);
        }
    }

    public void deleteBasicFilmBox(BasicFilmBox basicFilmBox) {
        try {
            log.info("Delete Basic Film Box");
            this.checkConnection();
            if (this.abstractUID == null) {
                this.setPrintColor(null);
            }
            this.nservice.nDelete(this.abstractUID, basicFilmBox.getSOPClassUID(), basicFilmBox.getSOPInstanceUID());
            log.info("Status = " + Integer.toHexString(this.nservice.getLastStatus()));
        }
        catch (Exception exception) {
            log.error("Basic Film Box Delete Error", (Throwable)exception);
        }
    }

    public ReferencedSOP printBasicFilmBox(BasicFilmBox basicFilmBox) {
        Attributes attributes;
        block4: {
            try {
                log.info("Print Basic Film Box");
                this.checkConnection();
                if (this.abstractUID == null) {
                    this.setPrintColor(null);
                }
                attributes = this.nservice.nAction(this.abstractUID, basicFilmBox.getSOPClassUID(), basicFilmBox.getSOPInstanceUID(), 1, null);
                log.info("Status = " + Integer.toHexString(this.nservice.getLastStatus()));
                if (attributes != null) break block4;
                return null;
            }
            catch (Exception exception) {
                log.error("Basic Film Box Print Error", (Throwable)exception);
                return null;
            }
        }
        return ReferencedSOP.create((Attributes)attributes.getNestedDataset(553649408));
    }

    public void setBasicImageBox(BasicImageBox basicImageBox) {
        try {
            log.info("Set Basic Image Box");
            this.checkConnection();
            if (this.abstractUID == null) {
                this.setPrintColor(null);
            }
            this.nservice.nSet(this.abstractUID, basicImageBox.getSOPClassUID(), basicImageBox.getSOPInstanceUID(), basicImageBox.getNSetDicomObject());
            log.info("Status = " + Integer.toHexString(this.nservice.getLastStatus()));
        }
        catch (Exception exception) {
            log.error("Error", (Throwable)exception);
        }
    }

    public void setBasicAnnotationBox(BasicAnnotationBox basicAnnotationBox) {
        try {
            log.info("Create Basic Annotation Box");
            this.checkConnection();
            if (this.abstractUID == null) {
                this.setPrintColor(null);
            }
            this.nservice.nSet(this.abstractUID, "1.2.840.10008.5.1.1.15", basicAnnotationBox.getSOPInstanceUID(), basicAnnotationBox.toDataset());
            log.info("Status = " + Integer.toHexString(this.nservice.getLastStatus()));
        }
        catch (Exception exception) {
            log.error("Error", (Throwable)exception);
        }
    }

    public void createPresentationLUT(PresentationLookupTable presentationLookupTable) {
        try {
            log.info("Create Presentation LUT");
            this.checkConnection();
            if (this.abstractUID == null) {
                this.setPrintColor(null);
            }
            presentationLookupTable.setSOPInstanceUID(UIDUtils.createUID());
            Attributes attributes = this.nservice.nCreate(this.abstractUID, "1.2.840.10008.5.1.1.23", presentationLookupTable.getSOPInstanceUID(), presentationLookupTable.getNCreateDataset(), !this.setCharacterSet);
            log.info("Status = " + Integer.toHexString(this.nservice.getLastStatus()));
            if (attributes == null) {
                return;
            }
            presentationLookupTable.updateFrom(attributes);
        }
        catch (Exception exception) {
            log.error("Presentation LUT Create Error", (Throwable)exception);
        }
    }

    public void deletePresentationLUT(PresentationLookupTable presentationLookupTable) {
        try {
            log.info("Delete Presentation LUT");
            this.checkConnection();
            if (this.abstractUID == null) {
                this.setPrintColor(null);
            }
            this.nservice.nDelete(this.abstractUID, presentationLookupTable.getSOPClassUID(), presentationLookupTable.getSOPInstanceUID());
            log.info("Status = " + Integer.toHexString(this.nservice.getLastStatus()));
        }
        catch (Exception exception) {
            log.error("Presentation LUT Delete Error", (Throwable)exception);
        }
    }

    public int getStatus() {
        return this.nservice.getLastStatus();
    }

    public PrintColor[] getSupportedColors() {
        return this.nservice.getSupportedColors();
    }
}

