/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.print.dicompm;

import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.pixel.PixelDataException;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.module.image.ImagePixel;
import com.agfa.pacs.listtext.dicomobject.module.print.ProposedStudy;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationSizeMode;
import com.agfa.pacs.listtext.dicomobject.presentation.rendering.PresentationRenderContext;
import com.agfa.pacs.listtext.dicomobject.print.BasicAnnotationBox;
import com.agfa.pacs.listtext.dicomobject.print.BasicFilmBox;
import com.agfa.pacs.listtext.dicomobject.print.BasicFilmSession;
import com.agfa.pacs.listtext.dicomobject.print.BasicImageBox;
import com.agfa.pacs.listtext.dicomobject.renderer.IDicomObjectRenderer;
import com.agfa.pacs.listtext.dicomobject.type.print.ConfigurationInformation;
import com.agfa.pacs.listtext.pixeldata.frame.PixelDataUtilities;
import com.agfa.pacs.listtext.print.AbstractPrintContext;
import com.agfa.pacs.listtext.print.IDisplayFormat;
import com.agfa.pacs.listtext.print.IPrintContext;
import com.agfa.pacs.listtext.print.dicompm.DicomDisplayFormat;
import com.agfa.pacs.listtext.print.dicompm.DicomFilmBoxConfiguration;
import com.agfa.pacs.listtext.print.dicompm.DicomFilmSessionConfiguration;
import com.agfa.pacs.listtext.print.dicompm.DicomImageBoxConfiguration;
import com.agfa.pacs.listtext.print.dicompm.dicom.DicomPrinter;
import com.agfa.pacs.listtext.print.mapper.IDicomEvaluation;
import com.agfa.pacs.listtext.print.mapper.MapperFilmBox;
import com.agfa.pacs.listtext.print.mapper.MapperFilmSession;
import com.agfa.pacs.listtext.print.mapper.MapperImageBox;
import com.agfa.pacs.listtext.print.renderer.layout.RasterFilmBoxLayout;
import com.agfa.pacs.logging.ALogger;
import java.awt.image.BufferedImage;
import java.util.Collection;
import org.dcm4che3.data.Attributes;

public class DicomPrintContext
extends AbstractPrintContext {
    private static ALogger log = ALogger.getLogger(DicomPrintContext.class);
    private DicomPrinter printer;
    private MapperFilmSession filmSession;
    private IPrintContext.Status status;
    private double progress;
    private boolean cancel;

    public DicomPrintContext(DicomPrinter dicomPrinter, MapperFilmSession mapperFilmSession) {
        this.printer = dicomPrinter;
        this.filmSession = mapperFilmSession;
        this.cancel = false;
        this.progress = 0.0;
        this.status = IPrintContext.Status.NotStarted;
    }

    public double getProgress() {
        return this.progress;
    }

    public IPrintContext.Status getStatus() {
        return this.status;
    }

    public void cancel() {
        this.cancel = true;
    }

    public boolean isRunning() {
        return this.status == IPrintContext.Status.InProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DicomPrinter dicomPrinter = this.printer;
        synchronized (dicomPrinter) {
            this.status = IPrintContext.Status.InProgress;
            int n = this.filmSession.filmBoxes().size();
            int n2 = 1;
            DicomFilmSessionConfiguration dicomFilmSessionConfiguration = (DicomFilmSessionConfiguration)this.filmSession.getMapperConfiguration(DicomFilmSessionConfiguration.class);
            if (dicomFilmSessionConfiguration != null) {
                this.printer.setPrintColor(dicomFilmSessionConfiguration.getPrintColor());
            }
            BasicFilmSession basicFilmSession = this.createFilmSession(this.filmSession);
            this.printer.beginPrinting();
            this.printer.beginFilmSession(basicFilmSession);
            Double d = this.filmSession.getZoomRatio();
            if (d == null) {
                d = 1.0;
            }
            for (MapperFilmBox mapperFilmBox : this.filmSession.filmBoxes()) {
                this.progress = (double)n2 / (double)n;
                ++n2;
                if (this.cancel) break;
                try {
                    BasicFilmBox basicFilmBox = this.createBasicFilmBox(mapperFilmBox);
                    IDisplayFormat iDisplayFormat = mapperFilmBox.getDisplayFormat();
                    double d2 = iDisplayFormat.getFilmSize().getPrintableAreaWidth() * (double)iDisplayFormat.getFilmBoxResolution().getResolutionDPI();
                    double d3 = iDisplayFormat.getFilmSize().getPrintableAreaHeight() * (double)iDisplayFormat.getFilmBoxResolution().getResolutionDPI();
                    if (iDisplayFormat.isRotated()) {
                        double d4 = d2;
                        d2 = d3;
                        d3 = d4;
                    }
                    d2 /= 25.4;
                    d3 /= 25.4;
                    if (iDisplayFormat.getFilmBoxLayout() instanceof RasterFilmBoxLayout) {
                        RasterFilmBoxLayout rasterFilmBoxLayout = (RasterFilmBoxLayout)iDisplayFormat.getFilmBoxLayout();
                        d2 /= (double)rasterFilmBoxLayout.getColumns();
                        d3 /= (double)rasterFilmBoxLayout.getRows();
                    } else {
                        d2 /= Math.sqrt(mapperFilmBox.getDisplayFormat().getFilmBoxLayout().getNumberOfImageBoxes());
                        d3 /= Math.sqrt(mapperFilmBox.getDisplayFormat().getFilmBoxLayout().getNumberOfImageBoxes());
                    }
                    this.printer.beginFilmBox(basicFilmBox);
                    if (this.cancel) break;
                    mapperFilmBox.prepareRendering(true);
                    if (this.cancel) break;
                    int n3 = 0;
                    while (n3 < mapperFilmBox.imageBoxes().size()) {
                        MapperImageBox mapperImageBox = (MapperImageBox)mapperFilmBox.imageBoxes().get(n3);
                        ReferencedSOP referencedSOP = basicFilmBox.imageBoxes().get(n3);
                        BasicImageBox basicImageBox = this.createBasicImageBox(referencedSOP, mapperImageBox, d2, d3, iDisplayFormat.getFilmBoxResolution().getResolutionDPI(), d);
                        if (mapperImageBox.getAnnotations() != null) {
                            int n4 = 0;
                            while (n4 < basicFilmBox.annotationBoxes().size()) {
                                BasicAnnotationBox basicAnnotationBox = new BasicAnnotationBox(basicFilmBox.annotationBoxes().get(n4));
                                String string = (String)mapperImageBox.getAnnotations().get(n4 + 1);
                                basicAnnotationBox.setAnnotationPosition(n4 + 1);
                                if (string == null) {
                                    string = "";
                                }
                                basicAnnotationBox.setTextString(string);
                                this.printer.setAnnotationBox(basicAnnotationBox);
                                ++n4;
                            }
                        }
                        if (basicImageBox != null) {
                            this.printer.setImageBox(basicImageBox);
                        }
                        ++n3;
                    }
                    if (this.cancel) break;
                    this.printer.endFilmBox();
                    this.notifyProgressed(IPrintContext.Status.Succeded, mapperFilmBox);
                }
                catch (Exception exception) {
                    log.error("Film box error", (Throwable)exception);
                    this.notifyProgressed(IPrintContext.Status.Failed, mapperFilmBox);
                }
            }
            this.printer.endFilmSession();
            this.printer.endPrinting();
            this.status = this.cancel ? IPrintContext.Status.Canceled : IPrintContext.Status.Finished;
            this.notifyFinished(this.status);
        }
    }

    private BasicFilmSession createFilmSession(MapperFilmSession mapperFilmSession) {
        BasicFilmSession basicFilmSession = new BasicFilmSession();
        DicomFilmSessionConfiguration dicomFilmSessionConfiguration = (DicomFilmSessionConfiguration)mapperFilmSession.getMapperConfiguration(DicomFilmSessionConfiguration.class);
        if (dicomFilmSessionConfiguration != null) {
            basicFilmSession.setFilmDestination(dicomFilmSessionConfiguration.getFilmDestination());
            basicFilmSession.setFilmSessionLabel(dicomFilmSessionConfiguration.getFilmSessionLabel());
            basicFilmSession.setMediumType(dicomFilmSessionConfiguration.getMediumType());
            basicFilmSession.setMemoryAllocation(dicomFilmSessionConfiguration.getMemoryAllocation());
            basicFilmSession.setNumberOfCopies(dicomFilmSessionConfiguration.getNumberOfCopies());
            basicFilmSession.setOwnerID(dicomFilmSessionConfiguration.getOwnerID());
            basicFilmSession.setPrintPriority(dicomFilmSessionConfiguration.getPrintPriority());
            if (dicomFilmSessionConfiguration.getUseProposedStudySequence()) {
                Collection collection = mapperFilmSession.objects();
                for (IObjectInfo iObjectInfo : collection) {
                    ISeriesInfo iSeriesInfo;
                    if (iObjectInfo == null || (iSeriesInfo = (ISeriesInfo)iObjectInfo.getTreeParent()) == null) continue;
                    basicFilmSession.setProposedStudy(ProposedStudy.create((Attributes)iSeriesInfo.getDicomObjectMerged()));
                    break;
                }
            }
        }
        return basicFilmSession;
    }

    private BasicFilmBox createBasicFilmBox(MapperFilmBox mapperFilmBox) {
        Object object;
        BasicFilmBox basicFilmBox = new BasicFilmBox();
        DicomFilmBoxConfiguration dicomFilmBoxConfiguration = (DicomFilmBoxConfiguration)mapperFilmBox.getMapperConfiguration(DicomFilmBoxConfiguration.class);
        if (dicomFilmBoxConfiguration != null) {
            IDicomEvaluation iDicomEvaluation;
            basicFilmBox.setAnnotationDisplayFormatID(dicomFilmBoxConfiguration.getAnnotationDisplayFormatID());
            basicFilmBox.setBorderDensity(dicomFilmBoxConfiguration.getBorderDensity());
            object = null;
            if (dicomFilmBoxConfiguration.getConfigurationInformation() != null) {
                object = dicomFilmBoxConfiguration.getConfigurationInformation().dicom();
            }
            if ((iDicomEvaluation = mapperFilmBox.getDicomEvaluation()) != null && object != null) {
                object = iDicomEvaluation.evaluate((String)object, mapperFilmBox.getOneDicomObject());
            }
            basicFilmBox.setConfigurationInformation(ConfigurationInformation.create((String)object));
            basicFilmBox.setEmptyImageDensity(dicomFilmBoxConfiguration.getEmptyImageDensity());
            basicFilmBox.setIllumination(dicomFilmBoxConfiguration.getIllumination());
            basicFilmBox.setMagnificationType(dicomFilmBoxConfiguration.getMagnificationType());
            basicFilmBox.setMaxDensity(dicomFilmBoxConfiguration.getMaxDensity());
            basicFilmBox.setMinDensity(dicomFilmBoxConfiguration.getMinDensity());
            basicFilmBox.setReflectedAmbientLight(dicomFilmBoxConfiguration.getReflectedAmbientLight());
            basicFilmBox.setSmoothingType(dicomFilmBoxConfiguration.getSmoothingType());
            basicFilmBox.setTrim(dicomFilmBoxConfiguration.getTrim());
        }
        if ((object = (DicomDisplayFormat)mapperFilmBox.getDisplayFormat()) != null) {
            basicFilmBox.setFilmOrientation(((DicomDisplayFormat)object).getFilmOrientation());
            basicFilmBox.setFilmSizeID(((DicomDisplayFormat)object).getFilmSizeID());
            basicFilmBox.setImageDisplayFormat(((DicomDisplayFormat)object).getImageDisplayFormat());
        }
        return basicFilmBox;
    }

    private BasicImageBox createBasicImageBox(ReferencedSOP referencedSOP, MapperImageBox mapperImageBox, double d, double d2, int n, double d3) {
        IDicomObjectRenderer iDicomObjectRenderer = mapperImageBox.getDicomObjectRenderer();
        if (iDicomObjectRenderer == null) {
            return null;
        }
        DicomImageBoxConfiguration dicomImageBoxConfiguration = (DicomImageBoxConfiguration)mapperImageBox.getMapperConfiguration(DicomImageBoxConfiguration.class);
        BasicImageBox basicImageBox = new BasicImageBox(referencedSOP);
        basicImageBox.setImagePosition(mapperImageBox.getIndex());
        if (dicomImageBoxConfiguration != null) {
            String string = null;
            if (dicomImageBoxConfiguration.getConfigurationInformation() != null) {
                string = dicomImageBoxConfiguration.getConfigurationInformation().dicom();
            }
            if (mapperImageBox.getEvaluator() != null && string != null) {
                string = mapperImageBox.getEvaluator().evaluate(string, mapperImageBox.getObjectInfo().getAttributes());
            }
            basicImageBox.setConfigurationInformation(ConfigurationInformation.create((String)string));
            basicImageBox.setMagnificationType(dicomImageBoxConfiguration.getMagnificationType());
            basicImageBox.setMaxDensity(dicomImageBoxConfiguration.getMaxDensity());
            basicImageBox.setMinDensity(dicomImageBoxConfiguration.getMinDensity());
            basicImageBox.setSmoothingType(dicomImageBoxConfiguration.getSmoothingType());
            basicImageBox.setPolarity(dicomImageBoxConfiguration.getPolarity());
            basicImageBox.setRequestedDecimateCropBehavior(dicomImageBoxConfiguration.getRequestedDecimateCropBehavior());
        }
        int n2 = (int)d;
        int n3 = (int)d2;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, basicImageBox.isGray() ? 10 : 1);
        PresentationRenderContext presentationRenderContext = new PresentationRenderContext(bufferedImage);
        presentationRenderContext.setPixelSpacingDPI((double)n, (double)n);
        presentationRenderContext.setSizeMode(mapperImageBox.getPresentationSizeMode());
        presentationRenderContext.setApplyMapping(mapperImageBox.isIncludeMappings(), !mapperImageBox.isMappingsOutside());
        presentationRenderContext.setDevice("PRINT");
        iDicomObjectRenderer.renderTo(presentationRenderContext);
        if (presentationRenderContext.getSizeMode() == PresentationSizeMode.TrueSize) {
            basicImageBox.setRequestedImageSize(presentationRenderContext.getPixelSpacing()[0] * d3 * d);
        }
        try {
            ImagePixel imagePixel = PixelDataUtilities.createImagePixel((BufferedImage)bufferedImage, (String)"1.2.840.10008.1.2.1", (int)8);
            if (basicImageBox.isGray()) {
                basicImageBox.setGrayscaleImage(imagePixel);
            } else {
                basicImageBox.setColorImage(imagePixel);
            }
        }
        catch (PixelDataException pixelDataException) {
            log.error("Pixel error", (Throwable)pixelDataException);
        }
        return basicImageBox;
    }
}

