/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.content;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.content.TextContentDescriber;
import org.eclipse.core.internal.content.Util;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;

public class XMLContentDescriber
extends TextContentDescriber
implements ITextContentDescriber {
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
    private static final String XML_PREFIX = "<?xml ";
    private static final String XML_DECL_END = "?>";
    private static final String BOM = "org.eclipse.core.runtime.content.XMLContentDescriber.bom";
    private static final String CHARSET = "org.eclipse.core.runtime.content.XMLContentDescriber.charset";
    private static final String FULL_XML_DECL = "org.eclipse.core.runtime.content.XMLContentDescriber.fullXMLDecl";
    private static final String RESULT = "org.eclipse.core.runtime.content.XMLContentDescriber.processed";

    public int describe(InputStream inputStream, IContentDescription iContentDescription) throws IOException {
        return this.describe2(inputStream, iContentDescription, new HashMap());
    }

    int describe2(InputStream inputStream, IContentDescription iContentDescription, Map map) throws IOException {
        if (!this.isProcessed(map)) {
            this.fillContentProperties(inputStream, iContentDescription, map);
        }
        return this.internalDescribe(iContentDescription, map);
    }

    public int describe(Reader reader, IContentDescription iContentDescription) throws IOException {
        return this.describe2(reader, iContentDescription, new HashMap());
    }

    int describe2(Reader reader, IContentDescription iContentDescription, Map map) throws IOException {
        if (!this.isProcessed(map)) {
            this.fillContentProperties(this.readXMLDecl(reader), iContentDescription, map);
        }
        return this.internalDescribe(iContentDescription, map);
    }

    private boolean isProcessed(Map map) {
        Boolean bl = (Boolean)map.get(RESULT);
        return bl != null;
    }

    private void fillContentProperties(InputStream inputStream, IContentDescription iContentDescription, Map map) throws IOException {
        byte[] byArray = Util.getByteOrderMark(inputStream);
        String string = "UTF-8";
        inputStream.reset();
        if (byArray != null) {
            if (byArray == IContentDescription.BOM_UTF_16BE) {
                string = "UTF-16BE";
            } else if (byArray == IContentDescription.BOM_UTF_16LE) {
                string = "UTF-16LE";
            }
            inputStream.skip(byArray.length);
            map.put(BOM, byArray);
        }
        this.fillContentProperties(this.readXMLDecl(inputStream, string), iContentDescription, map);
    }

    private void fillContentProperties(String string, IContentDescription iContentDescription, Map map) throws IOException {
        String string2;
        if (string != null && string.startsWith(XML_PREFIX)) {
            map.put(FULL_XML_DECL, new Boolean(true));
        }
        if ((string2 = this.getCharset(string)) != null) {
            map.put(CHARSET, string2);
        }
        map.put(RESULT, new Boolean(true));
    }

    private int internalDescribe(IContentDescription iContentDescription, Map map) {
        Object object;
        if (iContentDescription != null && (object = (byte[])map.get(BOM)) != null && iContentDescription.isRequested(IContentDescription.BYTE_ORDER_MARK)) {
            iContentDescription.setProperty(IContentDescription.BYTE_ORDER_MARK, object);
        }
        if ((object = (Object)((Boolean)map.get(FULL_XML_DECL))) == null || !((Boolean)object).booleanValue()) {
            return 1;
        }
        if (iContentDescription == null) {
            return 2;
        }
        String string = (String)map.get(CHARSET);
        if (iContentDescription.isRequested(IContentDescription.CHARSET)) {
            if (string != null && !this.isCharsetValid(string)) {
                return 0;
            }
            if (this.isNonDefaultCharset(string)) {
                iContentDescription.setProperty(IContentDescription.CHARSET, string);
            }
        }
        return 2;
    }

    private boolean isNonDefaultCharset(String string) {
        if (string == null) {
            return false;
        }
        return !string.equalsIgnoreCase("utf8") && !string.equalsIgnoreCase("utf-8");
    }

    private boolean isFullXMLDecl(String string) {
        return string.endsWith(XML_DECL_END);
    }

    private String readXMLDecl(InputStream inputStream, String string) throws IOException {
        byte[] byArray = XML_DECL_END.getBytes(string);
        int n = 100 * byArray.length / 2;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < byArray2.length && (n2 = inputStream.read()) != -1) {
            n4 = n2 == byArray[n4] ? ++n4 : 0;
            byArray2[n3++] = (byte)n2;
            if (n4 == byArray.length) break;
        }
        return new String(byArray2, 0, n3, string);
    }

    private String readXMLDecl(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = new String();
        String string2 = null;
        while (string.length() < 100 && (string2 = bufferedReader.readLine()) != null) {
            string = String.valueOf(string) + string2;
            if (string2.indexOf(XML_DECL_END) == -1) continue;
            return string.substring(0, string.indexOf(XML_DECL_END) + XML_DECL_END.length());
        }
        return string;
    }

    private String getCharset(String string) {
        int n = this.findEncodingPosition(string);
        if (n == -1) {
            return null;
        }
        int n2 = 34;
        int n3 = string.indexOf(34, n);
        int n4 = string.indexOf(39, n);
        if (n3 == -1 || n4 != -1 && n4 < n3) {
            n2 = 39;
            n3 = n4;
        }
        if (n3 == -1 || string.length() == n3 + 1) {
            return null;
        }
        int n5 = string.indexOf(n2, n3 + 1);
        if (n5 == -1) {
            return this.isFullXMLDecl(string) ? string.substring(n3 + 1, string.lastIndexOf(XML_DECL_END)).trim() : null;
        }
        return string.substring(n3 + 1, n5);
    }

    private int findEncodingPosition(String string) {
        String string2 = "encoding";
        int n = 0;
        int n2 = 0;
        block0: while ((n2 = string.indexOf(string2, n)) != -1) {
            boolean bl = false;
            int n3 = n = n2 + string2.length();
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                if (c == '=' && !bl) {
                    bl = true;
                } else if (c != ' ' && c != '\t' && c != '\r' && c != '\n') {
                    if (c != '\"' && c != '\'' || !bl) continue block0;
                    return n2;
                }
                ++n3;
            }
        }
        return -1;
    }

    private boolean isCharsetValid(String string) {
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            c = string.charAt(n);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }
}

