/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.util.List;
import org.eclipse.core.internal.content.ContentMessages;
import org.eclipse.core.internal.content.ContentType;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.internal.content.IContentTypeInfo;
import org.eclipse.core.internal.content.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ContentTypeSettings
implements IContentTypeSettings,
IContentTypeInfo {
    private ContentType contentType;
    private IScopeContext context;

    static void addFileSpec(IScopeContext iScopeContext, String string, String string2, int n) throws CoreException {
        Preferences preferences = ContentTypeManager.getInstance().getPreferences(iScopeContext).node(string);
        String string3 = ContentType.getPreferenceKey(n);
        List list = Util.parseItemsIntoList(preferences.get(string3, null));
        int n2 = 0;
        while (n2 < list.size()) {
            if (((String)list.get(n2)).equalsIgnoreCase(string2)) {
                return;
            }
            ++n2;
        }
        list.add(string2);
        String string4 = Util.toListString(list.toArray());
        ContentType.setPreference(preferences, string3, string4);
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            String string5 = NLS.bind((String)ContentMessages.content_errorSavingSettings, (Object)string);
            Status status = new Status(4, "org.eclipse.core.contenttype", 0, string5, (Throwable)backingStoreException);
            throw new CoreException((IStatus)status);
        }
    }

    static String[] getFileSpecs(IScopeContext iScopeContext, String string, int n) {
        Preferences preferences = ContentTypeManager.getInstance().getPreferences(iScopeContext).node(string);
        return ContentTypeSettings.getFileSpecs(preferences, n);
    }

    static String[] getFileSpecs(Preferences preferences, int n) {
        String string = ContentType.getPreferenceKey(n);
        String string2 = preferences.get(string, null);
        return Util.parseItems(string2);
    }

    public static String internalGetDefaultProperty(ContentType contentType, Preferences preferences, QualifiedName qualifiedName) throws BackingStoreException {
        Object object;
        Object object2;
        String string = contentType.getId();
        if (preferences.nodeExists(string) && (object2 = (object = preferences.node(string)).get(qualifiedName.getLocalName(), null)) != null) {
            return object2;
        }
        object = contentType.basicGetDefaultProperty(qualifiedName);
        if (object != null) {
            return object;
        }
        object2 = (ContentType)contentType.getBaseType();
        return object2 == null ? null : ContentTypeSettings.internalGetDefaultProperty((ContentType)object2, preferences, qualifiedName);
    }

    static void removeFileSpec(IScopeContext iScopeContext, String string, String string2, int n) throws CoreException {
        String string3;
        Preferences preferences = ContentTypeManager.getInstance().getPreferences(iScopeContext).node(string);
        String string4 = preferences.get(string3 = ContentType.getPreferenceKey(n), null);
        if (string4 == null) {
            return;
        }
        List list = Util.parseItemsIntoList(preferences.get(string3, null));
        int n2 = -1;
        int n3 = list.size();
        int n4 = 0;
        while (n2 == -1 && n4 < n3) {
            if (((String)list.get(n4)).equalsIgnoreCase(string2)) {
                n2 = n4;
            }
            ++n4;
        }
        if (n2 == -1) {
            return;
        }
        list.remove(n2);
        String string5 = Util.toListString(list.toArray());
        ContentType.setPreference(preferences, string3, string5);
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            String string6 = NLS.bind((String)ContentMessages.content_errorSavingSettings, (Object)string);
            Status status = new Status(4, "org.eclipse.core.contenttype", 0, string6, (Throwable)backingStoreException);
            throw new CoreException((IStatus)status);
        }
    }

    public ContentTypeSettings(ContentType contentType, IScopeContext iScopeContext) {
        this.context = iScopeContext;
        this.contentType = contentType;
    }

    public void addFileSpec(String string, int n) throws CoreException {
        ContentTypeSettings.addFileSpec(this.context, this.contentType.getId(), string, n);
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public String getDefaultCharset() {
        return this.getDefaultProperty(IContentDescription.CHARSET);
    }

    public String getDefaultProperty(QualifiedName qualifiedName) {
        IEclipsePreferences iEclipsePreferences = ContentTypeManager.getInstance().getPreferences(this.context);
        try {
            String string = ContentTypeSettings.internalGetDefaultProperty(this.contentType, (Preferences)iEclipsePreferences, qualifiedName);
            return "".equals(string) ? null : string;
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
    }

    public String[] getFileSpecs(int n) {
        return ContentTypeSettings.getFileSpecs(this.context, this.contentType.getId(), n);
    }

    public String getId() {
        return this.contentType.getId();
    }

    public void removeFileSpec(String string, int n) throws CoreException {
        ContentTypeSettings.removeFileSpec(this.context, this.contentType.getId(), string, n);
    }

    public void setDefaultCharset(String string) throws CoreException {
        Preferences preferences = ContentTypeManager.getInstance().getPreferences(this.context).node(this.contentType.getId());
        ContentType.setPreference(preferences, "charset", string);
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            String string2 = NLS.bind((String)ContentMessages.content_errorSavingSettings, (Object)this.contentType.getId());
            Status status = new Status(4, "org.eclipse.core.contenttype", 0, string2, (Throwable)backingStoreException);
            throw new CoreException((IStatus)status);
        }
    }
}

