/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.print.localprint;

import com.agfa.pacs.base.util.FileServiceUtil;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationSizeMode;
import com.agfa.pacs.listtext.print.AbstractPrintContext;
import com.agfa.pacs.listtext.print.IDisplayFormat;
import com.agfa.pacs.listtext.print.IPrintContext;
import com.agfa.pacs.listtext.print.InvalidResolution;
import com.agfa.pacs.listtext.print.localprint.ForcedPrintService;
import com.agfa.pacs.listtext.print.localprint.LocalPrintManagement;
import com.agfa.pacs.listtext.print.localprint.jps.AttributeSetSource;
import com.agfa.pacs.listtext.print.mapper.MapperFilmBox;
import com.agfa.pacs.listtext.print.mapper.MapperFilmSession;
import com.agfa.pacs.listtext.print.mapper.MapperImageBox;
import com.agfa.pacs.listtext.print.renderer.FilmBox;
import com.agfa.pacs.listtext.print.renderer.FilmBoxRenderer;
import com.agfa.pacs.listtext.print.renderer.FilmBoxSheet;
import com.agfa.pacs.listtext.print.renderer.ImageBox;
import com.agfa.pacs.listtext.swingx.icon.IconUtil;
import com.agfa.pacs.logging.ALogger;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.print.CancelablePrintJob;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;

public class LocalPrintContext
extends AbstractPrintContext {
    private static ALogger log = ALogger.getLogger(LocalPrintContext.class);
    private static final String PRINT_SCOPE = "print";
    private boolean cancel;
    private PrintService printService;
    private MapperFilmSession filmSession;
    private DocPrintJob printJob;
    private PrintJobListener printListener;
    private Image customLogo;
    private int customLogoHeight;
    private int customLogoAlignment;
    private double progress;
    private IPrintContext.Status status;
    private int copies = 1;

    public LocalPrintContext(LocalPrintManagement localPrintManagement, PrintService printService, MapperFilmSession mapperFilmSession, int n) {
        this.printService = printService;
        this.filmSession = mapperFilmSession;
        this.status = IPrintContext.Status.NotStarted;
        this.cancel = false;
        this.progress = 0.0;
        this.copies = n;
    }

    public double getProgress() {
        return this.progress;
    }

    public IPrintContext.Status getStatus() {
        return this.status;
    }

    public void cancel() {
        this.cancel = true;
        if (this.printJob instanceof CancelablePrintJob) {
            try {
                ((CancelablePrintJob)this.printJob).cancel();
            }
            catch (PrintException printException) {
                log.error("Error", (Throwable)printException);
            }
        }
    }

    public boolean isRunning() {
        return this.status == IPrintContext.Status.InProgress;
    }

    public void run() {
        this.status = IPrintContext.Status.InProgress;
        int n = this.filmSession.filmBoxes().size();
        int n2 = 1;
        this.customLogo = this.getCustomLogo();
        if (this.customLogo != null) {
            this.customLogo = IconUtil.scaleImage((Image)this.customLogo, (int)-1, (int)((int)((double)(this.customLogoHeight * 300) / 25.4 + 0.5)));
        }
        for (MapperFilmBox mapperFilmBox : this.filmSession.filmBoxes()) {
            this.progress = (double)n2 / (double)n;
            ++n2;
            if (this.cancel) break;
            try {
                Object object;
                Object object2;
                FilmBox filmBox = new FilmBox();
                filmBox.setGapColor(Color.WHITE);
                IDisplayFormat iDisplayFormat = mapperFilmBox.getDisplayFormat();
                filmBox.setFilmBoxLayout(iDisplayFormat.getFilmBoxLayout());
                FilmBoxSheet filmBoxSheet = new FilmBoxSheet(filmBox, iDisplayFormat.getFilmSize(), iDisplayFormat.getFilmBoxResolution(), this.filmSession.getZoomRatio(), iDisplayFormat.isRotated(), this.customLogo, this.customLogoHeight, this.customLogoAlignment);
                filmBoxSheet.layout();
                if (this.cancel) break;
                mapperFilmBox.prepareRendering(true);
                if (this.cancel) break;
                int n3 = 0;
                while (n3 < mapperFilmBox.imageBoxes().size()) {
                    object2 = (MapperImageBox)mapperFilmBox.imageBoxes().get(n3);
                    object = (ImageBox)filmBox.imageBoxes().get(n3);
                    object.setDicomObjectRenderer(object2.getDicomObjectRenderer());
                    PresentationSizeMode presentationSizeMode = object2.getPresentationSizeMode();
                    object.setIncludeMappings(object2.isIncludeMappings());
                    object.setMappingsOutside(object2.isMappingsOutside());
                    if (presentationSizeMode == PresentationSizeMode.ScaleToFit) {
                        object.setImageFitting(ImageBox.ImageFitting.Scale);
                    } else if (presentationSizeMode == PresentationSizeMode.TrueSize) {
                        object.setImageFitting(ImageBox.ImageFitting.Crop);
                    }
                    ++n3;
                }
                if (this.cancel) break;
                FilmBoxRenderer filmBoxRenderer = filmBoxSheet.createFilmBoxRenderer();
                object2 = new SimpleDoc(filmBoxRenderer, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
                object = new HashPrintRequestAttributeSet();
                object.add(iDisplayFormat.isRotated() ? OrientationRequested.LANDSCAPE : OrientationRequested.PORTRAIT);
                object.addAll(((AttributeSetSource)iDisplayFormat.getFilmSize()).getAttributeSet());
                if (!(iDisplayFormat.getFilmBoxResolution() instanceof InvalidResolution)) {
                    object.addAll(((AttributeSetSource)iDisplayFormat.getFilmBoxResolution()).getAttributeSet());
                }
                object.add(new Copies(this.copies));
                this.createPrintJob(this.printService);
                try {
                    this.printJob.print((Doc)object2, (PrintRequestAttributeSet)object);
                }
                catch (PrintException printException) {
                    this.printJob.removePrintJobListener(this.printListener);
                    if (printException.getMessage().contains("not accepting job")) {
                        log.warn("Printer not accepting jobs, try to push it");
                        this.createPrintJob(this.printService);
                        ForcedPrintService.setupPrintJob(this.printJob);
                        this.printJob.print((Doc)object2, (PrintRequestAttributeSet)object);
                    }
                    throw printException;
                }
                this.printJob.removePrintJobListener(this.printListener);
                this.notifyProgressed(IPrintContext.Status.Succeded, mapperFilmBox);
            }
            catch (Exception exception) {
                log.error("Error printing job.", (Throwable)exception);
                this.notifyProgressed(IPrintContext.Status.Failed, mapperFilmBox);
            }
        }
    }

    private void createPrintJob(PrintService printService) {
        this.printJob = this.printService.createPrintJob();
        this.printListener = new MyPrintJobListener();
        this.printJob.addPrintJobListener(this.printListener);
    }

    private Image getCustomLogo() {
        String string;
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
        if ((iConfigurationProvider = iConfigurationProvider.getNode("listtext.print.custom_logo")) != null && iConfigurationProvider.exists("logo_enabled") && iConfigurationProvider.getBoolean("logo_enabled") && iConfigurationProvider.exists("selected_logo") && iConfigurationProvider.getString("selected_logo").trim().length() > 0 && (string = iConfigurationProvider.getString("selected_logo")).trim().length() > 0) {
            this.customLogoHeight = (int)iConfigurationProvider.getLong("logo_size");
            this.customLogoAlignment = (int)iConfigurationProvider.getLong("logo_align");
            InputStream inputStream = null;
            try {
                inputStream = LocalPrintContext.getFileStream(string);
                this.customLogo = ImageIO.read(inputStream);
                return this.customLogo;
            }
            catch (Exception exception) {
                log.error("Error retrieving custom logo from server.", (Throwable)exception);
            }
        }
        return null;
    }

    private static InputStream getFileStream(String string) throws Exception {
        InputStream inputStream;
        boolean bl;
        boolean bl2 = bl = !ConfigurationProviderFactory.getConfig().isSupportingRoles();
        if (bl) {
            inputStream = new FileInputStream(new File(string));
        } else {
            FileServiceUtil fileServiceUtil = new FileServiceUtil(PRINT_SCOPE);
            if (fileServiceUtil.isDataAvailable(null, string)) {
                inputStream = fileServiceUtil.getDataStream(null, string);
            } else {
                throw new FileNotFoundException(string);
            }
        }
        return inputStream;
    }

    private class MyPrintJobListener
    implements PrintJobListener {
        private MyPrintJobListener() {
        }

        @Override
        public void printDataTransferCompleted(PrintJobEvent printJobEvent) {
            LocalPrintContext.this.notifyFinished(IPrintContext.Status.Succeded);
            LocalPrintContext.this.notifyFinished(IPrintContext.Status.Finished);
        }

        @Override
        public void printJobCanceled(PrintJobEvent printJobEvent) {
            LocalPrintContext.this.notifyFinished(IPrintContext.Status.Canceled);
        }

        @Override
        public void printJobCompleted(PrintJobEvent printJobEvent) {
        }

        @Override
        public void printJobFailed(PrintJobEvent printJobEvent) {
            LocalPrintContext.this.notifyFinished(IPrintContext.Status.Failed);
            log.error("Failed print:{}", (Object)printJobEvent);
        }

        @Override
        public void printJobNoMoreEvents(PrintJobEvent printJobEvent) {
        }

        @Override
        public void printJobRequiresAttention(PrintJobEvent printJobEvent) {
        }
    }
}

