/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.print.localprint;

import com.agfa.pacs.logging.ALogger;
import java.lang.reflect.Field;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.event.PrintServiceAttributeListener;

public class ForcedPrintService
implements PrintService {
    private static final ALogger LOG = ALogger.getLogger(ForcedPrintService.class);
    private final DocPrintJob thePrintJob;
    private final PrintService delegate;
    private Field printServiceFieldReference = null;

    public static void setupPrintJob(DocPrintJob docPrintJob) {
        new ForcedPrintService(docPrintJob);
    }

    private ForcedPrintService(DocPrintJob docPrintJob) {
        this.thePrintJob = docPrintJob;
        this.delegate = docPrintJob.getPrintService();
        try {
            Class<?> clazz = this.thePrintJob.getClass();
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = 0;
            while (n < fieldArray.length) {
                if (fieldArray[n].getType().equals(PrintService.class)) {
                    this.printServiceFieldReference = fieldArray[n];
                    this.printServiceFieldReference.setAccessible(true);
                    this.printServiceFieldReference.set(this.thePrintJob, this);
                    break;
                }
                ++n;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.error("Reflection failed", (Throwable)illegalAccessException);
        }
    }

    private void restoreServiceReference() {
        try {
            if (this.printServiceFieldReference != null) {
                this.printServiceFieldReference.set(this.thePrintJob, this.delegate);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.error("Error restoring reference");
        }
    }

    public PrintServiceAttribute getAttribute(Class clazz) {
        if (clazz.equals(PrinterIsAcceptingJobs.class)) {
            this.restoreServiceReference();
            return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
        }
        return this.delegate.getAttribute(clazz);
    }

    @Override
    public DocPrintJob createPrintJob() {
        return this.delegate.createPrintJob();
    }

    @Override
    public void addPrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        this.delegate.addPrintServiceAttributeListener(printServiceAttributeListener);
    }

    @Override
    public PrintServiceAttributeSet getAttributes() {
        return this.delegate.getAttributes();
    }

    public Object getDefaultAttributeValue(Class clazz) {
        return this.delegate.getDefaultAttributeValue(clazz);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public ServiceUIFactory getServiceUIFactory() {
        return this.delegate.getServiceUIFactory();
    }

    public Class[] getSupportedAttributeCategories() {
        return this.delegate.getSupportedAttributeCategories();
    }

    public Object getSupportedAttributeValues(Class clazz, DocFlavor docFlavor, AttributeSet attributeSet) {
        return this.delegate.getSupportedAttributeValues(clazz, docFlavor, attributeSet);
    }

    @Override
    public DocFlavor[] getSupportedDocFlavors() {
        return this.delegate.getSupportedDocFlavors();
    }

    @Override
    public AttributeSet getUnsupportedAttributes(DocFlavor docFlavor, AttributeSet attributeSet) {
        return this.delegate.getUnsupportedAttributes(docFlavor, attributeSet);
    }

    public boolean isAttributeCategorySupported(Class clazz) {
        return this.delegate.isAttributeCategorySupported(clazz);
    }

    @Override
    public boolean isAttributeValueSupported(Attribute attribute, DocFlavor docFlavor, AttributeSet attributeSet) {
        return this.delegate.isAttributeValueSupported(attribute, docFlavor, attributeSet);
    }

    @Override
    public boolean isDocFlavorSupported(DocFlavor docFlavor) {
        return this.delegate.isDocFlavorSupported(docFlavor);
    }

    @Override
    public void removePrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        this.delegate.removePrintServiceAttributeListener(printServiceAttributeListener);
    }
}

