/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.dcm4che3.data.DatePrecision;

public class DateUtils {
    public static final Date[] EMPTY_DATES = new Date[0];
    private static TimeZone cachedTimeZone;

    private static Calendar cal(TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = timeZone != null ? new GregorianCalendar(timeZone) : new GregorianCalendar();
        gregorianCalendar.clear();
        return gregorianCalendar;
    }

    private static Calendar cal(TimeZone timeZone, Date date) {
        GregorianCalendar gregorianCalendar = timeZone != null ? new GregorianCalendar(timeZone) : new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }

    private static void ceil(Calendar calendar, int n) {
        calendar.add(n, 1);
        calendar.add(14, -1);
    }

    public static String formatDA(TimeZone timeZone, Date date) {
        return DateUtils.formatDA(timeZone, date, new StringBuilder(8)).toString();
    }

    public static StringBuilder formatDA(TimeZone timeZone, Date date, StringBuilder stringBuilder) {
        return DateUtils.formatDT(DateUtils.cal(timeZone, date), stringBuilder, 5);
    }

    public static String formatTM(TimeZone timeZone, Date date) {
        return DateUtils.formatTM(timeZone, date, new DatePrecision());
    }

    public static String formatTM(TimeZone timeZone, Date date, DatePrecision datePrecision) {
        return DateUtils.formatTM(DateUtils.cal(timeZone, date), new StringBuilder(10), datePrecision.lastField).toString();
    }

    private static StringBuilder formatTM(Calendar calendar, StringBuilder stringBuilder, int n) {
        DateUtils.appendXX(calendar.get(11), stringBuilder);
        if (n > 11) {
            DateUtils.appendXX(calendar.get(12), stringBuilder);
            if (n > 12) {
                DateUtils.appendXX(calendar.get(13), stringBuilder);
                if (n > 13) {
                    stringBuilder.append('.');
                    DateUtils.appendXXX(calendar.get(14), stringBuilder);
                }
            }
        }
        return stringBuilder;
    }

    public static String formatDT(TimeZone timeZone, Date date) {
        return DateUtils.formatDT(timeZone, date, new DatePrecision());
    }

    public static String formatDT(TimeZone timeZone, Date date, DatePrecision datePrecision) {
        return DateUtils.formatDT(timeZone, date, new StringBuilder(23), datePrecision).toString();
    }

    public static StringBuilder formatDT(TimeZone timeZone, Date date, StringBuilder stringBuilder, DatePrecision datePrecision) {
        Calendar calendar = DateUtils.cal(timeZone, date);
        DateUtils.formatDT(calendar, stringBuilder, datePrecision.lastField);
        if (datePrecision.includeTimezone) {
            int n = calendar.get(15) + calendar.get(16);
            DateUtils.appendZZZZZ(n, stringBuilder);
        }
        return stringBuilder;
    }

    private static StringBuilder appendZZZZZ(int n, StringBuilder stringBuilder) {
        if (n < 0) {
            n = -n;
            stringBuilder.append('-');
        } else {
            stringBuilder.append('+');
        }
        int n2 = n / 60000;
        DateUtils.appendXX(n2 / 60, stringBuilder);
        DateUtils.appendXX(n2 % 60, stringBuilder);
        return stringBuilder;
    }

    public static String formatTimezoneOffsetFromUTC(TimeZone timeZone) {
        return DateUtils.appendZZZZZ(timeZone.getRawOffset(), new StringBuilder(5)).toString();
    }

    private static StringBuilder formatDT(Calendar calendar, StringBuilder stringBuilder, int n) {
        DateUtils.appendXXXX(calendar.get(1), stringBuilder);
        if (n > 1) {
            DateUtils.appendXX(calendar.get(2) + 1, stringBuilder);
            if (n > 2) {
                DateUtils.appendXX(calendar.get(5), stringBuilder);
                if (n > 5) {
                    DateUtils.formatTM(calendar, stringBuilder, n);
                }
            }
        }
        return stringBuilder;
    }

    private static void appendXXXX(int n, StringBuilder stringBuilder) {
        if (n < 1000) {
            stringBuilder.append('0');
        }
        DateUtils.appendXXX(n, stringBuilder);
    }

    private static void appendXXX(int n, StringBuilder stringBuilder) {
        if (n < 100) {
            stringBuilder.append('0');
        }
        DateUtils.appendXX(n, stringBuilder);
    }

    private static void appendXX(int n, StringBuilder stringBuilder) {
        if (n < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n);
    }

    public static Date parseDA(TimeZone timeZone, String string) {
        return DateUtils.parseDA(timeZone, string, false);
    }

    public static Date parseDA(TimeZone timeZone, String string, boolean bl) {
        Calendar calendar = DateUtils.cal(timeZone);
        int n = string.length();
        if (n != 8 && (n != 10 || Character.isDigit(string.charAt(4)))) {
            throw new IllegalArgumentException(string);
        }
        try {
            int n2 = 0;
            calendar.set(1, Integer.parseInt(string.substring(n2, n2 + 4)));
            if (!Character.isDigit(string.charAt(n2 += 4))) {
                ++n2;
            }
            calendar.set(2, Integer.parseInt(string.substring(n2, n2 + 2)) - 1);
            if (!Character.isDigit(string.charAt(n2 += 2))) {
                ++n2;
            }
            calendar.set(5, Integer.parseInt(string.substring(n2)));
            if (bl) {
                DateUtils.ceil(calendar, 5);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(string);
        }
        return calendar.getTime();
    }

    public static Date parseTM(TimeZone timeZone, String string, DatePrecision datePrecision) {
        return DateUtils.parseTM(timeZone, string, false, datePrecision);
    }

    public static Date parseTM(TimeZone timeZone, String string, boolean bl, DatePrecision datePrecision) {
        return DateUtils.parseTM(DateUtils.cal(timeZone), string, bl, datePrecision);
    }

    private static Date parseTM(Calendar calendar, String string, boolean bl, DatePrecision datePrecision) {
        int n = 0;
        int n2 = string.length();
        if (n + 2 > n2) {
            throw new IllegalArgumentException(string);
        }
        try {
            datePrecision.lastField = 11;
            calendar.set(11, Integer.parseInt(string.substring(n, n + 2)));
            if ((n += 2) < n2) {
                if (!Character.isDigit(string.charAt(n))) {
                    ++n;
                }
                if (n + 2 > n2) {
                    throw new IllegalArgumentException(string);
                }
                datePrecision.lastField = 12;
                calendar.set(12, Integer.parseInt(string.substring(n, n + 2)));
                if ((n += 2) < n2) {
                    if (!Character.isDigit(string.charAt(n))) {
                        ++n;
                    }
                    if (n + 2 > n2) {
                        throw new IllegalArgumentException(string);
                    }
                    datePrecision.lastField = 13;
                    calendar.set(13, Integer.parseInt(string.substring(n, n + 2)));
                    if ((n += 2) < n2) {
                        float f = Float.parseFloat(string.substring(n));
                        if (f >= 1.0f || f < 0.0f) {
                            throw new IllegalArgumentException(string);
                        }
                        datePrecision.lastField = 14;
                        calendar.set(14, (int)(f * 1000.0f));
                        return calendar.getTime();
                    }
                }
            }
            if (bl) {
                DateUtils.ceil(calendar, datePrecision.lastField);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(string);
        }
        return calendar.getTime();
    }

    public static Date parseDT(TimeZone timeZone, String string, DatePrecision datePrecision) {
        return DateUtils.parseDT(timeZone, string, false, datePrecision);
    }

    public static TimeZone timeZone(String string) {
        TimeZone timeZone;
        if (string.length() != 5 || (timeZone = DateUtils.safeTimeZone(string)) == null) {
            throw new IllegalArgumentException("Illegal Timezone Offset: " + string);
        }
        return timeZone;
    }

    private static TimeZone safeTimeZone(String string) {
        String string2 = DateUtils.tzid(string);
        if (string2 == null) {
            return null;
        }
        TimeZone timeZone = cachedTimeZone;
        if (timeZone == null || !timeZone.getID().equals(string2)) {
            cachedTimeZone = timeZone = TimeZone.getTimeZone(string2);
        }
        return timeZone;
    }

    private static String tzid(String string) {
        int n = string.length();
        if (n > 4) {
            char[] cArray = new char[9];
            cArray[0] = 71;
            cArray[1] = 77;
            cArray[2] = 84;
            cArray[6] = 58;
            char[] cArray2 = cArray;
            string.getChars(n - 5, n - 2, cArray2, 3);
            string.getChars(n - 2, n, cArray2, 7);
            if ((cArray2[3] == '+' || cArray2[3] == '-') && Character.isDigit(cArray2[4]) && Character.isDigit(cArray2[5]) && Character.isDigit(cArray2[7]) && Character.isDigit(cArray2[8])) {
                return new String(cArray2);
            }
        }
        return null;
    }

    public static Date parseDT(TimeZone timeZone, String string, boolean bl, DatePrecision datePrecision) {
        int n = string.length();
        TimeZone timeZone2 = DateUtils.safeTimeZone(string);
        datePrecision.includeTimezone = timeZone2 != null;
        if (datePrecision.includeTimezone) {
            n -= 5;
            timeZone = timeZone2;
        }
        Calendar calendar = DateUtils.cal(timeZone);
        try {
            int n2 = 0;
            if (n2 + 4 > n) {
                throw new IllegalArgumentException(string);
            }
            datePrecision.lastField = 1;
            calendar.set(1, Integer.parseInt(string.substring(n2, n2 + 4)));
            if ((n2 += 4) < n) {
                if (!Character.isDigit(string.charAt(n2))) {
                    ++n2;
                }
                if (n2 + 2 > n) {
                    throw new IllegalArgumentException(string);
                }
                datePrecision.lastField = 2;
                calendar.set(2, Integer.parseInt(string.substring(n2, n2 + 2)) - 1);
                if ((n2 += 2) < n) {
                    if (!Character.isDigit(string.charAt(n2))) {
                        ++n2;
                    }
                    if (n2 + 2 > n) {
                        throw new IllegalArgumentException(string);
                    }
                    datePrecision.lastField = 5;
                    calendar.set(5, Integer.parseInt(string.substring(n2, n2 + 2)));
                    if ((n2 += 2) < n) {
                        return DateUtils.parseTM(calendar, string.substring(n2, n), bl, datePrecision);
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(string);
        }
        if (bl) {
            DateUtils.ceil(calendar, datePrecision.lastField);
        }
        return calendar.getTime();
    }
}

