/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.pdu;

import java.io.UnsupportedEncodingException;
import org.dcm4che3.util.StringUtils;

public class UserIdentityRQ {
    public static final int USERNAME = 1;
    public static final int USERNAME_PASSCODE = 2;
    public static final int KERBEROS = 3;
    public static final int SAML = 4;
    private static final String[] TYPES = new String[]{"0", "1 - Username", "2 - Username and passcode", "3 - Kerberos Service ticket", "4 - SAML Assertion"};
    private final int type;
    private final boolean rspReq;
    private final byte[] primaryField;
    private final byte[] secondaryField;

    public UserIdentityRQ(int n, boolean bl, byte[] byArray, byte[] byArray2) {
        this.type = n;
        this.rspReq = bl;
        this.primaryField = (byte[])byArray.clone();
        this.secondaryField = byArray2 != null ? (byte[])byArray2.clone() : new byte[]{};
    }

    public UserIdentityRQ(int n, boolean bl, byte[] byArray) {
        this(n, bl, byArray, null);
    }

    public UserIdentityRQ(String string, char[] cArray) {
        this(2, true, UserIdentityRQ.toBytes(string), UserIdentityRQ.toBytes(new String(cArray)));
    }

    public UserIdentityRQ(String string, boolean bl) {
        this(1, bl, UserIdentityRQ.toBytes(string));
    }

    private static String typeAsString(int n) {
        try {
            return TYPES[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return Integer.toString(n);
        }
    }

    public final int getType() {
        return this.type;
    }

    public final boolean isPositiveResponseRequested() {
        return this.rspReq;
    }

    public final byte[] getPrimaryField() {
        return (byte[])this.primaryField.clone();
    }

    public final byte[] getSecondaryField() {
        return (byte[])this.secondaryField.clone();
    }

    public final String getUsername() {
        return UserIdentityRQ.toString(this.primaryField);
    }

    public final char[] getPasscode() {
        return UserIdentityRQ.toString(this.secondaryField).toCharArray();
    }

    private static byte[] toBytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error(unsupportedEncodingException);
        }
    }

    private static String toString(byte[] byArray) {
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error(unsupportedEncodingException);
        }
    }

    public int length() {
        return 6 + this.primaryField.length + this.secondaryField.length;
    }

    public String toString() {
        return this.promptTo(new StringBuilder()).toString();
    }

    StringBuilder promptTo(StringBuilder stringBuilder) {
        stringBuilder.append("  UserIdentity[").append(StringUtils.LINE_SEPARATOR).append("    type: ").append(UserIdentityRQ.typeAsString(this.type)).append(StringUtils.LINE_SEPARATOR);
        if (this.type == 1 || this.type == 2) {
            stringBuilder.append("    username: ").append(this.getUsername());
        } else {
            stringBuilder.append("    primaryField: byte[").append(this.primaryField.length).append(']');
        }
        if (this.type == 2) {
            stringBuilder.append(StringUtils.LINE_SEPARATOR).append("    passcode: ");
            int n = this.secondaryField.length;
            while (--n >= 0) {
                stringBuilder.append('*');
            }
        } else if (this.secondaryField.length > 0) {
            stringBuilder.append(StringUtils.LINE_SEPARATOR).append("    secondaryField: byte[").append(this.secondaryField.length).append(']');
        }
        return stringBuilder.append(StringUtils.LINE_SEPARATOR).append("  ]");
    }
}

