/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.pdu;

import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.UIDUtils;

public class ExtendedNegotiation {
    private final String cuid;
    private final byte[] info;

    public ExtendedNegotiation(String string, byte[] byArray) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.cuid = string;
        this.info = (byte[])byArray.clone();
    }

    public final String getSOPClassUID() {
        return this.cuid;
    }

    public final byte[] getInformation() {
        return (byte[])this.info.clone();
    }

    public final byte getField(int n, byte by) {
        return n < this.info.length ? this.info[n] : by;
    }

    public int length() {
        return this.cuid.length() + this.info.length + 2;
    }

    public String toString() {
        return this.promptTo(new StringBuilder()).toString();
    }

    StringBuilder promptTo(StringBuilder stringBuilder) {
        stringBuilder.append("  ExtendedNegotiation[").append(StringUtils.LINE_SEPARATOR).append("    sopClass: ");
        UIDUtils.promptTo(this.cuid, stringBuilder).append(StringUtils.LINE_SEPARATOR).append("    info: [");
        byte[] byArray = this.info;
        int n = this.info.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            stringBuilder.append(by).append(", ");
            ++n2;
        }
        return stringBuilder.append(']').append(StringUtils.LINE_SEPARATOR).append("  ]");
    }
}

