/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.pdu;

import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.UIDUtils;

public class CommonExtendedNegotiation {
    private final String sopCUID;
    private final String serviceCUID;
    private final String[] relSopCUIDs;

    public CommonExtendedNegotiation(String string, String string2, String ... stringArray) {
        if (string == null) {
            throw new NullPointerException("sopCUID");
        }
        if (string2 == null) {
            throw new NullPointerException("serviceCUID");
        }
        this.sopCUID = string;
        this.serviceCUID = string2;
        this.relSopCUIDs = stringArray;
    }

    public final String getSOPClassUID() {
        return this.sopCUID;
    }

    public final String getServiceClassUID() {
        return this.serviceCUID;
    }

    public String[] getRelatedGeneralSOPClassUIDs() {
        return this.relSopCUIDs;
    }

    public int length() {
        return 6 + this.sopCUID.length() + this.serviceCUID.length() + this.getRelatedGeneralSOPClassUIDsLength();
    }

    public String toString() {
        return this.promptTo(new StringBuilder()).toString();
    }

    StringBuilder promptTo(StringBuilder stringBuilder) {
        stringBuilder.append("  CommonExtendedNegotiation[").append(StringUtils.LINE_SEPARATOR).append("    sopClass: ");
        UIDUtils.promptTo(this.sopCUID, stringBuilder).append(StringUtils.LINE_SEPARATOR).append("    serviceClass: ");
        UIDUtils.promptTo(this.serviceCUID, stringBuilder).append(StringUtils.LINE_SEPARATOR);
        if (this.relSopCUIDs.length != 0) {
            stringBuilder.append("    relatedSOPClasses:").append(StringUtils.LINE_SEPARATOR);
            String[] stringArray = this.relSopCUIDs;
            int n = this.relSopCUIDs.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                UIDUtils.promptTo(string, stringBuilder.append("      ")).append(StringUtils.LINE_SEPARATOR);
                ++n2;
            }
        }
        return stringBuilder.append("  ]");
    }

    public int getRelatedGeneralSOPClassUIDsLength() {
        int n = 0;
        String[] stringArray = this.relSopCUIDs;
        int n2 = this.relSopCUIDs.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            n += 2 + string.length();
            ++n3;
        }
        return n;
    }
}

