/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.PersonName;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.Base64;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.TagUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ContentHandlerAdapter
extends DefaultHandler {
    private Attributes fmi;
    private final boolean bigEndian;
    private final LinkedList<Attributes> items = new LinkedList();
    private final LinkedList<Sequence> seqs = new LinkedList();
    private final ByteArrayOutputStream bout = new ByteArrayOutputStream(64);
    private final char[] carry = new char[4];
    private int carryLen;
    private final StringBuilder sb = new StringBuilder(64);
    private final ArrayList<String> values = new ArrayList();
    private PersonName pn;
    private PersonName.Group pnGroup;
    private int tag;
    private String privateCreator;
    private VR vr;
    private BulkData bulkData;
    private Fragments dataFragments;
    private boolean processCharacters;
    private boolean inlineBinary;

    public ContentHandlerAdapter(Attributes attributes) {
        if (attributes == null) {
            throw new NullPointerException();
        }
        this.items.add(attributes);
        this.bigEndian = attributes.bigEndian();
    }

    public Attributes getFileMetaInformation() {
        return this.fmi;
    }

    @Override
    public void startElement(String string, String string2, String string3, org.xml.sax.Attributes attributes) throws SAXException {
        switch (string3.charAt(0)) {
            case 'A': {
                if (!string3.equals("Alphabetic")) break;
                this.startPNGroup(PersonName.Group.Alphabetic);
                break;
            }
            case 'B': {
                if (!string3.equals("BulkData")) break;
                this.bulkData(attributes.getValue("uuid"), attributes.getValue("uri"));
                break;
            }
            case 'D': {
                if (string3.equals("DicomAttribute")) {
                    this.startDicomAttribute((int)Long.parseLong(attributes.getValue("tag"), 16), attributes.getValue("privateCreator"), attributes.getValue("vr"));
                    break;
                }
                if (!string3.equals("DataFragment")) break;
                this.startDataFragment(Integer.parseInt(attributes.getValue("number")));
                break;
            }
            case 'F': {
                if (!string3.equals("FamilyName")) break;
                this.startText();
                break;
            }
            case 'G': {
                if (!string3.equals("GivenName")) break;
                this.startText();
                break;
            }
            case 'I': {
                if (string3.equals("Item")) {
                    this.startItem(Integer.parseInt(attributes.getValue("number")));
                    break;
                }
                if (string3.equals("InlineBinary")) {
                    this.startInlineBinary();
                    break;
                }
                if (!string3.equals("Ideographic")) break;
                this.startPNGroup(PersonName.Group.Ideographic);
                break;
            }
            case 'L': {
                if (!string3.equals("Length")) break;
                this.startText();
                break;
            }
            case 'M': {
                if (!string3.equals("MiddleName")) break;
                this.startText();
                break;
            }
            case 'N': {
                if (!string3.equals("NamePrefix") && !string3.equals("NameSuffix")) break;
                this.startText();
                break;
            }
            case 'O': {
                if (!string3.equals("Offset")) break;
                this.startText();
                break;
            }
            case 'P': {
                if (string3.equals("PersonName")) {
                    this.startPersonName(Integer.parseInt(attributes.getValue("number")));
                    break;
                }
                if (!string3.equals("Phonetic")) break;
                this.startPNGroup(PersonName.Group.Phonetic);
                break;
            }
            case 'T': {
                if (!string3.equals("TransferSyntax")) break;
                this.startText();
                break;
            }
            case 'U': {
                if (!string3.equals("URI")) break;
                this.startText();
                break;
            }
            case 'V': {
                if (!string3.equals("Value")) break;
                this.startValue(Integer.parseInt(attributes.getValue("number")));
                this.startText();
            }
        }
    }

    private void bulkData(String string, String string2) {
        this.bulkData = new BulkData(string, string2, this.items.getLast().bigEndian());
    }

    private void startInlineBinary() {
        this.processCharacters = true;
        this.inlineBinary = true;
        this.bout.reset();
    }

    private void startText() {
        this.processCharacters = true;
        this.inlineBinary = false;
        this.sb.setLength(0);
    }

    private void startDicomAttribute(int n, String string, String string2) {
        this.tag = n;
        this.privateCreator = string;
        VR vR = this.vr = string2 != null ? VR.valueOf(string2) : ElementDictionary.vrOf(n, string);
        if (this.vr == VR.SQ) {
            this.seqs.add(this.items.getLast().newSequence(string, n, 10));
        }
    }

    private void startDataFragment(int n) {
        if (this.dataFragments == null) {
            this.dataFragments = this.items.getLast().newFragments(this.privateCreator, this.tag, this.vr, 10);
        }
        while (this.dataFragments.size() < n - 1) {
            this.dataFragments.add(ByteUtils.EMPTY_BYTES);
        }
    }

    private void startItem(int n) {
        Sequence sequence = this.seqs.getLast();
        while (sequence.size() < n - 1) {
            sequence.add(new Attributes(0));
        }
        Attributes attributes = new Attributes();
        sequence.add(attributes);
        this.items.add(attributes);
    }

    private void startValue(int n) {
        while (this.values.size() < n - 1) {
            this.values.add(null);
        }
    }

    private void startPersonName(int n) {
        this.startValue(n);
        this.pn = new PersonName();
    }

    private void startPNGroup(PersonName.Group group) {
        this.pnGroup = group;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.processCharacters) {
            if (this.inlineBinary) {
                try {
                    if (this.carryLen != 0) {
                        int n3 = 4 - this.carryLen;
                        System.arraycopy(cArray, n, this.carry, this.carryLen, n3);
                        Base64.decode(this.carry, 0, 4, this.bout);
                        n += n3;
                        n2 -= n3;
                    }
                    if ((this.carryLen = n2 & 3) != 0) {
                        System.arraycopy(cArray, n + (n2 -= this.carryLen), this.carry, 0, this.carryLen);
                    }
                    Base64.decode(cArray, n, n2, this.bout);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            } else {
                this.sb.append(cArray, n, n2);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        switch (string3.charAt(0)) {
            case 'D': {
                if (string3.equals("DicomAttribute")) {
                    this.endDicomAttribute();
                    break;
                }
                if (!string3.equals("DataFragment")) break;
                this.endDataFragment();
                break;
            }
            case 'F': {
                if (!string3.equals("FamilyName")) break;
                this.endPNComponent(PersonName.Component.FamilyName);
                break;
            }
            case 'G': {
                if (!string3.equals("GivenName")) break;
                this.endPNComponent(PersonName.Component.GivenName);
                break;
            }
            case 'I': {
                if (!string3.equals("Item")) break;
                this.endItem();
                break;
            }
            case 'M': {
                if (!string3.equals("MiddleName")) break;
                this.endPNComponent(PersonName.Component.MiddleName);
                break;
            }
            case 'N': {
                if (string3.equals("NamePrefix")) {
                    this.endPNComponent(PersonName.Component.NamePrefix);
                    break;
                }
                if (!string3.equals("NameSuffix")) break;
                this.endPNComponent(PersonName.Component.NameSuffix);
                break;
            }
            case 'P': {
                if (!string3.equals("PersonName")) break;
                this.endPersonName();
                break;
            }
            case 'V': {
                if (!string3.equals("Value")) break;
                this.endValue();
            }
        }
        this.processCharacters = false;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.fmi != null) {
            this.fmi.trimToSize();
        }
        this.items.getFirst().trimToSize();
    }

    private void endDataFragment() {
        if (this.bulkData != null) {
            this.dataFragments.add(this.bulkData);
            this.bulkData = null;
        } else {
            this.dataFragments.add(this.getBytes());
        }
    }

    private void endDicomAttribute() {
        if (this.vr == VR.SQ) {
            this.seqs.removeLast().trimToSize();
            return;
        }
        if (this.dataFragments != null) {
            this.dataFragments.trimToSize();
            this.dataFragments = null;
            return;
        }
        Attributes attributes = this.items.getLast();
        if (TagUtils.isFileMetaInformation(this.tag)) {
            if (this.fmi == null) {
                this.fmi = new Attributes();
            }
            attributes = this.fmi;
        }
        if (this.bulkData != null) {
            attributes.setValue(this.privateCreator, this.tag, this.vr, this.bulkData);
            this.bulkData = null;
        } else if (this.inlineBinary) {
            attributes.setBytes(this.privateCreator, this.tag, this.vr, this.getBytes());
        } else {
            attributes.setString(this.privateCreator, this.tag, this.vr, this.getStrings());
        }
    }

    private void endItem() {
        this.items.removeLast().trimToSize();
        this.vr = VR.SQ;
    }

    private void endPersonName() {
        this.values.add(this.pn.toString());
        this.pn = null;
    }

    private void endValue() {
        this.values.add(this.getString());
    }

    private void endPNComponent(PersonName.Component component) {
        this.pn.set(this.pnGroup, component, this.getString());
    }

    private String getString() {
        return this.sb.toString();
    }

    private byte[] getBytes() {
        byte[] byArray = this.bout.toByteArray();
        return this.bigEndian ? this.vr.toggleEndian(byArray, false) : byArray;
    }

    private String[] getStrings() {
        try {
            String[] stringArray = this.values.toArray(new String[this.values.size()]);
            return stringArray;
        }
        finally {
            this.values.clear();
        }
    }
}

