/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.io;

import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ItemPointer;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.TagUtils;

public abstract class BulkDataDescriptor {
    public static final BulkDataDescriptor DEFAULT = new BulkDataDescriptor(){

        @Override
        public boolean isBulkData(List<ItemPointer> list, String string, int n, VR vR, int n2) {
            switch (TagUtils.normalizeRepeatingGroup(n)) {
                case 2654176: 
                case 4325393: 
                case 1342185484: 
                case 0x50003000: 
                case 1442840608: 
                case 0x60003000: 
                case 2145386512: {
                    return list.isEmpty();
                }
                case 1409290256: {
                    return list.size() == 1 && list.get((int)0).sequenceTag == 1409286400;
                }
            }
            return false;
        }
    };
    public static final BulkDataDescriptor PIXELDATA = new BulkDataDescriptor(){

        @Override
        public boolean isBulkData(List<ItemPointer> list, String string, int n, VR vR, int n2) {
            return n == 2145386512;
        }
    };

    public static BulkDataDescriptor valueOf(final Attributes attributes) {
        return new BulkDataDescriptor(){

            @Override
            public boolean isBulkData(List<ItemPointer> list, String string, int n, VR vR, int n2) {
                Attributes attributes2 = attributes;
                for (ItemPointer itemPointer : list) {
                    attributes2 = attributes2.getNestedDataset(itemPointer.privateCreator, itemPointer.sequenceTag, itemPointer.itemIndex);
                }
                return attributes2.contains(string, n);
            }
        };
    }

    public abstract boolean isBulkData(List<ItemPointer> var1, String var2, int var3, VR var4, int var5);
}

