/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.stream;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.Fragments;

public class SegmentedInputImageStream
extends ImageInputStreamImpl {
    private final ImageInputStream stream;
    private final long[] segmentPositionsList;
    private final int[] segmentLengths;
    private int curSegment;
    private long curSegmentEnd;

    public SegmentedInputImageStream(ImageInputStream imageInputStream, Fragments fragments, int n) throws IOException {
        long[] lArray = new long[fragments.size() - (n + 1)];
        int[] nArray = new int[lArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            BulkData bulkData = (BulkData)fragments.get(n2 + n + 1);
            lArray[n2] = bulkData.offset;
            nArray[n2] = bulkData.length;
            ++n2;
        }
        this.stream = imageInputStream;
        this.segmentPositionsList = lArray;
        this.segmentLengths = nArray;
        this.seek(0L);
    }

    public SegmentedInputImageStream(ImageInputStream imageInputStream, long[] lArray, int[] nArray) throws IOException {
        this.stream = imageInputStream;
        this.segmentPositionsList = (long[])lArray.clone();
        this.segmentLengths = (int[])nArray.clone();
        this.seek(0L);
    }

    private int offsetOf(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += this.segmentLengths[n3];
            ++n3;
        }
        return n2;
    }

    @Override
    public void seek(long l) throws IOException {
        super.seek(l);
        int n = 0;
        int n2 = 0;
        while (n < this.segmentLengths.length) {
            int n3 = n2 + this.segmentLengths[n];
            if (l < (long)n3) {
                this.stream.seek(this.segmentPositionsList[n] + l - (long)n2);
                this.curSegment = n;
                this.curSegmentEnd = n3;
                return;
            }
            n2 = n3;
            ++n;
        }
        this.curSegment = -1;
    }

    @Override
    public int read() throws IOException {
        if (!this.prepareRead()) {
            return -1;
        }
        this.bitOffset = 0;
        int n = this.stream.read();
        if (n != -1) {
            ++this.streamPos;
        }
        return n;
    }

    private boolean prepareRead() throws IOException {
        if (this.curSegment < 0) {
            return false;
        }
        if (this.streamPos < this.curSegmentEnd) {
            return true;
        }
        if (this.curSegment >= this.segmentPositionsList.length) {
            return false;
        }
        this.seek(this.offsetOf(this.curSegment + 1));
        return true;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.prepareRead()) {
            return -1;
        }
        this.bitOffset = 0;
        int n3 = this.stream.read(byArray, n, Math.min(n2, (int)(this.curSegmentEnd - this.streamPos)));
        if (n3 != -1) {
            this.streamPos += (long)n3;
        }
        return n3;
    }
}

