/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec.jpeg;

import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;
import org.dcm4che3.imageio.codec.jpeg.JPEGLSCodingParam;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchJPEGLSImageOutputStream
extends ImageOutputStreamImpl {
    private static final Logger LOG = LoggerFactory.getLogger(PatchJPEGLSImageOutputStream.class);
    private final ImageOutputStream ios;
    private final PatchJPEGLS patchJpegLS;
    private byte[] jpegheader;
    private int jpegheaderIndex;

    public PatchJPEGLSImageOutputStream(ImageOutputStream imageOutputStream, PatchJPEGLS patchJPEGLS) throws IOException {
        if (imageOutputStream == null) {
            throw new NullPointerException("ios");
        }
        this.streamPos = imageOutputStream.getStreamPosition();
        this.flushedPos = imageOutputStream.getFlushedPosition();
        this.ios = imageOutputStream;
        this.patchJpegLS = patchJPEGLS;
        this.jpegheader = patchJPEGLS != null ? new byte[256] : null;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.jpegheader == null) {
            this.ios.write(byArray, n, n2);
        } else {
            int n3 = Math.min(this.jpegheader.length - this.jpegheaderIndex, n2);
            System.arraycopy(byArray, n, this.jpegheader, this.jpegheaderIndex, n3);
            this.jpegheaderIndex += n3;
            if (this.jpegheaderIndex >= this.jpegheader.length) {
                JPEGLSCodingParam jPEGLSCodingParam = this.patchJpegLS.createJPEGLSCodingParam(this.jpegheader);
                if (jPEGLSCodingParam == null) {
                    this.ios.write(this.jpegheader);
                } else {
                    LOG.debug("Patch JPEG-LS with {}", (Object)jPEGLSCodingParam);
                    int n4 = jPEGLSCodingParam.getOffset();
                    this.ios.write(this.jpegheader, 0, n4);
                    this.ios.write(jPEGLSCodingParam.getBytes());
                    this.ios.write(this.jpegheader, n4, this.jpegheader.length - n4);
                }
                this.ios.write(byArray, n + n3, n2 - n3);
                this.jpegheader = null;
            }
        }
        this.streamPos += (long)n2;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n) throws IOException {
        if (this.jpegheader == null) {
            this.ios.write(n);
            ++this.streamPos;
        } else {
            this.write(new byte[]{(byte)n}, 0, 1);
        }
    }

    @Override
    public int read() throws IOException {
        return this.ios.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.ios.read(byArray, n, n2);
    }
}

