/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec.jpeg;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import org.dcm4che3.imageio.codec.jpeg.JPEGLSCodingParam;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchJPEGLSImageInputStream
extends ImageInputStreamImpl {
    private static final Logger LOG = LoggerFactory.getLogger(PatchJPEGLSImageInputStream.class);
    private final ImageInputStream iis;
    private long patchPos;
    private byte[] patch;

    public PatchJPEGLSImageInputStream(ImageInputStream imageInputStream, PatchJPEGLS patchJPEGLS) throws IOException {
        if (imageInputStream == null) {
            throw new NullPointerException("iis");
        }
        this.streamPos = imageInputStream.getStreamPosition();
        this.flushedPos = imageInputStream.getFlushedPosition();
        this.iis = imageInputStream;
        if (patchJPEGLS == null) {
            return;
        }
        byte[] byArray = new byte[256];
        imageInputStream.mark();
        imageInputStream.readFully(byArray);
        imageInputStream.reset();
        JPEGLSCodingParam jPEGLSCodingParam = patchJPEGLS.createJPEGLSCodingParam(byArray);
        if (jPEGLSCodingParam != null) {
            LOG.debug("Patch JPEG-LS with {}", (Object)jPEGLSCodingParam);
            this.patchPos = this.streamPos + (long)jPEGLSCodingParam.getOffset();
            this.patch = jPEGLSCodingParam.getBytes();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.iis.close();
    }

    @Override
    public void flushBefore(long l) throws IOException {
        super.flushBefore(l);
        this.iis.flushBefore(this.adjustStreamPosition(l));
    }

    private long adjustStreamPosition(long l) {
        if (this.patch == null) {
            return l;
        }
        long l2 = l - this.patchPos;
        return l2 < 0L ? l : (l2 < (long)this.patch.length ? this.patchPos : l - (long)this.patch.length);
    }

    @Override
    public boolean isCached() {
        return this.iis.isCached();
    }

    @Override
    public boolean isCachedFile() {
        return this.iis.isCachedFile();
    }

    @Override
    public boolean isCachedMemory() {
        return this.iis.isCachedMemory();
    }

    @Override
    public long length() {
        try {
            long l = this.iis.length();
            return this.patch == null || l < 0L ? l : l + (long)this.patch.length;
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public int read() throws IOException {
        long l;
        int n = this.patch != null && (l = this.streamPos - this.patchPos) >= 0L && l < (long)this.patch.length ? this.patch[(int)l] : this.iis.read();
        if (n >= 0) {
            ++this.streamPos;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        if (this.patch != null && this.streamPos < this.patchPos + (long)this.patch.length) {
            if (this.streamPos < this.patchPos) {
                n4 = this.iis.read(byArray, n, (int)Math.min(this.patchPos - this.streamPos, (long)n2));
                if (n4 < 0) {
                    return n4;
                }
                this.streamPos += (long)n4;
                if (this.streamPos < this.patchPos) {
                    return n4;
                }
                n += n4;
                n2 -= n4;
            }
            n3 = (int)(this.patchPos - this.streamPos);
            int n5 = Math.min(this.patch.length - n3, n2);
            System.arraycopy(this.patch, n3, byArray, n, n5);
            this.streamPos += (long)n5;
            n4 += n5;
            n += n5;
            n2 -= n5;
        }
        if (n2 > 0) {
            n3 = this.iis.read(byArray, n, n2);
            if (n3 < 0) {
                return n3;
            }
            this.streamPos += (long)n3;
            n4 += n3;
        }
        return n4;
    }

    @Override
    public void mark() {
        super.mark();
        this.iis.mark();
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.iis.reset();
    }

    @Override
    public void seek(long l) throws IOException {
        super.seek(l);
        this.iis.seek(this.adjustStreamPosition(l));
    }
}

