/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec.jpeg;

import org.dcm4che3.imageio.codec.jpeg.JPEG;
import org.dcm4che3.util.ByteUtils;

public class JPEGHeader {
    private final byte[] data;
    private final int[] offsets;

    public JPEGHeader(byte[] byArray, int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        while ((n4 = JPEGHeader.nextMarker(byArray, n4)) != -1) {
            ++n3;
            if (JPEG.isStandalone(n2 = byArray[n4++] & 0xFF)) continue;
            if (n4 + 1 >= byArray.length || n2 == n) break;
            n4 += ByteUtils.bytesToUShortBE(byArray, n4);
        }
        this.data = byArray;
        this.offsets = new int[n3];
        n4 = 0;
        n2 = 0;
        while (n4 < n3) {
            this.offsets[n4] = n2 = JPEGHeader.nextMarker(byArray, n2);
            if (!JPEG.isStandalone(n2++ & 0xFF)) {
                n2 += ByteUtils.bytesToUShortBE(byArray, n2);
            }
            ++n4;
        }
    }

    private static int nextMarker(byte[] byArray, int n) {
        int n2 = n + 1;
        while (n2 < byArray.length) {
            if (byArray[n2 - 1] == -1 && byArray[n2] != -1 && byArray[n2] != 0) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int offsetOf(int n) {
        int n2 = 0;
        while (n2 < this.offsets.length) {
            if ((this.data[this.offsets[n2]] & 0xFF) == n) {
                return this.offsets[n2];
            }
            ++n2;
        }
        return -1;
    }

    public int numberOfMarkers() {
        return this.offsets.length;
    }
}

