/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLS;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StringUtils;

public class ImageReaderFactory
implements Serializable {
    private static final long serialVersionUID = -2881173333124498212L;
    private static ImageReaderFactory defaultFactory;
    private final HashMap<String, ImageReaderParam> map = new HashMap();

    private static String nullify(String string) {
        return string == null || string.isEmpty() || string.equals("*") ? null : string;
    }

    public static ImageReaderFactory getDefault() {
        if (defaultFactory == null) {
            defaultFactory = ImageReaderFactory.initDefault();
        }
        return defaultFactory;
    }

    public static void resetDefault() {
        defaultFactory = null;
    }

    public static void setDefault(ImageReaderFactory imageReaderFactory) {
        if (imageReaderFactory == null) {
            throw new NullPointerException();
        }
        defaultFactory = imageReaderFactory;
    }

    private static ImageReaderFactory initDefault() {
        ImageReaderFactory imageReaderFactory = new ImageReaderFactory();
        String string = System.getProperty(ImageReaderFactory.class.getName(), "org/dcm4che3/imageio/codec/ImageReaderFactory.properties");
        try {
            imageReaderFactory.load(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to load Image Reader Factory configuration from: " + string, exception);
        }
        return imageReaderFactory;
    }

    public void load(String string) throws IOException {
        URL uRL;
        block5: {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                uRL = Thread.currentThread().getContextClassLoader().getResource(string);
                if (uRL != null) break block5;
                throw new IOException("No such resource: " + string);
            }
        }
        InputStream inputStream = uRL.openStream();
        try {
            this.load(inputStream);
        }
        finally {
            SafeClose.close(inputStream);
        }
    }

    public void load(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String[] stringArray = StringUtils.split((String)entry.getValue(), ':');
            this.map.put((String)entry.getKey(), new ImageReaderParam(stringArray[0], stringArray[1], stringArray[2]));
        }
    }

    public ImageReaderParam get(String string) {
        return this.map.get(string);
    }

    public boolean contains(String string) {
        return this.map.containsKey(string);
    }

    public ImageReaderParam put(String string, ImageReaderParam imageReaderParam) {
        return this.map.put(string, imageReaderParam);
    }

    public ImageReaderParam remove(String string) {
        return this.map.remove(string);
    }

    public Set<Map.Entry<String, ImageReaderParam>> getEntries() {
        return Collections.unmodifiableMap(this.map).entrySet();
    }

    public void clear() {
        this.map.clear();
    }

    public static ImageReaderParam getImageReaderParam(String string) {
        return ImageReaderFactory.getDefault().get(string);
    }

    public static boolean canDecompress(String string) {
        return ImageReaderFactory.getDefault().contains(string);
    }

    public static ImageReader getImageReader(ImageReaderParam imageReaderParam) {
        Iterator<ImageReaderSpi> iterator = ServiceLoader.load(ImageReaderSpi.class).iterator();
        try {
            if (iterator != null && iterator.hasNext()) {
                String string = imageReaderParam.className;
                if (string == null) {
                    return iterator.next().createReaderInstance();
                }
                do {
                    ImageReader imageReader;
                    ImageReaderSpi imageReaderSpi;
                    if (!ImageReaderFactory.supportsFormat((imageReaderSpi = iterator.next()).getFormatNames(), imageReaderParam.formatName) || !(imageReader = imageReaderSpi.createReaderInstance()).getClass().getName().equals(string)) continue;
                    return imageReader;
                } while (iterator.hasNext());
            }
            throw new RuntimeException("No Image Reader for format: " + imageReaderParam.formatName + " registered");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error instantiating Reader for format: " + imageReaderParam.formatName);
        }
    }

    private static boolean supportsFormat(String[] stringArray, String string) {
        boolean bl = false;
        if (string != null && stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null && stringArray[n].trim().equalsIgnoreCase(string.trim())) {
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    public static class ImageReaderParam
    implements Serializable {
        private static final long serialVersionUID = 6593724836340684578L;
        public final String formatName;
        public final String className;
        public final PatchJPEGLS patchJPEGLS;

        public ImageReaderParam(String string, String string2, String string3) {
            this.formatName = string;
            this.className = ImageReaderFactory.nullify(string2);
            this.patchJPEGLS = string3 != null && !string3.isEmpty() ? PatchJPEGLS.valueOf(string3) : null;
        }
    }
}

