/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.image;

import org.dcm4che3.image.LookupTable;
import org.dcm4che3.image.StoredValue;

public class ShortLookupTable
extends LookupTable {
    private final short[] lut;

    ShortLookupTable(StoredValue storedValue, int n, int n2, short[] sArray) {
        super(storedValue, n, n2);
        this.lut = sArray;
    }

    ShortLookupTable(StoredValue storedValue, int n, int n2, int n3, boolean bl) {
        this(storedValue, n, n2, new short[n3]);
        int n4 = (1 << n) - 1;
        int n5 = n3 - 1;
        int n6 = n3 / 2;
        if (bl) {
            int n7 = 0;
            while (n7 < n3) {
                this.lut[n5 - n7] = (short)((n7 * n4 + n6) / n5);
                ++n7;
            }
        } else {
            int n8 = 0;
            while (n8 < n3) {
                this.lut[n8] = (short)((n8 * n4 + n6) / n5);
                ++n8;
            }
        }
    }

    @Override
    public int length() {
        return this.lut.length;
    }

    @Override
    public void lookup(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n;
        int n5 = n + n3;
        int n6 = n2;
        while (n4 < n5) {
            byArray2[n6++] = (byte)this.lut[this.index(byArray[n4++] & 0xFF)];
        }
    }

    private int index(int n) {
        int n2 = this.inBits.valueOf(n) - this.offset;
        return Math.min(Math.max(0, n2), this.lut.length - 1);
    }

    @Override
    public void lookup(short[] sArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = n;
        int n5 = n + n3;
        int n6 = n2;
        while (n4 < n5) {
            byArray[n6++] = (byte)this.lut[this.index(sArray[n4++] & 0xFFFF)];
        }
    }

    @Override
    public void lookup(byte[] byArray, int n, short[] sArray, int n2, int n3) {
        int n4 = n;
        int n5 = n + n3;
        int n6 = n2;
        while (n4 < n5) {
            sArray[n6++] = this.lut[this.index(byArray[n4++] & 0xFF)];
        }
    }

    @Override
    public void lookup(short[] sArray, int n, short[] sArray2, int n2, int n3) {
        int n4 = n;
        int n5 = n + n3;
        int n6 = n2;
        while (n4 < n5) {
            sArray2[n6++] = this.lut[this.index(sArray[n4++] & 0xFFFF)];
        }
    }

    @Override
    public LookupTable adjustOutBits(int n) {
        int n2 = n - this.outBits;
        if (n2 != 0) {
            short[] sArray = this.lut;
            if (n2 < 0) {
                n2 = -n2;
                int n3 = 0;
                while (n3 < sArray.length) {
                    sArray[n3] = (short)((sArray[n3] & 0xFFFF) >> n2);
                    ++n3;
                }
            } else {
                int n4 = 0;
                while (n4 < sArray.length) {
                    int n5 = n4++;
                    sArray[n5] = (short)(sArray[n5] << n2);
                }
            }
            this.outBits = n;
        }
        return this;
    }

    @Override
    public void inverse() {
        short[] sArray = this.lut;
        int n = (1 << this.outBits) - 1;
        int n2 = 0;
        while (n2 < sArray.length) {
            sArray[n2] = (short)(n - sArray[n2]);
            ++n2;
        }
    }

    @Override
    public LookupTable combine(LookupTable lookupTable) {
        short[] sArray = this.lut;
        lookupTable.lookup(sArray, 0, sArray, 0, sArray.length);
        this.outBits = lookupTable.outBits;
        return this;
    }
}

