/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.image;

import org.dcm4che3.image.LookupTable;
import org.dcm4che3.image.ShortLookupTable;
import org.dcm4che3.image.StoredValue;

public class ByteLookupTable
extends LookupTable {
    private final byte[] lut;

    ByteLookupTable(StoredValue storedValue, int n, int n2, byte[] byArray) {
        super(storedValue, n, n2);
        this.lut = byArray;
    }

    ByteLookupTable(StoredValue storedValue, int n, int n2, int n3, boolean bl) {
        this(storedValue, n, n2, new byte[n3]);
        int n4 = (1 << n) - 1;
        int n5 = n3 - 1;
        int n6 = n5 / 2;
        if (bl) {
            int n7 = 0;
            while (n7 < n3) {
                this.lut[n5 - n7] = (byte)((n7 * n4 + n6) / n5);
                ++n7;
            }
        } else {
            int n8 = 0;
            while (n8 < n3) {
                this.lut[n8] = (byte)((n8 * n4 + n6) / n5);
                ++n8;
            }
        }
    }

    @Override
    public int length() {
        return this.lut.length;
    }

    @Override
    public void lookup(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n;
        int n5 = n + n3;
        int n6 = n2;
        while (n4 < n5) {
            byArray2[n6++] = this.lut[this.index(byArray[n4++])];
        }
    }

    private int index(int n) {
        int n2 = this.inBits.valueOf(n) - this.offset;
        return Math.min(Math.max(0, n2), this.lut.length - 1);
    }

    @Override
    public void lookup(short[] sArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = n;
        int n5 = n + n3;
        int n6 = n2;
        while (n4 < n5) {
            byArray[n6++] = this.lut[this.index(sArray[n4++])];
        }
    }

    @Override
    public void lookup(byte[] byArray, int n, short[] sArray, int n2, int n3) {
        int n4 = n;
        int n5 = n + n3;
        int n6 = n2;
        while (n4 < n5) {
            sArray[n6++] = (short)(this.lut[this.index(byArray[n4++])] & 0xFF);
        }
    }

    @Override
    public void lookup(short[] sArray, int n, short[] sArray2, int n2, int n3) {
        int n4 = n;
        int n5 = n + n3;
        int n6 = n2;
        while (n4 < n5) {
            sArray2[n6++] = (short)(this.lut[this.index(sArray[n4++])] & 0xFF);
        }
    }

    @Override
    public LookupTable adjustOutBits(int n) {
        int n2 = n - this.outBits;
        if (n2 != 0) {
            byte[] byArray = this.lut;
            if (n > 8) {
                short[] sArray = new short[byArray.length];
                int n3 = 0;
                while (n3 < byArray.length) {
                    sArray[n3] = (short)((byArray[n3] & 0xFF) << n2);
                    ++n3;
                }
                return new ShortLookupTable(this.inBits, n, this.offset, sArray);
            }
            if (n2 < 0) {
                n2 = -n2;
                int n4 = 0;
                while (n4 < byArray.length) {
                    byArray[n4] = (byte)((byArray[n4] & 0xFF) >> n2);
                    ++n4;
                }
            } else {
                int n5 = 0;
                while (n5 < byArray.length) {
                    int n6 = n5++;
                    byArray[n6] = (byte)(byArray[n6] << n2);
                }
            }
            this.outBits = n;
        }
        return this;
    }

    @Override
    public void inverse() {
        byte[] byArray = this.lut;
        int n = (1 << this.outBits) - 1;
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = (byte)(n - byArray[n2]);
            ++n2;
        }
    }

    @Override
    public LookupTable combine(LookupTable lookupTable) {
        byte[] byArray = this.lut;
        if (lookupTable.outBits > 8) {
            short[] sArray = new short[byArray.length];
            lookupTable.lookup(byArray, 0, sArray, 0, byArray.length);
            return new ShortLookupTable(this.inBits, lookupTable.outBits, this.offset, sArray);
        }
        lookupTable.lookup(byArray, 0, byArray, 0, byArray.length);
        this.outBits = lookupTable.outBits;
        return this;
    }
}

