/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.io.Serializable;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.StringUtils;

public class Issuer
implements Serializable {
    private static final long serialVersionUID = 5350502680059507981L;
    private String localNamespaceEntityID;
    private String universalEntityID;
    private String universalEntityIDType;

    public Issuer(String string, String string2, String string3) {
        this.localNamespaceEntityID = string;
        this.universalEntityID = string2;
        this.universalEntityIDType = string3;
        this.validate();
    }

    public Issuer(String string) {
        this(string, '&');
    }

    public Issuer(String string, char c) {
        String[] stringArray = StringUtils.split(string, c);
        if (stringArray.length > 3) {
            throw new IllegalArgumentException(string);
        }
        this.localNamespaceEntityID = this.emptyToNull(stringArray[0]);
        this.universalEntityID = stringArray.length > 1 ? this.emptyToNull(stringArray[1]) : null;
        this.universalEntityIDType = stringArray.length > 2 ? this.emptyToNull(stringArray[2]) : null;
        this.validate();
    }

    public Issuer(String string, Attributes attributes) {
        this(string, attributes != null ? attributes.getString(4194354) : null, attributes != null ? attributes.getString(0x400033) : null);
    }

    public Issuer(Attributes attributes) {
        this(attributes.getString(4194353), attributes.getString(4194354), attributes.getString(0x400033));
    }

    public Issuer(Issuer issuer) {
        this(issuer.getLocalNamespaceEntityID(), issuer.getUniversalEntityID(), issuer.getUniversalEntityIDType());
    }

    protected Issuer() {
    }

    public static Issuer fromIssuerOfPatientID(Attributes attributes) {
        String string = attributes.getString(0x100021);
        Attributes attributes2 = attributes.getNestedDataset(1048612);
        if (string == null && (attributes2 == null || attributes2.isEmpty())) {
            return null;
        }
        return new Issuer(string, attributes2);
    }

    public static Issuer valueOf(Attributes attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return null;
        }
        return new Issuer(attributes);
    }

    private void validate() {
        if (this.localNamespaceEntityID == null && this.universalEntityID == null) {
            throw new IllegalArgumentException("Missing Local Namespace Entity ID or Universal Entity ID");
        }
        if (this.universalEntityID != null) {
            if (this.universalEntityIDType == null) {
                throw new IllegalArgumentException("Missing Universal Entity ID Type");
            }
        } else if (this.universalEntityIDType != null) {
            throw new IllegalArgumentException("Missing Universal Entity ID");
        }
    }

    private String emptyToNull(String string) {
        return string.isEmpty() ? null : string;
    }

    public final String getLocalNamespaceEntityID() {
        return this.localNamespaceEntityID;
    }

    public final String getUniversalEntityID() {
        return this.universalEntityID;
    }

    public final String getUniversalEntityIDType() {
        return this.universalEntityIDType;
    }

    public int hashCode() {
        return 37 * (37 * this.hashCode(this.localNamespaceEntityID) + this.hashCode(this.universalEntityID)) + this.hashCode(this.universalEntityIDType);
    }

    private int hashCode(String string) {
        return string == null ? 0 : string.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Issuer)) {
            return false;
        }
        Issuer issuer = (Issuer)object;
        return this.equals(this.localNamespaceEntityID, issuer.localNamespaceEntityID) && this.equals(this.universalEntityID, issuer.universalEntityID) && this.equals(this.universalEntityIDType, issuer.universalEntityIDType);
    }

    private boolean equals(String string, String string2) {
        return string == string2 || string != null && string.equals(string2);
    }

    public boolean matches(Issuer issuer) {
        int n;
        int n2;
        if (this == issuer || issuer == null) {
            return true;
        }
        int n3 = this.matches(this.localNamespaceEntityID, issuer.localNamespaceEntityID);
        if (n3 < 0 || (n2 = this.matches(this.universalEntityID, issuer.universalEntityID)) < 0 || (n = this.matches(this.universalEntityIDType, issuer.universalEntityIDType)) < 0) {
            return false;
        }
        return n3 > 0 || n2 > 0 && n > 0;
    }

    private int matches(String string, String string2) {
        return string == null || string2 == null ? 0 : (string.equals(string2) ? 1 : -1);
    }

    public String toString() {
        return this.toString('&');
    }

    public String toString(char c) {
        if (this.universalEntityID == null) {
            return this.localNamespaceEntityID;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.localNamespaceEntityID != null) {
            stringBuilder.append(this.localNamespaceEntityID);
        }
        stringBuilder.append(c);
        stringBuilder.append(this.universalEntityID);
        stringBuilder.append(c);
        stringBuilder.append(this.universalEntityIDType);
        return stringBuilder.toString();
    }

    public Attributes toItem() {
        int n = 0;
        if (this.localNamespaceEntityID != null) {
            ++n;
        }
        if (this.universalEntityID != null) {
            ++n;
        }
        if (this.universalEntityIDType != null) {
            ++n;
        }
        Attributes attributes = new Attributes(n);
        if (this.localNamespaceEntityID != null) {
            attributes.setString(4194353, VR.UT, this.localNamespaceEntityID);
        }
        if (this.universalEntityID != null) {
            attributes.setString(4194354, VR.UT, this.universalEntityID);
        }
        if (this.universalEntityIDType != null) {
            attributes.setString(0x400033, VR.UT, this.universalEntityIDType);
        }
        return attributes;
    }

    public Attributes toIssuerOfPatientID(Attributes attributes) {
        if (attributes == null) {
            attributes = new Attributes(2);
        }
        if (this.localNamespaceEntityID != null) {
            attributes.setString(0x100021, VR.LO, this.localNamespaceEntityID);
        }
        if (this.universalEntityID != null) {
            Attributes attributes2 = new Attributes(2);
            attributes2.setString(4194354, VR.UT, this.universalEntityID);
            attributes2.setString(0x400033, VR.UT, this.universalEntityIDType);
            attributes.newSequence(1048612, 1).add(attributes2);
        }
        return attributes;
    }
}

