/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.ParseException;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.Value;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.util.StringUtils;

public class BulkData
implements Value {
    public static final int MAGIC_LEN = 64507;
    public final String uri;
    public final String uuid;
    private final int uriPathEnd;
    public final boolean bigEndian;
    public final long offset;
    public final int length;

    public BulkData(String string, String string2, boolean bl) {
        Object[] objectArray = new Object[]{string2, 0, -1};
        int n = 0;
        if (string2 != null) {
            if (string != null) {
                throw new IllegalArgumentException("uuid and uri are mutually exclusive");
            }
            try {
                objectArray = new MessageFormat("{0}?offset={1,number}&length={2,number}").parse(string2);
            }
            catch (ParseException parseException) {}
            n = ((String)objectArray[0]).length();
        } else if (string == null) {
            throw new IllegalArgumentException("uuid or uri must be not null");
        }
        this.uuid = string;
        this.uri = string2;
        this.uriPathEnd = n;
        this.offset = ((Number)objectArray[1]).longValue();
        this.length = ((Number)objectArray[2]).intValue();
        this.bigEndian = bl;
    }

    public BulkData(String string, long l, int n, boolean bl) {
        this.uuid = null;
        this.uriPathEnd = string.length();
        this.uri = String.valueOf(string) + "?offset=" + l + "&length=" + n;
        this.offset = l;
        this.length = n;
        this.bigEndian = bl;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    public String toString() {
        return "BulkData[uuid=" + this.uuid + ", uri=" + this.uri + ", bigEndian=" + this.bigEndian + "]";
    }

    public File getFile() {
        try {
            return new File(new URI(this.uriWithoutOffsetAndLength()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException("uri: " + this.uri);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException("uri: " + this.uri);
        }
    }

    public String uriWithoutOffsetAndLength() {
        if (this.uri == null) {
            throw new IllegalStateException("uri: null");
        }
        return this.uri.substring(0, this.uriPathEnd);
    }

    public InputStream openStream() throws IOException {
        if (this.uri == null) {
            throw new IllegalStateException("uri: null");
        }
        if (!this.uri.startsWith("file:")) {
            return new URL(this.uri).openStream();
        }
        FileInputStream fileInputStream = new FileInputStream(this.getFile());
        StreamUtils.skipFully(fileInputStream, this.offset);
        return fileInputStream;
    }

    @Override
    public int calcLength(DicomEncodingOptions dicomEncodingOptions, boolean bl, VR vR) {
        if (this.length == -1) {
            throw new UnsupportedOperationException();
        }
        return this.length + 1 & 0xFFFFFFFE;
    }

    @Override
    public int getEncodedLength(DicomEncodingOptions dicomEncodingOptions, boolean bl, VR vR) {
        return this.length == -1 ? -1 : this.length + 1 & 0xFFFFFFFE;
    }

    @Override
    public byte[] toBytes(VR vR, boolean bl) throws IOException {
        if (this.length == -1) {
            throw new UnsupportedOperationException();
        }
        if (this.length == 0) {
            return ByteUtils.EMPTY_BYTES;
        }
        InputStream inputStream = this.openStream();
        try {
            byte[] byArray = new byte[this.length];
            StreamUtils.readFully(inputStream, byArray, 0, byArray.length);
            if (this.bigEndian != bl) {
                vR.toggleEndian(byArray, false);
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public void writeTo(DicomOutputStream dicomOutputStream, VR vR) throws IOException {
        InputStream inputStream = this.openStream();
        try {
            if (this.bigEndian != dicomOutputStream.isBigEndian()) {
                StreamUtils.copy(inputStream, (OutputStream)dicomOutputStream, this.length, vR.numEndianBytes());
            } else {
                StreamUtils.copy(inputStream, (OutputStream)dicomOutputStream, this.length);
            }
            if ((this.length & 1) != 0) {
                dicomOutputStream.write(vR.paddingByte());
            }
        }
        finally {
            inputStream.close();
        }
    }

    public void serializeTo(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(StringUtils.maskNull(this.uuid, ""));
        objectOutputStream.writeUTF(StringUtils.maskNull(this.uri, ""));
        objectOutputStream.writeBoolean(this.bigEndian);
    }

    public static Value deserializeFrom(ObjectInputStream objectInputStream) throws IOException {
        return new BulkData(StringUtils.maskEmpty(objectInputStream.readUTF(), null), StringUtils.maskEmpty(objectInputStream.readUTF(), null), objectInputStream.readBoolean());
    }
}

