/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.data.DatePrecisions;
import org.dcm4che3.data.DateRange;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.IOD;
import org.dcm4che3.data.Implementation;
import org.dcm4che3.data.ItemPointer;
import org.dcm4che3.data.PersonName;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.SpecificCharacterSet;
import org.dcm4che3.data.TagArrayPool;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.ValidationResult;
import org.dcm4che3.data.Value;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.io.SAXWriter;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.DateUtils;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class Attributes
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Attributes.class);
    private static final byte SLASH = 92;
    private static final byte EXPONENT = 101;
    private static final int MAX_DIGITS = 16;
    private TagArrayPool pool;
    private static final int INIT_CAPACITY = 16;
    private static final int TO_STRING_LIMIT = 50;
    private static final int TO_STRING_WIDTH = 78;
    private transient Attributes parent;
    private transient int[] tags;
    private transient VR[] vrs;
    private transient Object[] values;
    private transient int size;
    private transient SpecificCharacterSet cs;
    private transient TimeZone tz;
    private transient int length = -1;
    private transient int[] groupLengths;
    private transient int groupLengthIndex0;
    private final boolean bigEndian;
    private long itemPosition = -1L;
    private boolean containsSpecificCharacterSet;
    private boolean containsTimezoneOffsetFromUTC;
    private Map<String, Object> properties;
    private TimeZone defaultTimeZone;
    private static final long serialVersionUID = 7868714416968825241L;

    public Attributes(TagArrayPool tagArrayPool) {
        this.pool = tagArrayPool;
        this.bigEndian = false;
        this.init(0);
    }

    public Attributes(int[] nArray, VR[] vRArray, Object[] objectArray, int n) {
        this.tags = nArray;
        this.vrs = vRArray;
        this.values = objectArray;
        this.size = n;
        this.bigEndian = false;
    }

    public void initWithBytes(int n, VR vR, byte[] byArray) {
        Value value;
        Value value2 = value = byArray != null && byArray.length > 0 ? (Value)byArray : Value.NULL;
        if ((n & 0xFFFF) == 0) {
            return;
        }
        if (this.size == this.tags.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.tags[this.size] = n;
        this.vrs[this.size] = vR;
        this.values[this.size] = value;
        ++this.size;
        if (n == 524293) {
            this.containsSpecificCharacterSet = true;
            this.cs = null;
        } else if (n == 524801) {
            this.containsTimezoneOffsetFromUTC = value != Value.NULL;
            this.tz = null;
        }
    }

    public VR vrOf(int n) {
        return this.getVR(n);
    }

    public void finalizeReading(int n) {
        int n2 = this.tags.length;
        if (this.size < n2) {
            if (this.tags.length == 8192 && this.pool != null) {
                this.pool.intPool.add(this.tags);
                this.pool.valuesPool.add(this.values);
                this.pool.vrPool.add(this.vrs);
            }
            int[] nArray = new int[this.size + n];
            System.arraycopy(this.tags, 0, nArray, 0, this.size);
            this.tags = nArray;
            VR[] vRArray = new VR[this.size + n];
            System.arraycopy(this.vrs, 0, vRArray, 0, this.size);
            this.vrs = vRArray;
            Object[] objectArray = new Object[this.size + n];
            System.arraycopy(this.values, 0, objectArray, 0, this.size);
            int n3 = 0;
            while (n3 < this.size) {
                this.values[n3] = null;
                ++n3;
            }
            this.values = objectArray;
        }
    }

    public void reparent(Attributes attributes) {
        this.parent = attributes;
    }

    private double[] fastDecodeDoubles(byte[] byArray) {
        int n = 1;
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] == 92) {
                ++n;
            } else if (byArray[n2] == 101) {
                return null;
            }
            ++n2;
        }
        n2 = byArray.length;
        double[] dArray = new double[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            block19: {
                int n5;
                int n6 = 0;
                long l = 0L;
                while (n3 < n2 && byArray[n3] == 32) {
                    ++n3;
                }
                if (n3 == n2) {
                    return null;
                }
                byte by = byArray[n3];
                if (by == 45) {
                    n5 = -1;
                    ++n3;
                } else {
                    n5 = 1;
                }
                if (n3 == n2) {
                    return null;
                }
                do {
                    if ((by = byArray[n3++]) >= 48 && by <= 57) {
                        l = 10L * l + (long)(by - 48);
                        ++n6;
                        continue;
                    }
                    if (by == 92) {
                        dArray[n4] = (long)n5 * l;
                        break block19;
                    }
                    if (by == 46) break;
                    if (n3 >= n2) continue;
                    return null;
                } while (n3 < n2 && n6 < 16);
                if (n3 == n2) {
                    dArray[n4] = (long)n5 * l;
                } else {
                    double d = 1.0;
                    while (n3 < n2 && n6 < 16) {
                        if ((by = byArray[n3++]) >= 48 && by <= 57) {
                            l = 10L * l + (long)(by - 48);
                            d *= 10.0;
                            ++n6;
                            continue;
                        }
                        if (by == 92) {
                            dArray[n4] = (double)n5 * ((double)l / d);
                            break block19;
                        }
                        if (n3 >= n2) continue;
                        return null;
                    }
                    if (n6 >= 16) {
                        return null;
                    }
                    dArray[n4] = (double)n5 * ((double)l / d);
                }
            }
            ++n4;
        }
        return dArray;
    }

    public Attributes() {
        this(false, 16);
    }

    public Attributes(boolean bl) {
        this(bl, 16);
    }

    public Attributes(int n) {
        this(false, n);
    }

    public Attributes(boolean bl, int n) {
        this.bigEndian = bl;
        this.init(n);
    }

    private void init(int n) {
        if (n == 0 && this.pool != null) {
            if (this.pool.intPool.isEmpty()) {
                this.tags = new int[8192];
                this.values = new Object[8192];
                this.vrs = new VR[8192];
            } else {
                this.tags = this.pool.intPool.remove(this.pool.intPool.size() - 1);
                this.values = this.pool.valuesPool.remove(this.pool.valuesPool.size() - 1);
                this.vrs = this.pool.vrPool.remove(this.pool.vrPool.size() - 1);
            }
            return;
        }
        this.tags = new int[n];
        this.vrs = new VR[n];
        this.values = new Object[n];
    }

    public Attributes(Attributes attributes) {
        this(attributes, attributes.bigEndian);
    }

    public Attributes(Attributes attributes, boolean bl) {
        this(bl, attributes.size);
        if (attributes.properties != null) {
            this.properties = new HashMap<String, Object>(attributes.properties);
        }
        this.addAll(attributes);
    }

    public Attributes(Attributes attributes, int ... nArray) {
        this(attributes, attributes.bigEndian, nArray);
    }

    public Attributes(Attributes attributes, boolean bl, int ... nArray) {
        this(bl, nArray.length);
        if (attributes.properties != null) {
            this.properties = new HashMap<String, Object>(attributes.properties);
        }
        this.addSelected(attributes, nArray);
    }

    public Attributes(Attributes attributes, boolean bl, Attributes attributes2) {
        this(bl, attributes2.size());
        if (attributes.properties != null) {
            this.properties = new HashMap<String, Object>(attributes.properties);
        }
        this.addSelected(attributes, attributes2);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> map) {
        this.properties = map;
    }

    public Object getProperty(String string, Object object) {
        if (this.properties == null) {
            return object;
        }
        Object object2 = this.properties.get(string);
        return object2 != null ? object2 : object;
    }

    public Object setProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties.put(string, object);
    }

    public Object clearProperty(String string) {
        return this.properties != null ? this.properties.remove(string) : null;
    }

    public final boolean isRoot() {
        return this.parent == null;
    }

    public final int getLevel() {
        return this.isRoot() ? 0 : 1 + this.parent.getLevel();
    }

    public final boolean bigEndian() {
        return this.bigEndian;
    }

    public final Attributes getParent() {
        return this.parent;
    }

    public final int getLength() {
        return this.length;
    }

    Attributes setParent(Attributes attributes) {
        if (attributes != null) {
            if (attributes.bigEndian != this.bigEndian) {
                throw new IllegalArgumentException("Endian of Item must match Endian of parent Data Set");
            }
            if (this.parent != null) {
                throw new IllegalArgumentException("Item already contained by Sequence");
            }
            if (!this.containsSpecificCharacterSet) {
                this.cs = null;
            }
            if (!this.containsTimezoneOffsetFromUTC) {
                this.tz = null;
            }
        }
        this.parent = attributes;
        return this;
    }

    public final long getItemPosition() {
        return this.itemPosition;
    }

    public final void setItemPosition(long l) {
        this.itemPosition = l;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final int size() {
        return this.size;
    }

    public int[] tags() {
        return Arrays.copyOf(this.tags, this.size);
    }

    public void trimToSize() {
        this.trimToSize(false);
    }

    public void trimToSize(boolean bl) {
        int n = this.tags.length;
        if (this.size < n) {
            this.tags = Arrays.copyOf(this.tags, this.size);
            this.vrs = Arrays.copyOf(this.vrs, this.size);
            this.values = Arrays.copyOf(this.values, this.size);
        }
        if (bl) {
            Object[] objectArray = this.values;
            int n2 = this.values.length;
            int n3 = 0;
            while (n3 < n2) {
                Object object = objectArray[n3];
                if (object instanceof Sequence) {
                    ((Sequence)object).trimToSize(bl);
                } else if (object instanceof Fragments) {
                    ((Fragments)object).trimToSize();
                }
                ++n3;
            }
        }
    }

    public void internalizeStringValues(boolean bl) {
        SpecificCharacterSet specificCharacterSet = this.getSpecificCharacterSet();
        int n = 0;
        while (n < this.values.length) {
            block10: {
                Object object;
                block8: {
                    block9: {
                        VR vR = this.vrs[n];
                        object = this.values[n];
                        if (!vR.isStringType()) break block8;
                        if (!(object instanceof byte[])) break block9;
                        if (!bl) break block10;
                        object = vR.toStrings((byte[])object, this.bigEndian, specificCharacterSet);
                    }
                    if (object instanceof String) {
                        this.values[n] = ((String)object).intern();
                    } else if (object instanceof String[]) {
                        Object object2 = (String[])object;
                        int n2 = 0;
                        while (n2 < ((String[])object2).length) {
                            object2[n2] = ((String)object2[n2]).intern();
                            ++n2;
                        }
                    }
                    break block10;
                }
                if (object instanceof Sequence) {
                    for (Object object2 : (Sequence)object) {
                        ((Attributes)object2).internalizeStringValues(bl);
                    }
                }
            }
            ++n;
        }
    }

    private void decodeStringValuesUsingSpecificCharacterSet() {
        SpecificCharacterSet specificCharacterSet = this.getSpecificCharacterSet();
        int n = 0;
        while (n < this.size) {
            Object object = this.values[n];
            if (object instanceof Sequence) {
                for (Attributes attributes : (Sequence)object) {
                    attributes.decodeStringValuesUsingSpecificCharacterSet();
                }
            } else {
                VR vR = this.vrs[n];
                if (vR.useSpecificCharacterSet() && object instanceof byte[]) {
                    this.values[n] = vR.toStrings((byte[])object, this.bigEndian, specificCharacterSet);
                }
            }
            ++n;
        }
    }

    private void ensureCapacity(int n) {
        int n2 = this.tags.length;
        if (n > n2) {
            int n3 = Math.max(n, n2 << 1);
            if (this.tags.length == 8192 && n3 != n2 & this.pool != null) {
                this.pool.intPool.add(this.tags);
                this.pool.valuesPool.add(this.values);
                this.pool.vrPool.add(this.vrs);
            }
            this.tags = Arrays.copyOf(this.tags, n3);
            this.vrs = Arrays.copyOf(this.vrs, n3);
            this.values = Arrays.copyOf(this.values, n3);
        }
    }

    public Attributes getNestedDataset(int n) {
        return this.getNestedDataset(null, n, 0);
    }

    public Attributes getNestedDataset(int n, int n2) {
        return this.getNestedDataset(null, n, n2);
    }

    public Attributes getNestedDataset(String string, int n) {
        return this.getNestedDataset(string, n, 0);
    }

    public Attributes getNestedDataset(String string, int n, int n2) {
        Object object = this.getValue(string, n);
        if (!(object instanceof Sequence)) {
            return null;
        }
        Sequence sequence = (Sequence)object;
        if (n2 >= sequence.size()) {
            return null;
        }
        return (Attributes)sequence.get(n2);
    }

    public Attributes getNestedDataset(ItemPointer ... itemPointerArray) {
        Attributes attributes = this;
        ItemPointer[] itemPointerArray2 = itemPointerArray;
        int n = itemPointerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemPointer itemPointer = itemPointerArray2[n2];
            Object object = attributes.getValue(itemPointer.privateCreator, itemPointer.sequenceTag);
            if (!(object instanceof Sequence)) {
                return null;
            }
            Sequence sequence = (Sequence)object;
            if (itemPointer.itemIndex >= sequence.size()) {
                return null;
            }
            attributes = (Attributes)sequence.get(itemPointer.itemIndex);
            ++n2;
        }
        return attributes;
    }

    private int indexForInsertOf(int n) {
        return this.size == 0 ? -1 : (this.tags[this.size - 1] < n ? -(this.size + 1) : this.indexOf(n));
    }

    private int indexOf(int n) {
        return Arrays.binarySearch(this.tags, 0, this.size, n);
    }

    private int indexOf(String string, int n) {
        if (string != null) {
            int n2 = this.creatorTagOf(string, n, false);
            if (n2 == -1) {
                return -1;
            }
            n = TagUtils.toPrivateTag(n2, n);
        }
        return this.indexOf(n);
    }

    private int creatorTagOf(String string, int n, boolean bl) {
        if (!TagUtils.isPrivateGroup(n)) {
            throw new IllegalArgumentException(String.valueOf(TagUtils.toString(n)) + " is not a private Data Element");
        }
        int n2 = n & 0xFFFF0000;
        int n3 = n2 | 0x10;
        int n4 = this.indexOf(n3);
        if (n4 < 0) {
            n4 = -n4 - 1;
        }
        while (n4 < this.size && (this.tags[n4] & 0xFFFFFF00) == n2) {
            Object object;
            n3 = this.tags[n4];
            if (this.vrs[n4] == VR.LO && string.equals(object = this.decodeStringValue(n4))) {
                return n3;
            }
            ++n4;
            ++n3;
        }
        if (!bl) {
            return -1;
        }
        if ((n3 & 0xFF00) != 0) {
            throw new IllegalStateException("No free block for Private Element " + TagUtils.toString(n));
        }
        this.setString(n3, VR.LO, string);
        return n3;
    }

    private Object decodeStringValue(int n) {
        Object object = this.values[n];
        if (object instanceof byte[]) {
            if ((object = this.vrs[n].toStrings((byte[])object, this.bigEndian, this.getSpecificCharacterSet(this.vrs[n]))) instanceof String && ((String)object).isEmpty()) {
                object = Value.NULL;
            }
            this.values[n] = object;
        }
        return object;
    }

    public SpecificCharacterSet getSpecificCharacterSet(VR vR) {
        return vR.useSpecificCharacterSet() ? this.getSpecificCharacterSet() : SpecificCharacterSet.DEFAULT;
    }

    private double[] decodeDSValue(int n) {
        double[] dArray;
        Object object = this.values[n];
        if (object == Value.NULL) {
            return ByteUtils.EMPTY_DOUBLES;
        }
        if (object instanceof double[]) {
            return (double[])object;
        }
        if (object instanceof byte[]) {
            dArray = this.fastDecodeDoubles((byte[])object);
            if (dArray != null) {
                this.values[n] = dArray;
                return dArray;
            }
            object = this.vrs[n].toStrings(object, this.bigEndian, this.getSpecificCharacterSet());
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.isEmpty()) {
                this.values[n] = Value.NULL;
                return ByteUtils.EMPTY_DOUBLES;
            }
            dArray = new double[]{StringUtils.parseDS(string)};
        } else {
            String[] stringArray = (String[])object;
            dArray = new double[stringArray.length];
            int n2 = 0;
            while (n2 < dArray.length) {
                String string = stringArray[n2];
                dArray[n2] = string != null && !string.isEmpty() ? StringUtils.parseDS(string) : Double.NaN;
                ++n2;
            }
        }
        this.values[n] = dArray;
        return dArray;
    }

    private int[] decodeISValue(int n) {
        int[] nArray;
        Object object = this.values[n];
        if (object == Value.NULL) {
            return ByteUtils.EMPTY_INTS;
        }
        if (object instanceof int[]) {
            return (int[])object;
        }
        if (object instanceof byte[]) {
            object = this.vrs[n].toStrings((byte[])object, this.bigEndian, SpecificCharacterSet.DEFAULT);
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.isEmpty()) {
                this.values[n] = Value.NULL;
                return ByteUtils.EMPTY_INTS;
            }
            nArray = new int[]{StringUtils.parseIS(string)};
        } else {
            String[] stringArray = (String[])object;
            nArray = new int[stringArray.length];
            int n2 = 0;
            while (n2 < nArray.length) {
                String string = stringArray[n2];
                nArray[n2] = string != null && !string.isEmpty() ? StringUtils.parseIS(string) : Integer.MIN_VALUE;
                ++n2;
            }
        }
        this.values[n] = nArray;
        return nArray;
    }

    private void updateVR(int n, VR vR) {
        VR vR2 = this.vrs[n];
        if (vR == vR2) {
            return;
        }
        Object object = this.values[n];
        if (!(object instanceof byte[]) && object != Value.NULL) {
            throw new IllegalStateException("value instanceof " + object.getClass());
        }
        this.vrs[n] = vR;
    }

    private static boolean isEmpty(Object object) {
        return object instanceof Value && ((Value)object).isEmpty();
    }

    public boolean contains(int n) {
        return this.indexOf(n) >= 0;
    }

    public boolean contains(String string, int n) {
        return this.indexOf(string, n) >= 0;
    }

    public boolean containsValue(int n) {
        return this.containsValue(null, n);
    }

    public boolean containsValue(String string, int n) {
        int n2 = this.indexOf(string, n);
        return n2 >= 0 && !Attributes.isEmpty(this.vrs[n2].isStringType() ? this.decodeStringValue(n2) : this.values[n2]);
    }

    public String privateCreatorOf(int n) {
        if (!TagUtils.isPrivateTag(n)) {
            return null;
        }
        int n2 = n & 0xFFFF0000 | n >>> 8 & 0xFF;
        int n3 = this.indexOf(n2);
        if (n3 < 0 || this.vrs[n3] != VR.LO || this.values[n3] == Value.NULL) {
            return null;
        }
        Object object = this.decodeStringValue(n3);
        if (object == Value.NULL) {
            return null;
        }
        return VR.LO.toString(object, false, 0, null);
    }

    public Object getValue(int n) {
        return this.getValue(null, n, null);
    }

    public Object getValue(int n, VR.Holder holder) {
        return this.getValue(null, n, holder);
    }

    public Object getValue(String string, int n) {
        return this.getValue(string, n, null);
    }

    public Object getValue(String string, int n, VR.Holder holder) {
        int n2 = this.indexOf(string, n);
        if (n2 < 0) {
            return null;
        }
        if (holder != null) {
            holder.vr = this.vrs[n2];
        }
        return this.values[n2];
    }

    public VR getVR(int n) {
        return this.getVR(null, n);
    }

    public VR getVR(String string, int n) {
        int n2 = this.indexOf(string, n);
        if (n2 < 0) {
            return null;
        }
        return this.vrs[n2];
    }

    public Sequence getSequence(int n) {
        return this.getSequence(null, n);
    }

    public Sequence getSequence(String string, int n) {
        int n2 = this.indexOf(string, n);
        if (n2 < 0) {
            return null;
        }
        Object object = this.values[n2];
        if (object == Value.NULL) {
            this.values[n2] = new Sequence(this, 0);
            return this.values[n2];
        }
        return object instanceof Sequence ? (Sequence)object : null;
    }

    public byte[] getBytes(int n) throws IOException {
        return this.getBytes(null, n);
    }

    public byte[] getBytes(String string, int n) throws IOException {
        int n2 = this.indexOf(string, n);
        if (n2 < 0) {
            return null;
        }
        Object object = this.values[n2];
        VR vR = this.vrs[n2];
        try {
            if (object instanceof Value) {
                return ((Value)object).toBytes(vR, this.bigEndian);
            }
            return vR.toBytes(object, this.getSpecificCharacterSet(vR));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOG.info("Attempt to access {} {} as bytes", (Object)TagUtils.toString(n), (Object)vR);
            return null;
        }
    }

    public byte[] getSafeBytes(int n) {
        return this.getSafeBytes(null, n);
    }

    public byte[] getSafeBytes(String string, int n) {
        try {
            return this.getBytes(string, n);
        }
        catch (IOException iOException) {
            LOG.info("Access " + TagUtils.toString(n) + " throws i/o exception", (Throwable)iOException);
            return null;
        }
    }

    public String getString(int n) {
        return this.getString(null, n, null, 0, null);
    }

    public String getString(int n, String string) {
        return this.getString(null, n, null, 0, string);
    }

    public String getString(int n, int n2) {
        return this.getString(null, n, null, n2, null);
    }

    public String getString(int n, int n2, String string) {
        return this.getString(null, n, null, n2, string);
    }

    public String getString(String string, int n) {
        return this.getString(string, n, null, 0, null);
    }

    public String getString(String string, int n, String string2) {
        return this.getString(string, n, null, 0, string2);
    }

    public String getString(String string, int n, VR vR) {
        return this.getString(string, n, vR, 0, null);
    }

    public String getString(String string, int n, VR vR, String string2) {
        return this.getString(string, n, vR, 0, string2);
    }

    public String getString(String string, int n, int n2) {
        return this.getString(string, n, null, n2, null);
    }

    public String getString(String string, int n, int n2, String string2) {
        return this.getString(string, n, null, n2, string2);
    }

    public String getString(String string, int n, VR vR, int n2) {
        return this.getString(string, n, vR, n2, null);
    }

    public String getString(String string, int n, VR vR, int n2, String string2) {
        int n3 = this.indexOf(string, n);
        if (n3 < 0) {
            return string2;
        }
        Object object = this.values[n3];
        if (object == Value.NULL) {
            return string2;
        }
        if (vR == null) {
            vR = this.vrs[n3];
        } else {
            this.updateVR(n3, vR);
        }
        if (vR.isStringType() && (object = this.decodeStringValue(n3)) == Value.NULL) {
            return string2;
        }
        try {
            return vR.toString(object, this.bigEndian, n2, string2);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOG.info("Attempt to access {} {} as string", (Object)TagUtils.toString(n), (Object)vR);
            return string2;
        }
    }

    public String[] getStrings(int n) {
        return this.getStrings(null, n, null);
    }

    public String[] getStrings(String string, int n) {
        return this.getStrings(string, n, null);
    }

    public String[] getStrings(String string, int n, VR vR) {
        int n2 = this.indexOf(string, n);
        if (n2 < 0) {
            return null;
        }
        Object object = this.values[n2];
        if (object == Value.NULL) {
            return StringUtils.EMPTY_STRING;
        }
        if (vR == null) {
            vR = this.vrs[n2];
        } else {
            this.updateVR(n2, vR);
        }
        if (vR.isStringType() && (object = this.decodeStringValue(n2)) == Value.NULL) {
            return StringUtils.EMPTY_STRING;
        }
        try {
            return Attributes.toStrings(vR.toStrings(object, this.bigEndian, this.getSpecificCharacterSet(vR)));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOG.info("Attempt to access {} {} as string", (Object)TagUtils.toString(n), (Object)vR);
            return null;
        }
    }

    private static String[] toStrings(Object object) {
        String[] stringArray;
        if (object instanceof String) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = (String)object;
        } else {
            stringArray = (String[])object;
        }
        return stringArray;
    }

    public int getInt(int n, int n2) {
        return this.getInt(null, n, null, 0, n2);
    }

    public int getInt(int n, int n2, int n3) {
        return this.getInt(null, n, null, n2, n3);
    }

    public int getInt(String string, int n, int n2) {
        return this.getInt(string, n, null, 0, n2);
    }

    public int getInt(String string, int n, VR vR, int n2) {
        return this.getInt(string, n, vR, 0, n2);
    }

    public int getInt(String string, int n, int n2, int n3) {
        return this.getInt(string, n, null, n2, n3);
    }

    public int getInt(String string, int n, VR vR, int n2, int n3) {
        int n4 = this.indexOf(string, n);
        if (n4 < 0) {
            return n3;
        }
        Object object = this.values[n4];
        if (object == Value.NULL) {
            return n3;
        }
        if (vR == null) {
            vR = this.vrs[n4];
        } else {
            this.updateVR(n4, vR);
        }
        if (vR == VR.IS) {
            object = this.decodeISValue(n4);
        }
        try {
            return vR.toInt(object, this.bigEndian, n2, n3);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOG.info("Attempt to access {} {} as int", (Object)TagUtils.toString(n), (Object)vR);
            return n3;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.info("Invalid value of {} {}", (Object)TagUtils.toString(n), (Object)vR);
            return n3;
        }
    }

    public int[] getInts(int n) {
        return this.getInts(null, n, null);
    }

    public int[] getInts(String string, int n) {
        return this.getInts(string, n, null);
    }

    public int[] getInts(String string, int n, VR vR) {
        int n2 = this.indexOf(string, n);
        if (n2 < 0) {
            return null;
        }
        Object object = this.values[n2];
        if (object == Value.NULL) {
            return ByteUtils.EMPTY_INTS;
        }
        if (vR == null) {
            vR = this.vrs[n2];
        } else {
            this.updateVR(n2, vR);
        }
        if (vR == VR.IS) {
            object = this.decodeISValue(n2);
        }
        try {
            return vR.toInts(object, this.bigEndian);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOG.info("Attempt to access {} {} as int", (Object)TagUtils.toString(n), (Object)vR);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.info("Invalid value of {} {}", (Object)TagUtils.toString(n), (Object)vR);
            return null;
        }
    }

    public float getFloat(int n, float f) {
        return this.getFloat(null, n, null, 0, f);
    }

    public float getFloat(int n, int n2, float f) {
        return this.getFloat(null, n, null, n2, f);
    }

    public float getFloat(String string, int n, float f) {
        return this.getFloat(string, n, null, 0, f);
    }

    public float getFloat(String string, int n, VR vR, float f) {
        return this.getFloat(string, n, vR, 0, f);
    }

    public float getFloat(String string, int n, int n2, float f) {
        return this.getFloat(string, n, null, n2, f);
    }

    public float getFloat(String string, int n, VR vR, int n2, float f) {
        int n3 = this.indexOf(string, n);
        if (n3 < 0) {
            return f;
        }
        Object object = this.values[n3];
        if (object == Value.NULL) {
            return f;
        }
        if (vR == null) {
            vR = this.vrs[n3];
        } else {
            this.updateVR(n3, vR);
        }
        if (vR == VR.DS) {
            object = this.decodeDSValue(n3);
        }
        try {
            return vR.toFloat(object, this.bigEndian, n2, f);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOG.info("Attempt to access {} {} as float", (Object)TagUtils.toString(n), (Object)vR);
            return f;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.info("Invalid value of {} {}", (Object)TagUtils.toString(n), (Object)vR);
            return f;
        }
    }

    public float[] getFloats(int n) {
        return this.getFloats(null, n, null);
    }

    public float[] getFloats(String string, int n) {
        return this.getFloats(string, n, null);
    }

    public float[] getFloats(String string, int n, VR vR) {
        int n2 = this.indexOf(string, n);
        if (n2 < 0) {
            return null;
        }
        Object object = this.values[n2];
        if (object == Value.NULL) {
            return ByteUtils.EMPTY_FLOATS;
        }
        if (vR == null) {
            vR = this.vrs[n2];
        } else {
            this.updateVR(n2, vR);
        }
        if (vR == VR.DS) {
            object = this.decodeDSValue(n2);
        }
        try {
            if (object instanceof double[]) {
                double[] dArray = (double[])object;
                float[] fArray = new float[dArray.length];
                int n3 = 0;
                while (n3 < fArray.length) {
                    fArray[n3] = (float)dArray[n3];
                    ++n3;
                }
                return fArray;
            }
            return vR.toFloats(object, this.bigEndian);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOG.info("Attempt to access {} {} as float", (Object)TagUtils.toString(n), (Object)vR);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.info("Invalid value of {} {}", (Object)TagUtils.toString(n), (Object)vR);
            return null;
        }
    }

    public double getDouble(int n, double d) {
        return this.getDouble(null, n, null, 0, d);
    }

    public double getDouble(int n, int n2, double d) {
        return this.getDouble(null, n, null, n2, d);
    }

    public double getDouble(String string, int n, double d) {
        return this.getDouble(string, n, null, 0, d);
    }

    public double getDouble(String string, int n, VR vR, double d) {
        return this.getDouble(string, n, vR, 0, d);
    }

    public double getDouble(String string, int n, int n2, double d) {
        return this.getDouble(string, n, null, n2, d);
    }

    public double getDouble(String string, int n, VR vR, int n2, double d) {
        int n3 = this.indexOf(string, n);
        if (n3 < 0) {
            return d;
        }
        Object object = this.values[n3];
        if (object == Value.NULL) {
            return d;
        }
        if (vR == null) {
            vR = this.vrs[n3];
        } else {
            this.updateVR(n3, vR);
        }
        if (vR == VR.DS) {
            if (object instanceof double[]) {
                double[] dArray = (double[])object;
                if (n2 < 0 || n2 >= dArray.length) {
                    return d;
                }
                return ((double[])object)[n2];
            }
            object = this.decodeDSValue(n3);
        }
        try {
            return vR.toDouble(object, this.bigEndian, n2, d);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOG.info("Attempt to access {} {} as double", (Object)TagUtils.toString(n), (Object)vR);
            return d;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.info("Invalid value of {} {}", (Object)TagUtils.toString(n), (Object)vR);
            return d;
        }
    }

    public double[] getDoubles(int n) {
        return this.getDoubles(null, n, null);
    }

    public double[] getDoubles(String string, int n) {
        return this.getDoubles(string, n, null);
    }

    public double[] getDoubles(String string, int n, VR vR) {
        int n2 = this.indexOf(string, n);
        if (n2 < 0) {
            return null;
        }
        Object object = this.values[n2];
        if (object == Value.NULL) {
            return ByteUtils.EMPTY_DOUBLES;
        }
        if (vR == null) {
            vR = this.vrs[n2];
        } else {
            this.updateVR(n2, vR);
        }
        if (vR == VR.DS) {
            if (object instanceof double[]) {
                return (double[])object;
            }
            object = this.decodeDSValue(n2);
            try {
                double[] dArray = vR.toDoubles(object, this.bigEndian);
                this.values[n2] = dArray;
                return dArray;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                LOG.info("Attempt to access {} {} as double", (Object)TagUtils.toString(n), (Object)vR);
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.info("Invalid value of {} {}", (Object)TagUtils.toString(n), (Object)vR);
                return null;
            }
        }
        try {
            return vR.toDoubles(object, this.bigEndian);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOG.info("Attempt to access {} {} as double", (Object)TagUtils.toString(n), (Object)vR);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.info("Invalid value of {} {}", (Object)TagUtils.toString(n), (Object)vR);
            return null;
        }
    }

    public Date getDate(int n) {
        return this.getDate(null, n, null, 0, null, new DatePrecision());
    }

    public Date getDate(int n, DatePrecision datePrecision) {
        return this.getDate(null, n, null, 0, null, datePrecision);
    }

    public Date getDate(int n, Date date) {
        return this.getDate(null, n, null, 0, date, new DatePrecision());
    }

    public Date getDate(int n, Date date, DatePrecision datePrecision) {
        return this.getDate(null, n, null, 0, date, datePrecision);
    }

    public Date getDate(int n, int n2) {
        return this.getDate(null, n, null, n2, null, new DatePrecision());
    }

    public Date getDate(int n, int n2, DatePrecision datePrecision) {
        return this.getDate(null, n, null, n2, null, datePrecision);
    }

    public Date getDate(int n, int n2, Date date) {
        return this.getDate(null, n, null, n2, date, new DatePrecision());
    }

    public Date getDate(int n, int n2, Date date, DatePrecision datePrecision) {
        return this.getDate(null, n, null, n2, date, datePrecision);
    }

    public Date getDate(String string, int n) {
        return this.getDate(string, n, null, 0, null, new DatePrecision());
    }

    public Date getDate(String string, int n, DatePrecision datePrecision) {
        return this.getDate(string, n, null, 0, null, datePrecision);
    }

    public Date getDate(String string, int n, Date date, DatePrecision datePrecision) {
        return this.getDate(string, n, null, 0, date, datePrecision);
    }

    public Date getDate(String string, int n, VR vR) {
        return this.getDate(string, n, vR, 0, null, new DatePrecision());
    }

    public Date getDate(String string, int n, VR vR, DatePrecision datePrecision) {
        return this.getDate(string, n, vR, 0, null, datePrecision);
    }

    public Date getDate(String string, int n, VR vR, Date date) {
        return this.getDate(string, n, vR, 0, date, new DatePrecision());
    }

    public Date getDate(String string, int n, VR vR, Date date, DatePrecision datePrecision) {
        return this.getDate(string, n, vR, 0, date, datePrecision);
    }

    public Date getDate(String string, int n, int n2) {
        return this.getDate(string, n, null, n2, null, new DatePrecision());
    }

    public Date getDate(String string, int n, int n2, DatePrecision datePrecision) {
        return this.getDate(string, n, null, n2, null, datePrecision);
    }

    public Date getDate(String string, int n, int n2, Date date) {
        return this.getDate(string, n, null, n2, date, new DatePrecision());
    }

    public Date getDate(String string, int n, int n2, Date date, DatePrecision datePrecision) {
        return this.getDate(string, n, null, n2, date, datePrecision);
    }

    public Date getDate(String string, int n, VR vR, int n2) {
        return this.getDate(string, n, vR, n2, null, new DatePrecision());
    }

    public Date getDate(String string, int n, VR vR, int n2, DatePrecision datePrecision) {
        return this.getDate(string, n, vR, n2, null, datePrecision);
    }

    public Date getDate(String string, int n, VR vR, int n2, Date date) {
        return this.getDate(string, n, vR, n2, date, new DatePrecision());
    }

    public Date getDate(String string, int n, VR vR, int n2, Date date, DatePrecision datePrecision) {
        int n3 = this.indexOf(string, n);
        if (n3 < 0) {
            return date;
        }
        Object object = this.values[n3];
        if (object == Value.NULL) {
            return date;
        }
        if (vR == null) {
            vR = this.vrs[n3];
        } else {
            this.updateVR(n3, vR);
        }
        if (!vR.isTemporalType()) {
            LOG.info("Attempt to access {} {} as date", (Object)TagUtils.toString(n), (Object)vR);
            return date;
        }
        try {
            object = this.decodeStringValue(n3);
            if (object == Value.NULL) {
                return date;
            }
            return vR.toDate(object, vR != VR.DA ? this.getTimeZone() : null, n2, false, date, datePrecision);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.info("Invalid value of {} {}", (Object)TagUtils.toString(n), (Object)vR);
            return date;
        }
    }

    public Date getDate(long l) {
        return this.getDate(null, l, null, new DatePrecision());
    }

    public Date getDate(long l, DatePrecision datePrecision) {
        return this.getDate(null, l, null, datePrecision);
    }

    public Date getDate(long l, Date date) {
        return this.getDate(null, l, date, new DatePrecision());
    }

    public Date getDate(long l, Date date, DatePrecision datePrecision) {
        return this.getDate(null, l, date, datePrecision);
    }

    public Date getDate(String string, long l) {
        return this.getDate(string, l, null, new DatePrecision());
    }

    public Date getDate(String string, long l, DatePrecision datePrecision) {
        return this.getDate(string, l, null, datePrecision);
    }

    public Date getDate(String string, long l, Date date) {
        return this.getDate(string, l, date, new DatePrecision());
    }

    public Date getDate(String string, long l, Date date, DatePrecision datePrecision) {
        int n = (int)(l >>> 32);
        int n2 = (int)l;
        String string2 = this.getString(string, n2, VR.TM, null);
        if (string2 == null) {
            return this.getDate(n, date, datePrecision);
        }
        String string3 = this.getString(string, n, VR.DA, null);
        if (string3 == null) {
            return date;
        }
        try {
            return VR.DT.toDate(String.valueOf(string3) + string2, this.getTimeZone(), 0, false, null, datePrecision);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.info("Invalid value of {} DA or {} TM", (Object)TagUtils.toString(n), (Object)TagUtils.toString(n2));
            return date;
        }
    }

    public Date[] getDates(int n) {
        return this.getDates(null, n, null, new DatePrecisions());
    }

    public Date[] getDates(int n, DatePrecisions datePrecisions) {
        return this.getDates(null, n, null, datePrecisions);
    }

    public Date[] getDates(String string, int n) {
        return this.getDates(string, n, null, new DatePrecisions());
    }

    public Date[] getDates(String string, int n, DatePrecisions datePrecisions) {
        return this.getDates(string, n, null, datePrecisions);
    }

    public Date[] getDates(String string, int n, VR vR) {
        return this.getDates(string, n, vR, new DatePrecisions());
    }

    public Date[] getDates(String string, int n, VR vR, DatePrecisions datePrecisions) {
        int n2 = this.indexOf(string, n);
        if (n2 < 0) {
            return null;
        }
        Object object = this.values[n2];
        if (object == Value.NULL) {
            return DateUtils.EMPTY_DATES;
        }
        if (vR == null) {
            vR = this.vrs[n2];
        } else {
            this.updateVR(n2, vR);
        }
        if (!vR.isTemporalType()) {
            LOG.info("Attempt to access {} {} as date", (Object)TagUtils.toString(n), (Object)vR);
            return DateUtils.EMPTY_DATES;
        }
        try {
            object = this.decodeStringValue(n2);
            if (object == Value.NULL) {
                return DateUtils.EMPTY_DATES;
            }
            return vR.toDates(object, this.getTimeZone(), false, datePrecisions);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.info("Invalid value of {} {}", (Object)TagUtils.toString(n), (Object)vR);
            return DateUtils.EMPTY_DATES;
        }
    }

    public Date[] getDates(long l) {
        return this.getDates(null, l, new DatePrecisions());
    }

    public Date[] getDates(long l, DatePrecisions datePrecisions) {
        return this.getDates(null, l, datePrecisions);
    }

    public Date[] getDates(String string, long l) {
        return this.getDates(string, l, new DatePrecisions());
    }

    public Date[] getDates(String string, long l, DatePrecisions datePrecisions) {
        int n = (int)(l >>> 32);
        int n2 = (int)l;
        String[] stringArray = this.getStrings(string, n2);
        if (stringArray == null || stringArray.length == 0) {
            return this.getDates(n, datePrecisions);
        }
        String[] stringArray2 = this.getStrings(string, n);
        if (stringArray2 == null || stringArray2.length == 0) {
            return DateUtils.EMPTY_DATES;
        }
        Date[] dateArray = new Date[stringArray2.length];
        datePrecisions.precisions = new DatePrecision[stringArray2.length];
        int n3 = 0;
        try {
            TimeZone timeZone = this.getTimeZone();
            while (n3 < stringArray.length) {
                int n4 = n3++;
                datePrecisions.precisions[n3] = new DatePrecision();
                dateArray[n4] = VR.DT.toDate(String.valueOf(stringArray2[n3]) + stringArray[n3], timeZone, 0, false, null, datePrecisions.precisions[n3]);
            }
            while (n3 < stringArray2.length) {
                int n5 = n3++;
                datePrecisions.precisions[n3] = new DatePrecision();
                dateArray[n5] = VR.DA.toDate(stringArray2[n3], timeZone, 0, false, null, datePrecisions.precisions[n3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.info("Invalid value of {} DA or {} TM", (Object)TagUtils.toString(n), (Object)TagUtils.toString(n2));
            dateArray = Arrays.copyOf(dateArray, n3);
        }
        return dateArray;
    }

    public DateRange getDateRange(int n) {
        return this.getDateRange(null, n, null, null);
    }

    public DateRange getDateRange(int n, DateRange dateRange) {
        return this.getDateRange(null, n, null, dateRange);
    }

    public DateRange getDateRange(String string, int n) {
        return this.getDateRange(string, n, null, null);
    }

    public DateRange getDateRange(String string, int n, DateRange dateRange) {
        return this.getDateRange(string, n, null, dateRange);
    }

    public DateRange getDateRange(String string, int n, VR vR) {
        return this.getDateRange(string, n, vR, null);
    }

    public DateRange getDateRange(String string, int n, VR vR, DateRange dateRange) {
        int n2 = this.indexOf(string, n);
        if (n2 < 0) {
            return dateRange;
        }
        Object object = this.values[n2];
        if (object == Value.NULL) {
            return dateRange;
        }
        if (vR == null) {
            vR = this.vrs[n2];
        } else {
            this.updateVR(n2, vR);
        }
        if (!vR.isTemporalType()) {
            LOG.info("Attempt to access {} {} as date", (Object)TagUtils.toString(n), (Object)vR);
            return dateRange;
        }
        object = this.decodeStringValue(n2);
        if (object == Value.NULL) {
            return dateRange;
        }
        try {
            return this.toDateRange(object instanceof String ? (String)object : ((String[])object)[0], vR);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.info("Invalid value of {} {}", (Object)TagUtils.toString(n), (Object)vR);
            return dateRange;
        }
    }

    private DateRange toDateRange(String string, VR vR) {
        String[] stringArray = Attributes.splitRange(string);
        TimeZone timeZone = this.getTimeZone();
        DatePrecision datePrecision = new DatePrecision();
        Date date = stringArray[0] == null ? null : vR.toDate(stringArray[0], timeZone, 0, false, null, datePrecision);
        Date date2 = stringArray[1] == null ? null : vR.toDate(stringArray[1], timeZone, 0, true, null, datePrecision);
        return new DateRange(date, date2);
    }

    private static String[] splitRange(String string) {
        String[] stringArray = new String[2];
        int n = string.indexOf(45);
        if (n == -1) {
            stringArray[0] = stringArray[1] = string;
        } else {
            if (n > 0) {
                stringArray[0] = string.substring(0, n);
            }
            if (n < string.length() - 1) {
                stringArray[1] = string.substring(n + 1);
            }
        }
        return stringArray;
    }

    public DateRange getDateRange(long l) {
        return this.getDateRange(null, l, null);
    }

    public DateRange getDateRange(long l, DateRange dateRange) {
        return this.getDateRange(null, l, dateRange);
    }

    public DateRange getDateRange(String string, long l) {
        return this.getDateRange(string, l, null);
    }

    public DateRange getDateRange(String string, long l, DateRange dateRange) {
        int n = (int)(l >>> 32);
        int n2 = (int)l;
        String string2 = this.getString(string, n2, VR.TM, null);
        if (string2 == null) {
            return this.getDateRange(n, dateRange);
        }
        String string3 = this.getString(string, n, VR.DA, null);
        if (string3 == null) {
            return dateRange;
        }
        try {
            return this.toDateRange(string3, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.info("Invalid value of {} TM", (Object)TagUtils.toString((int)l));
            return dateRange;
        }
    }

    private DateRange toDateRange(String string, String string2) {
        String[] stringArray = Attributes.splitRange(string);
        String[] stringArray2 = Attributes.splitRange(string2);
        DatePrecision datePrecision = new DatePrecision();
        return new DateRange(stringArray[0] == null ? null : VR.DT.toDate(stringArray2[0] == null ? stringArray[0] : String.valueOf(stringArray[0]) + stringArray2[0], this.tz, 0, false, null, datePrecision), stringArray[1] == null ? null : VR.DT.toDate(stringArray2[1] == null ? stringArray[1] : String.valueOf(stringArray[1]) + stringArray2[1], this.tz, 0, true, null, datePrecision));
    }

    public void setSpecificCharacterSet(String ... stringArray) {
        this.decodeStringValuesUsingSpecificCharacterSet();
        this.setString(524293, VR.CS, stringArray);
    }

    public SpecificCharacterSet getSpecificCharacterSet() {
        if (this.cs != null) {
            return this.cs;
        }
        if (this.containsSpecificCharacterSet) {
            this.cs = SpecificCharacterSet.valueOf(this.getStrings(null, 524293, VR.CS));
        } else {
            if (this.parent != null) {
                return this.parent.getSpecificCharacterSet();
            }
            this.cs = SpecificCharacterSet.DEFAULT;
        }
        return this.cs;
    }

    public void setDefaultTimeZone(TimeZone timeZone) {
        this.defaultTimeZone = timeZone;
    }

    public TimeZone getDefaultTimeZone() {
        if (this.defaultTimeZone != null) {
            return this.defaultTimeZone;
        }
        if (this.parent != null) {
            return this.parent.getDefaultTimeZone();
        }
        return TimeZone.getDefault();
    }

    public TimeZone getTimeZone() {
        if (this.tz != null) {
            return this.tz;
        }
        if (this.containsTimezoneOffsetFromUTC) {
            String string = this.getString(524801);
            if (string != null) {
                try {
                    this.tz = DateUtils.timeZone(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOG.info(illegalArgumentException.getMessage());
                }
            }
        } else {
            if (this.parent != null) {
                return this.parent.getTimeZone();
            }
            this.tz = this.getDefaultTimeZone();
        }
        return this.tz;
    }

    public void setTimezoneOffsetFromUTC(String string) {
        TimeZone timeZone = DateUtils.timeZone(string);
        this.updateTimezone(this.getTimeZone(), timeZone);
        this.setString(524801, VR.SH, string);
    }

    public void setTimezone(TimeZone timeZone) {
        this.updateTimezone(this.getTimeZone(), timeZone);
        if (timeZone.useDaylightTime()) {
            this.remove(524801);
            this.setDefaultTimeZone(timeZone);
        } else {
            this.setString(524801, VR.SH, DateUtils.formatTimezoneOffsetFromUTC(timeZone));
        }
    }

    private void updateTimezone(TimeZone timeZone, TimeZone timeZone2) {
        int n = 0;
        while (n < this.size) {
            Object object = this.values[n];
            if (object instanceof Sequence) {
                Sequence sequence = (Sequence)object;
                for (Attributes attributes : sequence) {
                    attributes.updateTimezone(attributes.getTimeZone(), timeZone2);
                    attributes.remove(524801);
                }
            } else if (this.vrs[n] == VR.TM || this.vrs[n] == VR.DT) {
                this.updateTimezone(timeZone, timeZone2, n);
            }
            ++n;
        }
    }

    private void updateTimezone(TimeZone timeZone, TimeZone timeZone2, int n) {
        Object object = this.decodeStringValue(n);
        if (object == Value.NULL) {
            return;
        }
        int n2 = this.tags[n];
        if (this.vrs[n] == VR.DT) {
            if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                int n3 = 0;
                while (n3 < stringArray.length) {
                    stringArray[n3] = this.updateTimeZoneDT(timeZone, timeZone2, stringArray[n3]);
                    ++n3;
                }
            } else {
                this.values[n] = this.updateTimeZoneDT(timeZone, timeZone2, (String)object);
            }
        } else {
            Value value;
            int n4 = TagUtils.daTagOf(n2);
            int n5 = n4 != 0 ? this.indexOf(n4) : -1;
            Value value2 = value = n5 >= 0 ? this.decodeStringValue(n5) : Value.NULL;
            if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                if (value instanceof String[]) {
                    String[] stringArray2 = (String[])value;
                    int n6 = 0;
                    while (n6 < stringArray.length) {
                        if (n6 < stringArray2.length) {
                            String string = this.updateTimeZoneDT(timeZone, timeZone2, String.valueOf(stringArray2[n6]) + stringArray[n6]);
                            stringArray2[n6] = string.substring(0, 8);
                            stringArray[n6] = string.substring(8);
                        } else {
                            stringArray[n6] = this.updateTimeZoneTM(timeZone, timeZone2, stringArray[n6]);
                        }
                        ++n6;
                    }
                } else {
                    if (value == Value.NULL) {
                        stringArray[0] = this.updateTimeZoneTM(timeZone, timeZone2, stringArray[0]);
                    } else {
                        String string = this.updateTimeZoneDT(timeZone, timeZone2, String.valueOf((String)((Object)value)) + stringArray[0]);
                        this.values[n5] = string.substring(0, 8);
                        stringArray[0] = string.substring(8);
                    }
                    int n7 = 1;
                    while (n7 < stringArray.length) {
                        stringArray[n7] = this.updateTimeZoneTM(timeZone, timeZone2, stringArray[n7]);
                        ++n7;
                    }
                }
            } else if (value instanceof String[]) {
                String[] stringArray = (String[])value;
                String string = this.updateTimeZoneDT(timeZone, timeZone2, String.valueOf(stringArray[0]) + (String)object);
                stringArray[0] = string.substring(0, 8);
                this.values[n] = string.substring(8);
            } else if (value == Value.NULL) {
                this.values[n] = this.updateTimeZoneTM(timeZone, timeZone2, (String)object);
            } else {
                String string = this.updateTimeZoneDT(timeZone, timeZone2, String.valueOf((String)((Object)value)) + (String)object);
                this.values[n5] = string.substring(0, 8);
                this.values[n] = string.substring(8);
            }
        }
    }

    private String updateTimeZoneDT(TimeZone timeZone, TimeZone timeZone2, String string) {
        char c;
        int n = string.length();
        if (n > 8 && ((c = string.charAt(n - 5)) == '+' || c == '-')) {
            return string;
        }
        try {
            DatePrecision datePrecision = new DatePrecision();
            Date date = DateUtils.parseDT(timeZone, string, false, datePrecision);
            string = DateUtils.formatDT(timeZone2, date, datePrecision);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return string;
    }

    private String updateTimeZoneTM(TimeZone timeZone, TimeZone timeZone2, String string) {
        try {
            DatePrecision datePrecision = new DatePrecision();
            Date date = DateUtils.parseTM(timeZone, string, false, datePrecision);
            string = DateUtils.formatTM(timeZone2, date, datePrecision);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return string;
    }

    public String getPrivateCreator(int n) {
        return TagUtils.isPrivateTag(n) ? this.getString(TagUtils.creatorTagOf(n), null) : null;
    }

    public Object remove(int n) {
        return this.remove(null, n);
    }

    public Object remove(String string, int n) {
        int n2 = this.indexOf(string, n);
        if (n2 < 0) {
            return null;
        }
        Object object = this.values[n2];
        int n3 = this.size - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.tags, n2 + 1, this.tags, n2, n3);
            System.arraycopy(this.vrs, n2 + 1, this.vrs, n2, n3);
            System.arraycopy(this.values, n2 + 1, this.values, n2, n3);
        }
        this.values[--this.size] = null;
        if (n == 524293) {
            this.containsSpecificCharacterSet = false;
            this.cs = null;
        } else if (n == 524801) {
            this.containsTimezoneOffsetFromUTC = false;
            this.tz = null;
        }
        return object;
    }

    public Object setNull(int n, VR vR) {
        return this.setNull(null, n, vR);
    }

    public Object setNull(String string, int n, VR vR) {
        return this.set(string, n, vR, Value.NULL);
    }

    public Object setBytes(int n, VR vR, byte[] byArray) {
        return this.setBytes(null, n, vR, byArray);
    }

    public Object setBytes(String string, int n, VR vR, byte[] byArray) {
        return this.set(string, n, vR, vR.toValue(byArray));
    }

    public Object setString(int n, VR vR, String string) {
        return this.setString((String)null, n, vR, string);
    }

    public Object setString(String string, int n, VR vR, String string2) {
        return this.set(string, n, vR, vR.toValue(string2, this.bigEndian));
    }

    public Object setString(int n, VR vR, String ... stringArray) {
        return this.setString(null, n, vR, stringArray);
    }

    public Object setString(String string, int n, VR vR, String ... stringArray) {
        return this.set(string, n, vR, vR.toValue(stringArray, this.bigEndian));
    }

    public Object setInt(int n, VR vR, int ... nArray) {
        return this.setInt(null, n, vR, nArray);
    }

    public Object setInt(String string, int n, VR vR, int ... nArray) {
        return this.set(string, n, vR, vR.toValue(nArray, this.bigEndian));
    }

    public Object setFloat(int n, VR vR, float ... fArray) {
        return this.setFloat(null, n, vR, fArray);
    }

    public Object setFloat(String string, int n, VR vR, float ... fArray) {
        return this.set(string, n, vR, vR.toValue(fArray, this.bigEndian));
    }

    public Object setDouble(int n, VR vR, double ... dArray) {
        return this.setDouble(null, n, vR, dArray);
    }

    public Object setDouble(String string, int n, VR vR, double ... dArray) {
        return this.set(string, n, vR, vR.toValue(dArray, this.bigEndian));
    }

    public Object setDate(int n, VR vR, Date ... dateArray) {
        return this.setDate(null, n, vR, dateArray);
    }

    public Object setDate(int n, VR vR, DatePrecision datePrecision, Date ... dateArray) {
        return this.setDate(null, n, vR, datePrecision, dateArray);
    }

    public Object setDate(String string, int n, VR vR, Date ... dateArray) {
        return this.setDate(string, n, vR, new DatePrecision(), dateArray);
    }

    public Object setDate(String string, int n, VR vR, DatePrecision datePrecision, Date ... dateArray) {
        return this.set(string, n, vR, vR.toValue(dateArray, vR != VR.DA ? this.getTimeZone() : null, datePrecision));
    }

    public void setDate(long l, Date date) {
        this.setDate(null, l, date);
    }

    public void setDate(long l, DatePrecision datePrecision, Date date) {
        this.setDate(null, l, datePrecision, date);
    }

    public void setDate(String string, long l, Date date) {
        this.setDate(string, l, new DatePrecision(), date);
    }

    public void setDate(String string, long l, DatePrecision datePrecision, Date date) {
        int n = (int)(l >>> 32);
        int n2 = (int)l;
        this.setDate(string, n, VR.DA, datePrecision, date);
        this.setDate(string, n2, VR.TM, datePrecision, date);
    }

    public Object setDateRange(int n, VR vR, DateRange dateRange) {
        return this.setDateRange(null, n, vR, dateRange);
    }

    public Object setDateRange(String string, int n, VR vR, DateRange dateRange) {
        return this.set(string, n, vR, Attributes.toString(dateRange, vR, this.getTimeZone()));
    }

    private static String toString(DateRange dateRange, VR vR, TimeZone timeZone) {
        DatePrecision datePrecision = new DatePrecision();
        String string = dateRange.getStartDate() != null ? (String)vR.toValue(new Date[]{dateRange.getStartDate()}, timeZone, datePrecision) : "";
        String string2 = dateRange.getEndDate() != null ? (String)vR.toValue(new Date[]{dateRange.getEndDate()}, timeZone, datePrecision) : "";
        return string.equals(string2) ? string : String.valueOf(string) + '-' + string2;
    }

    public void setDateRange(long l, DateRange dateRange) {
        this.setDateRange(null, l, dateRange);
    }

    public void setDateRange(String string, long l, DateRange dateRange) {
        int n = (int)(l >>> 32);
        int n2 = (int)l;
        this.setDateRange(string, n, VR.DA, dateRange);
        this.setDateRange(string, n2, VR.TM, dateRange);
    }

    public Object setValue(int n, VR vR, Object object) {
        return this.setValue(null, n, vR, object);
    }

    public Object setValue(String string, int n, VR vR, Object object) {
        return this.set(string, n, vR, object != null ? object : Value.NULL);
    }

    public Sequence newSequence(int n, int n2) {
        return this.newSequence(null, n, n2);
    }

    public Sequence newSequence(String string, int n, int n2) {
        Sequence sequence = new Sequence(this, n2);
        this.set(string, n, VR.SQ, sequence);
        return sequence;
    }

    public Sequence ensureSequence(int n, int n2) {
        return this.ensureSequence(null, n, n2);
    }

    public Sequence ensureSequence(String string, int n, int n2) {
        Sequence sequence;
        int n3;
        if (string != null) {
            int n4 = this.creatorTagOf(string, n, true);
            n = TagUtils.toPrivateTag(n4, n);
        }
        if ((n3 = this.indexOf(n)) >= 0) {
            Object object = this.values[n3];
            if (object instanceof Sequence) {
                sequence = (Sequence)object;
            } else {
                sequence = new Sequence(this, n2);
                this.values[n3] = sequence;
            }
        } else {
            sequence = new Sequence(this, n2);
            this.insert(-n3 - 1, n, VR.SQ, sequence);
        }
        return sequence;
    }

    public Fragments newFragments(int n, VR vR, int n2) {
        return this.newFragments(null, n, vR, n2);
    }

    public Fragments newFragments(String string, int n, VR vR, int n2) {
        Fragments fragments = new Fragments(vR, this.bigEndian, n2);
        this.set(string, n, vR, fragments);
        return fragments;
    }

    private Object set(String string, int n, VR vR, Object object) {
        if (vR == null) {
            throw new NullPointerException("vr");
        }
        if (string != null) {
            int n2 = this.creatorTagOf(string, n, true);
            n = TagUtils.toPrivateTag(n2, n);
        }
        if (TagUtils.isGroupLength(n)) {
            return null;
        }
        Object object2 = this.set(n, vR, object);
        if (n == 524293) {
            this.containsSpecificCharacterSet = true;
            this.cs = null;
        } else if (n == 524801) {
            this.containsTimezoneOffsetFromUTC = object != Value.NULL;
            this.tz = null;
        }
        return object2;
    }

    private Object set(int n, VR vR, Object object) {
        int n2 = this.indexForInsertOf(n);
        if (n2 >= 0) {
            Object object2 = this.values[n2];
            this.vrs[n2] = vR;
            this.values[n2] = object;
            return object2;
        }
        this.insert(-n2 - 1, n, vR, object);
        return null;
    }

    private void insert(int n, int n2, VR vR, Object object) {
        this.ensureCapacity(this.size + 1);
        int n3 = this.size - n;
        if (n3 > 0) {
            System.arraycopy(this.tags, n, this.tags, n + 1, n3);
            System.arraycopy(this.vrs, n, this.vrs, n + 1, n3);
            System.arraycopy(this.values, n, this.values, n + 1, n3);
        }
        this.tags[n] = n2;
        this.vrs[n] = vR;
        this.values[n] = object;
        ++this.size;
    }

    public boolean addAll(Attributes attributes) {
        return this.add(attributes, null, null, 0, 0, null, false, false, false, null);
    }

    public boolean merge(Attributes attributes) {
        return this.add(attributes, null, null, 0, 0, null, true, false, false, null);
    }

    public boolean testMerge(Attributes attributes) {
        return this.add(attributes, null, null, 0, 0, null, true, false, true, null);
    }

    public boolean addSelected(Attributes attributes, Attributes attributes2) {
        return this.add(attributes, attributes2.tags, null, 0, attributes2.size, attributes2, false, false, false, null);
    }

    public boolean addSelected(Attributes attributes, String string, int n) {
        int n2 = attributes.indexOf(n);
        if (n2 < 0) {
            return false;
        }
        Object object = attributes.values[n2];
        if (object instanceof Sequence) {
            this.set(string, n, (Sequence)object, null);
        } else if (object instanceof Fragments) {
            this.set(string, n, (Fragments)object);
        } else {
            VR vR = attributes.vrs[n2];
            this.set(string, n, vR, Attributes.toggleEndian(vR, object, this.bigEndian ^ attributes.bigEndian));
        }
        return true;
    }

    public boolean addSelected(Attributes attributes, int ... nArray) {
        return this.addSelected(attributes, nArray, 0, nArray.length);
    }

    public boolean addSelected(Attributes attributes, int[] nArray, int n, int n2) {
        return this.add(attributes, nArray, null, n, n2, null, false, false, false, null);
    }

    public boolean mergeSelected(Attributes attributes, int ... nArray) {
        return this.add(attributes, nArray, null, 0, nArray.length, null, true, false, false, null);
    }

    public boolean testMergeSelected(Attributes attributes, int ... nArray) {
        return this.add(attributes, nArray, null, 0, nArray.length, null, true, false, true, null);
    }

    public boolean addNotSelected(Attributes attributes, int ... nArray) {
        return this.addNotSelected(attributes, nArray, 0, nArray.length);
    }

    public boolean addNotSelected(Attributes attributes, int[] nArray, int n, int n2) {
        return this.add(attributes, null, nArray, n, n2, null, false, false, false, null);
    }

    private boolean add(Attributes attributes, int[] nArray, int[] nArray2, int n, int n2, Attributes attributes2, boolean bl, boolean bl2, boolean bl3, Attributes attributes3) {
        boolean bl4 = this.bigEndian ^ attributes.bigEndian;
        boolean bl5 = attributes3 != null && this.bigEndian != attributes3.bigEndian;
        int[] nArray3 = attributes.tags;
        VR[] vRArray = attributes.vrs;
        Object[] objectArray = attributes.values;
        int n3 = attributes.size;
        int n4 = 0;
        String string = null;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            block18: {
                Object object;
                VR vR;
                int n7;
                block19: {
                    Object object2;
                    int n8;
                    n7 = nArray3[n6];
                    vR = vRArray[n6];
                    object = objectArray[n6];
                    if (TagUtils.isPrivateCreator(n7) && (this.contains(n7) || vR == VR.LO && (object = attributes.decodeStringValue(n6)) instanceof String && this.creatorTagOf((String)object, n7, false) != -1) || nArray != null && Arrays.binarySearch(nArray, n, n2, n7) < 0 || nArray2 != null && Arrays.binarySearch(nArray2, n, n2, n7) >= 0) break block18;
                    if (TagUtils.isPrivateTag(n7)) {
                        n8 = TagUtils.creatorTagOf(n7);
                        if (n5 != n8) {
                            n5 = n8;
                            string = attributes.privateCreatorOf(n7);
                        }
                    } else {
                        n5 = 0;
                        string = null;
                    }
                    if (!bl && !bl2 || (n8 = this.indexOf(n7)) < 0) break block19;
                    if (bl2 && this.equalValues(attributes, n8, n6)) break block18;
                    Object object3 = object2 = this.vrs[n8].isStringType() ? this.decodeStringValue(n8) : this.values[n8];
                    if (Attributes.isEmpty(object2)) break block19;
                    if (bl) break block18;
                    if (attributes3 != null) {
                        if (object2 instanceof Sequence) {
                            attributes3.set(string, n7, (Sequence)object2, null);
                        } else if (object2 instanceof Fragments) {
                            attributes3.set(string, n7, (Fragments)object2);
                        } else {
                            attributes3.set(string, n7, vR, Attributes.toggleEndian(vR, object2, bl5));
                        }
                    }
                }
                if (!bl3) {
                    if (object instanceof Sequence) {
                        this.set(string, n7, (Sequence)object, attributes2 != null ? attributes2.getNestedDataset(n7) : null);
                    } else if (object instanceof Fragments) {
                        this.set(string, n7, (Fragments)object);
                    } else {
                        this.set(string, n7, vR, Attributes.toggleEndian(vR, object, bl4));
                    }
                }
                ++n4;
            }
            ++n6;
        }
        return n4 != 0;
    }

    public boolean update(Attributes attributes, Attributes attributes2) {
        return this.add(attributes, null, null, 0, 0, null, false, true, false, attributes2);
    }

    public boolean testUpdate(Attributes attributes, Attributes attributes2) {
        return this.add(attributes, null, null, 0, 0, null, false, true, true, attributes2);
    }

    public boolean updateSelected(Attributes attributes, Attributes attributes2, int ... nArray) {
        return this.add(attributes, nArray, null, 0, nArray.length, null, false, true, false, attributes2);
    }

    public boolean testUpdateSelected(Attributes attributes, Attributes attributes2, int ... nArray) {
        return this.add(attributes, nArray, null, 0, nArray.length, null, false, true, true, attributes2);
    }

    private static Object toggleEndian(VR vR, Object object, boolean bl) {
        return bl && object instanceof byte[] ? (Object)vR.toggleEndian((byte[])object, true) : object;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Attributes)) {
            return false;
        }
        Attributes attributes = (Attributes)object;
        if (this.size != attributes.size) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.size) {
            int n4 = this.tags[n3];
            if (!TagUtils.isPrivateGroup(n4)) {
                if (n4 != attributes.tags[n3] || !this.equalValues(attributes, n3, n3)) {
                    return false;
                }
            } else if (TagUtils.isPrivateTag(n4)) {
                int n5;
                int n6 = TagUtils.creatorTagOf(n4);
                if (n != n6) {
                    n = n6;
                    n2 = attributes.creatorTagOf(this.privateCreatorOf(n4), n4, false);
                    if (n2 == -1) {
                        return false;
                    }
                }
                if ((n5 = attributes.indexOf(TagUtils.toPrivateTag(n2, n4))) < 0 || !this.equalValues(attributes, n3, n5)) {
                    return false;
                }
            }
            ++n3;
        }
        return true;
    }

    public boolean equalValues(Attributes attributes, String string, int n) {
        int n2 = this.indexOf(string, n);
        if (n2 < 0) {
            return false;
        }
        int n3 = attributes.indexOf(string, n);
        if (n3 < 0) {
            return false;
        }
        return this.equalValues(attributes, n2, n3);
    }

    private boolean equalValues(Attributes attributes, int n, int n2) {
        VR vR = this.vrs[n];
        if (vR != attributes.vrs[n2]) {
            return false;
        }
        if (vR.isStringType()) {
            if (vR == VR.IS) {
                return this.equalISValues(attributes, n, n2);
            }
            if (vR == VR.DS) {
                return this.equalDSValues(attributes, n, n2);
            }
            return this.equalStringValues(attributes, n, n2);
        }
        Object object = this.values[n];
        Object object2 = attributes.values[n2];
        if (object instanceof byte[]) {
            if (object2 instanceof byte[] && ((byte[])object).length == ((byte[])object2).length) {
                if (this.bigEndian != attributes.bigEndian) {
                    object2 = vR.toggleEndian((byte[])object2, true);
                }
                return Arrays.equals((byte[])object, (byte[])object2);
            }
        } else {
            return object.equals(object2);
        }
        return false;
    }

    private boolean equalISValues(Attributes attributes, int n, int n2) {
        try {
            return Arrays.equals(this.decodeISValue(n), attributes.decodeISValue(n2));
        }
        catch (NumberFormatException numberFormatException) {
            return this.equalStringValues(attributes, n, n2);
        }
    }

    private boolean equalDSValues(Attributes attributes, int n, int n2) {
        try {
            return Arrays.equals(this.decodeDSValue(n), attributes.decodeDSValue(n2));
        }
        catch (NumberFormatException numberFormatException) {
            return this.equalStringValues(attributes, n, n2);
        }
    }

    private boolean equalStringValues(Attributes attributes, int n, int n2) {
        Object object = this.decodeStringValue(n);
        Object object2 = attributes.decodeStringValue(n2);
        if (object instanceof String[]) {
            if (object2 instanceof String[]) {
                return Arrays.equals((String[])object, (String[])object2);
            }
        } else {
            return object.equals(object2);
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.size) {
            int n3 = this.tags[n2];
            if (!TagUtils.isPrivateGroup(n3)) {
                n = 31 * n + n3;
            }
            ++n2;
        }
        return n;
    }

    private void set(String string, int n, Sequence sequence, Attributes attributes) {
        Sequence sequence2 = this.newSequence(string, n, sequence.size());
        for (Attributes attributes2 : sequence) {
            sequence2.add(attributes != null && !attributes.isEmpty() ? new Attributes(attributes2, this.bigEndian, attributes) : new Attributes(attributes2, this.bigEndian));
        }
    }

    private void set(String string, int n, Fragments fragments) {
        boolean bl = fragments.bigEndian() ^ this.bigEndian;
        VR vR = fragments.vr();
        Fragments fragments2 = this.newFragments(string, n, vR, fragments.size());
        for (Object e : fragments) {
            fragments2.add(Attributes.toggleEndian(vR, e, bl));
        }
    }

    public String toString() {
        return this.toString(50, 78);
    }

    public String toString(int n, int n2) {
        return this.toStringBuilder(n, n2, new StringBuilder(1024)).toString();
    }

    public StringBuilder toStringBuilder(StringBuilder stringBuilder) {
        return this.toStringBuilder(50, 78, stringBuilder);
    }

    public StringBuilder toStringBuilder(int n, int n2, StringBuilder stringBuilder) {
        if (this.appendAttributes(n, n2, stringBuilder, "") > n) {
            stringBuilder.append("...\n");
        }
        return stringBuilder;
    }

    private int appendAttributes(int n, int n2, StringBuilder stringBuilder, String string) {
        int n3 = 0;
        int n4 = 0;
        String string2 = null;
        int n5 = 0;
        while (n5 < this.size) {
            if (++n3 > n) break;
            int n6 = this.tags[n5];
            if (TagUtils.isPrivateTag(n6)) {
                int n7 = TagUtils.creatorTagOf(n6);
                if (n4 != n7) {
                    n4 = n7;
                    string2 = this.getString(n4, null);
                }
            } else {
                n4 = 0;
                string2 = null;
            }
            Object object = this.values[n5];
            this.appendAttribute(string2, n6, this.vrs[n5], object, stringBuilder.length() + n2, stringBuilder, string);
            if (object instanceof Sequence) {
                n3 += this.appendItems((Sequence)object, n - n3, n2, stringBuilder, String.valueOf(string) + '>');
            }
            ++n5;
        }
        return n3;
    }

    private int appendItems(Sequence sequence, int n, int n2, StringBuilder stringBuilder, String string) {
        int n3 = 0;
        int n4 = 0;
        for (Attributes attributes : sequence) {
            if (++n3 > n) break;
            stringBuilder.append(string).append("Item #").append(++n4).append('\n');
            n3 += attributes.appendAttributes(n - n3, n2, stringBuilder, string);
        }
        return n3;
    }

    private StringBuilder appendAttribute(String string, int n, VR vR, Object object, int n2, StringBuilder stringBuilder, String string2) {
        stringBuilder.append(string2).append(TagUtils.toString(n)).append(' ').append((Object)vR).append(" [");
        if (vR.prompt(object, this.bigEndian, this.getSpecificCharacterSet(vR), n2 - stringBuilder.length() - 1, stringBuilder)) {
            stringBuilder.append("] ").append(ElementDictionary.keywordOf(n, string));
            if (stringBuilder.length() > n2) {
                stringBuilder.setLength(n2);
            }
            stringBuilder.append('\n');
        }
        return stringBuilder;
    }

    public int calcLength(DicomEncodingOptions dicomEncodingOptions, boolean bl) {
        if (this.isEmpty()) {
            return 0;
        }
        this.groupLengths = dicomEncodingOptions.groupLength ? new int[this.countGroups()] : null;
        this.length = this.calcLength(dicomEncodingOptions, bl, this.getSpecificCharacterSet(), this.groupLengths);
        return this.length;
    }

    private int calcLength(DicomEncodingOptions dicomEncodingOptions, boolean bl, SpecificCharacterSet specificCharacterSet, int[] nArray) {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < this.size) {
            int n5;
            VR vR = this.vrs[n4];
            Object object = this.values[n4];
            int n6 = n5 = bl ? vR.headerLength() : 8;
            if (object instanceof Value) {
                n5 += ((Value)object).calcLength(dicomEncodingOptions, bl, vR);
            } else {
                if (!(object instanceof byte[])) {
                    byte[] byArray = vR.toBytes(object, specificCharacterSet);
                    object = byArray;
                    this.values[n4] = byArray;
                }
                n5 += ((byte[])object).length + 1 & 0xFFFFFFFE;
            }
            n += n5;
            if (nArray != null) {
                int n7 = TagUtils.groupLengthTagOf(this.tags[n4]);
                if (n2 != n7) {
                    n2 = n7;
                    n += 12;
                }
                int n8 = ++n3;
                nArray[n8] = nArray[n8] + n5;
            }
            ++n4;
        }
        return n;
    }

    private int countGroups() {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.size) {
            int n4 = TagUtils.groupLengthTagOf(this.tags[n3]);
            if (n != n4) {
                if (n < 0) {
                    this.groupLengthIndex0 = n2;
                }
                n = n4;
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public void writeTo(DicomOutputStream dicomOutputStream) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        if (this.groupLengths == null && dicomOutputStream.getEncodingOptions().groupLength) {
            throw new IllegalStateException("groupLengths not initialized by calcLength()");
        }
        SpecificCharacterSet specificCharacterSet = this.getSpecificCharacterSet();
        if (this.tags[0] < 0) {
            int n = -(1 + this.indexOf(0));
            this.writeTo(dicomOutputStream, specificCharacterSet, n, this.size, this.groupLengthIndex0);
            this.writeTo(dicomOutputStream, specificCharacterSet, 0, n, 0);
        } else {
            this.writeTo(dicomOutputStream, specificCharacterSet, 0, this.size, 0);
        }
    }

    public void writeItemTo(DicomOutputStream dicomOutputStream) throws IOException {
        DicomEncodingOptions dicomEncodingOptions = dicomOutputStream.getEncodingOptions();
        int n = this.getEncodedItemLength(dicomEncodingOptions, dicomOutputStream.isExplicitVR());
        dicomOutputStream.writeHeader(-73728, null, n);
        this.writeTo(dicomOutputStream);
        if (n == -1) {
            dicomOutputStream.writeHeader(-73715, null, 0);
        }
    }

    private int getEncodedItemLength(DicomEncodingOptions dicomEncodingOptions, boolean bl) {
        if (this.isEmpty()) {
            return dicomEncodingOptions.undefEmptyItemLength ? -1 : 0;
        }
        if (dicomEncodingOptions.undefItemLength) {
            return -1;
        }
        if (this.length == -1) {
            this.calcLength(dicomEncodingOptions, bl);
        }
        return this.length;
    }

    private void writeTo(DicomOutputStream dicomOutputStream, SpecificCharacterSet specificCharacterSet, int n, int n2, int n3) throws IOException {
        boolean bl = this.groupLengths != null;
        int n4 = -1;
        int n5 = n;
        while (n5 < n2) {
            int n6;
            int n7 = this.tags[n5];
            if (bl && n4 != (n6 = TagUtils.groupLengthTagOf(n7))) {
                n4 = n6;
                dicomOutputStream.writeGroupLength(n4, this.groupLengths[n3++]);
            }
            dicomOutputStream.writeAttribute(n7, this.vrs[n5], this.values[n5], specificCharacterSet);
            ++n5;
        }
    }

    public boolean accept(Visitor visitor, boolean bl) {
        int n = 0;
        while (n < this.size) {
            if (!visitor.visit(this, this.tags[n], this.vrs[n], this.values[n])) {
                return false;
            }
            if (bl && this.values[n] instanceof Sequence) {
                for (Attributes attributes : (Sequence)this.values[n]) {
                    if (attributes.accept(visitor, true)) continue;
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public void writeGroupTo(DicomOutputStream dicomOutputStream, int n) throws IOException {
        if (this.isEmpty()) {
            throw new IllegalStateException("No attributes");
        }
        this.checkInGroup(0, n);
        this.checkInGroup(this.size - 1, n);
        SpecificCharacterSet specificCharacterSet = this.getSpecificCharacterSet();
        dicomOutputStream.writeGroupLength(n, this.calcLength(dicomOutputStream.getEncodingOptions(), dicomOutputStream.isExplicitVR(), specificCharacterSet, null));
        this.writeTo(dicomOutputStream, specificCharacterSet, 0, this.size, 0);
    }

    private void checkInGroup(int n, int n2) {
        int n3 = this.tags[n];
        if (TagUtils.groupLengthTagOf(n3) != n2) {
            throw new IllegalStateException(String.valueOf(TagUtils.toString(n3)) + " does not belong to group (" + TagUtils.shortToHexString(TagUtils.groupNumber(n2)) + ",eeee).");
        }
    }

    public void writeTo(SAXWriter sAXWriter) throws SAXException {
        if (this.isEmpty()) {
            return;
        }
        SpecificCharacterSet specificCharacterSet = this.getSpecificCharacterSet();
        if (this.tags[0] < 0) {
            int n = -(1 + this.indexOf(0));
            this.writeTo(sAXWriter, specificCharacterSet, n, this.size);
            this.writeTo(sAXWriter, specificCharacterSet, 0, n);
        } else {
            this.writeTo(sAXWriter, specificCharacterSet, 0, this.size);
        }
    }

    private void writeTo(SAXWriter sAXWriter, SpecificCharacterSet specificCharacterSet, int n, int n2) throws SAXException {
        int n3 = n;
        while (n3 < n2) {
            VR vR = this.vrs[n3];
            Object object = this.values[n3];
            if (vR.isStringType() && object instanceof byte[]) {
                this.values[n3] = object = vR.toStrings((byte[])object, this.bigEndian, specificCharacterSet);
            }
            sAXWriter.writeAttribute(this.tags[n3], vR, object, specificCharacterSet, this);
            ++n3;
        }
    }

    public Attributes createFileMetaInformation(String string) {
        return Attributes.createFileMetaInformation(this.getString(524312, null), this.getString(524310, null), string);
    }

    public static Attributes createFileMetaInformation(String string, String string2, String string3) {
        if (string.isEmpty() || string2.isEmpty() || string3.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Attributes attributes = new Attributes(6);
        byte[] byArray = new byte[2];
        byArray[1] = 1;
        attributes.setBytes(131073, VR.OB, byArray);
        attributes.setString(131074, VR.UI, string2);
        attributes.setString(131075, VR.UI, string);
        attributes.setString(131088, VR.UI, string3);
        attributes.setString(131090, VR.UI, Implementation.getClassUID());
        attributes.setString(131091, VR.SH, Implementation.getVersionName());
        return attributes;
    }

    public boolean matches(Attributes attributes, boolean bl, boolean bl2) {
        int[] nArray = attributes.tags;
        VR[] vRArray = attributes.vrs;
        Object[] objectArray = attributes.values;
        int n = attributes.size;
        String string = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n3];
            if (!TagUtils.isPrivateCreator(n4)) {
                Object object;
                if (TagUtils.isPrivateGroup(n4)) {
                    int n5 = TagUtils.creatorTagOf(n4);
                    if (n2 != n5) {
                        n2 = n5;
                        string = attributes.getString(n2, null);
                    }
                } else {
                    n2 = 0;
                    string = null;
                }
                if (!Attributes.isEmpty(object = objectArray[n3])) {
                    if (vRArray[n3].isStringType()) {
                        if (!this.matches(string, n4, vRArray[n3], bl, bl2, attributes.getStrings(string, n4, null))) {
                            return false;
                        }
                    } else if (object instanceof Sequence) {
                        if (!this.matches(string, n4, bl, bl2, (Sequence)object)) {
                            return false;
                        }
                    } else {
                        throw new UnsupportedOperationException("Keys with VR: " + (Object)((Object)vRArray[n3]) + " not supported");
                    }
                }
            }
            ++n3;
        }
        return true;
    }

    private boolean matches(String string, int n, VR vR, boolean bl, boolean bl2, String[] stringArray) {
        String[] stringArray2 = this.getStrings(string, n, null);
        if (stringArray2 == null || stringArray2.length == 0) {
            return bl2;
        }
        boolean bl3 = bl && vR == VR.PN;
        String[] stringArray3 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            Object object;
            String string2 = stringArray3[n3];
            if (vR == VR.PN) {
                string2 = new PersonName(stringArray[0]).toString();
            }
            if (StringUtils.containsWildCard(string2)) {
                object = StringUtils.compilePattern(string2, bl3);
                String[] stringArray4 = stringArray2;
                int n5 = stringArray2.length;
                n4 = 0;
                while (n4 < n5) {
                    String string3 = stringArray4[n4];
                    if (string3 == null) {
                        if (bl2) {
                            return true;
                        }
                    } else {
                        if (vR == VR.PN) {
                            string3 = new PersonName(string3).toString();
                        }
                        if (((Pattern)object).matcher(string3).matches()) {
                            return true;
                        }
                    }
                    ++n4;
                }
            } else {
                String[] stringArray5 = stringArray2;
                n4 = stringArray2.length;
                int n6 = 0;
                while (n6 < n4) {
                    object = stringArray5[n6];
                    if (object == null) {
                        if (bl2) {
                            return true;
                        }
                    } else {
                        if (vR == VR.PN) {
                            object = new PersonName((String)object).toString();
                        }
                        if (bl3 ? string2.equalsIgnoreCase((String)object) : string2.equals(object)) {
                            return true;
                        }
                    }
                    ++n6;
                }
            }
            ++n3;
        }
        return false;
    }

    private boolean matches(String string, int n, boolean bl, boolean bl2, Sequence sequence) {
        int n2 = sequence.size();
        if (n2 > 1) {
            throw new IllegalArgumentException("Keys contain Sequence " + TagUtils.toString(n) + " with " + n2 + " Items");
        }
        Attributes attributes = (Attributes)sequence.get(0);
        if (attributes.isEmpty()) {
            return true;
        }
        Object object = this.getValue(string, n);
        if (object == null || Attributes.isEmpty(object)) {
            return bl2;
        }
        if (object instanceof Sequence) {
            Sequence sequence2 = (Sequence)object;
            for (Attributes attributes2 : sequence2) {
                if (!attributes2.matches(attributes, bl, bl2)) continue;
                return true;
            }
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        DicomOutputStream dicomOutputStream = new DicomOutputStream(objectOutputStream, this.bigEndian ? "1.2.840.10008.1.2.2" : "1.2.840.10008.1.2.1");
        dicomOutputStream.writeDataset(null, this);
        dicomOutputStream.writeHeader(-73715, null, 0);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(objectInputStream.readInt());
        DicomInputStream dicomInputStream = new DicomInputStream(objectInputStream, this.bigEndian ? "1.2.840.10008.1.2.2" : "1.2.840.10008.1.2.1");
        dicomInputStream.readAttributes(this, -1, -73715);
    }

    public ValidationResult validate(IOD iOD) {
        ValidationResult validationResult = new ValidationResult();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (IOD.DataElement dataElement : iOD) {
            this.validate(dataElement, validationResult, hashMap);
        }
        return validationResult;
    }

    public void validate(IOD.DataElement dataElement, ValidationResult validationResult) {
        this.validate(dataElement, validationResult, null);
    }

    private void validate(IOD.DataElement dataElement, ValidationResult validationResult, Map<String, Boolean> map) {
        Object object;
        VR vR;
        int n;
        Object object2;
        block39: {
            block41: {
                int n2;
                Sequence sequence;
                block40: {
                    IOD.Condition condition = dataElement.getCondition();
                    if (condition != null) {
                        String string = condition.id();
                        Object object3 = object2 = string != null ? map.get(string) : null;
                        if (object2 == null) {
                            object2 = condition.match(this);
                            if (string != null) {
                                map.put(string, (Boolean)object2);
                            }
                        }
                        if (!((Boolean)object2).booleanValue()) {
                            return;
                        }
                    }
                    if ((n = this.indexOf(dataElement.tag)) < 0) {
                        if (dataElement.type == IOD.DataElementType.TYPE_1 || dataElement.type == IOD.DataElementType.TYPE_2) {
                            validationResult.addMissingAttribute(dataElement);
                        }
                        return;
                    }
                    if (dataElement.type == IOD.DataElementType.TYPE_0) {
                        validationResult.addNotAllowedAttribute(dataElement);
                        return;
                    }
                    object2 = this.values[n];
                    vR = this.vrs[n];
                    if (vR.isStringType()) {
                        object2 = this.decodeStringValue(n);
                    }
                    if (Attributes.isEmpty(object2)) {
                        if (dataElement.type == IOD.DataElementType.TYPE_1) {
                            validationResult.addMissingAttributeValue(dataElement);
                        }
                        return;
                    }
                    object = dataElement.getValues();
                    if (dataElement.vr != VR.SQ) break block39;
                    if (!(object2 instanceof Sequence)) {
                        validationResult.addInvalidAttributeValue(dataElement, ValidationResult.Invalid.VR);
                        return;
                    }
                    sequence = (Sequence)object2;
                    n2 = sequence.size();
                    if (dataElement.maxVM > 0 && n2 > dataElement.maxVM) {
                        validationResult.addInvalidAttributeValue(dataElement, ValidationResult.Invalid.MultipleItems);
                        return;
                    }
                    if (!(object instanceof Code[])) break block40;
                    boolean bl = false;
                    int n3 = 0;
                    while (n3 < n2) {
                        bl = bl || !this.isValidValue((Attributes)sequence.get(n3), (Code[])object);
                        ++n3;
                    }
                    if (bl) {
                        validationResult.addInvalidAttributeValue(dataElement, ValidationResult.Invalid.Value);
                    }
                    break block41;
                }
                if (!(object instanceof IOD[])) break block41;
                IOD[] iODArray = (IOD[])object;
                int[] nArray = new int[iODArray.length];
                boolean bl = false;
                ValidationResult[] validationResultArray = new ValidationResult[n2];
                int n4 = 0;
                while (n4 < n2) {
                    ValidationResult validationResult2 = new ValidationResult();
                    HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                    Attributes attributes = (Attributes)sequence.get(n4);
                    int n5 = 0;
                    while (n5 < iODArray.length) {
                        block43: {
                            Object object4;
                            Object object5;
                            IOD iOD;
                            block42: {
                                iOD = iODArray[n5];
                                IOD.Condition condition = iOD.getCondition();
                                if (condition == null) break block42;
                                object5 = condition.id();
                                Object object6 = object4 = object5 != null ? (Boolean)hashMap.get(object5) : null;
                                if (object4 == null) {
                                    object4 = condition.match(attributes);
                                    if (object5 != null) {
                                        hashMap.put((String)object5, (Boolean)object4);
                                    }
                                }
                                if (!((Boolean)object4).booleanValue()) break block43;
                            }
                            int n6 = n5;
                            nArray[n6] = nArray[n6] + 1;
                            object4 = iOD.iterator();
                            while (object4.hasNext()) {
                                object5 = (IOD.DataElement)object4.next();
                                attributes.validate((IOD.DataElement)object5, validationResult2, hashMap);
                            }
                        }
                        ++n5;
                    }
                    bl = bl || !validationResult2.isValid();
                    validationResultArray[n4] = validationResult2;
                    ++n4;
                }
                if (bl) {
                    validationResult.addInvalidAttributeValue(dataElement, ValidationResult.Invalid.Item, validationResultArray);
                } else {
                    n4 = 0;
                    while (n4 < iODArray.length) {
                        if (iODArray[n4].getType() == IOD.DataElementType.TYPE_1 && nArray[n4] == 0) {
                            validationResult.addInvalidAttributeValue(dataElement, ValidationResult.Invalid.MissingItem);
                            break;
                        }
                        ++n4;
                    }
                }
            }
            return;
        }
        if (dataElement.maxVM > 0 || dataElement.minVM > 1) {
            int n7 = vR.vmOf(object2);
            if (dataElement.maxVM > 0 && n7 > dataElement.maxVM || dataElement.minVM > 1 && n7 < dataElement.minVM) {
                validationResult.addInvalidAttributeValue(dataElement, ValidationResult.Invalid.VM);
                return;
            }
        }
        if (object == null) {
            return;
        }
        if (object instanceof String[]) {
            if (!vR.isStringType()) {
                validationResult.addInvalidAttributeValue(dataElement, ValidationResult.Invalid.VR);
                return;
            }
            if (!this.isValidValue(Attributes.toStrings(object2), dataElement.valueNumber, (String[])object)) {
                validationResult.addInvalidAttributeValue(dataElement, ValidationResult.Invalid.Value);
            }
        } else if (object instanceof int[]) {
            if (vR == VR.IS) {
                object2 = this.decodeISValue(n);
            } else if (!vR.isIntType()) {
                validationResult.addInvalidAttributeValue(dataElement, ValidationResult.Invalid.VR);
                return;
            }
            if (!this.isValidValue(vR.toInts(object2, this.bigEndian), dataElement.valueNumber, (int[])object)) {
                validationResult.addInvalidAttributeValue(dataElement, ValidationResult.Invalid.Value);
            }
        }
    }

    private boolean isValidValue(Attributes attributes, Code[] codeArray) {
        return this.isOneOf(new Code(attributes), codeArray);
    }

    private boolean isValidValue(String[] stringArray, int n, String[] stringArray2) {
        if (n != 0) {
            return stringArray.length < n || this.isOneOf(stringArray[n - 1], stringArray2);
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (!this.isOneOf(stringArray[n2], stringArray2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private <T> boolean isOneOf(Object object, T[] TArray) {
        if (TArray == null) {
            return true;
        }
        T[] TArray2 = TArray;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray2[n2];
            if (object.equals(t)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isValidValue(int[] nArray, int n, int[] nArray2) {
        if (n != 0) {
            return nArray.length < n || this.isOneOf(nArray[n - 1], nArray2);
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (!this.isOneOf(nArray[n2], nArray2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isOneOf(int n, int[] nArray) {
        if (nArray == null) {
            return true;
        }
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            if (n == n4) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static interface Visitor {
        public boolean visit(Attributes var1, int var2, VR var3, Object var4);
    }
}

