/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.hw.manager;

import com.agfa.pacs.data.hw.manager.IQueueEntry;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.IRequestQueueVisitor;
import java.util.HashMap;
import java.util.Map;

public class RequestQueue<P extends IQueueEntry> {
    private static final ALogger log = ALogger.getLogger(RequestQueue.class);
    private static final int INITIAL_MAP_SIZE = 4096;
    static byte NUM_PRIORITIES = (byte)8;
    private static int IDLE_THRESHOLD = 1;
    private QueueEntry<P>[] queues;
    private volatile int itemPresenceMask = 0;
    private Map<Object, QueueEntry<P>> entries = new HashMap<Object, QueueEntry<P>>(4096);
    private int consumptionThreshold;

    public RequestQueue() {
        this.initQueues();
    }

    private void initQueues(int n, int n2) {
        if (this.queues == null) {
            this.queues = new QueueEntry[NUM_PRIORITIES];
        }
        int n3 = 0;
        while (n3 < this.queues.length) {
            if (n3 >= n && n3 <= n2) {
                this.queues[n3] = new QueueEntry(n3);
                ((QueueEntry)this.queues[n3]).next = (QueueEntry)this.queues[n3];
                ((QueueEntry)this.queues[n3]).previous = (QueueEntry)this.queues[n3];
            }
            ++n3;
        }
        HashMap<Object, QueueEntry<P>> hashMap = new HashMap<Object, QueueEntry<P>>(4096);
        int n4 = 0;
        while (n4 < n) {
            this.addQueueToMap(this.queues[n4], hashMap);
            ++n4;
        }
        n4 = n2;
        while (n4 < NUM_PRIORITIES) {
            this.addQueueToMap(this.queues[n4], hashMap);
            ++n4;
        }
        this.entries.clear();
        this.entries = hashMap;
        this.consumptionThreshold = NUM_PRIORITIES;
    }

    private void addQueueToMap(QueueEntry<P> queueEntry, Map<Object, QueueEntry<P>> map) {
        QueueEntry queueEntry2 = ((QueueEntry)queueEntry).next;
        while (queueEntry2 != queueEntry) {
            map.put(queueEntry2.uid, queueEntry2);
            queueEntry2 = queueEntry2.next;
        }
    }

    private void initQueues() {
        this.initQueues(0, NUM_PRIORITIES);
    }

    public synchronized void resetQueues(byte by, byte by2) {
        if (by2 > NUM_PRIORITIES) {
            by2 = NUM_PRIORITIES;
        }
        this.initQueues(by, by2);
    }

    public synchronized void resetAllQueues() {
        this.initQueues();
    }

    public synchronized void addAtTop(P p, int n) {
        QueueEntry<P> queueEntry = new QueueEntry<P>((IQueueEntry)p, n, null);
        this.entries.put(((QueueEntry)queueEntry).uid, queueEntry);
        if (n < 2) {
            queueEntry.insertAfter(this.queues[n]);
        } else {
            queueEntry.insertBefore(this.queues[n]);
        }
        this.itemPresenceMask |= 1 << 31 - n;
    }

    private QueueEntry<P> getFirstEntry(int n) {
        int n2;
        do {
            if ((n2 = Integer.numberOfLeadingZeros(this.itemPresenceMask)) <= this.consumptionThreshold && n2 <= n) continue;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
            n2 = Integer.numberOfLeadingZeros(this.itemPresenceMask);
        } while (n2 > this.consumptionThreshold || n2 > n);
        return ((QueueEntry)this.queues[n2]).next;
    }

    public synchronized void checkConsistency() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.queues.length) {
            if (((QueueEntry)this.queues[n2]).next != this.queues[n2]) {
                n |= 1 << 31 - n2;
            }
            ++n2;
        }
        log.info("Presence mask error.Recheck consistency:" + Integer.toHexString(n));
        this.itemPresenceMask = n;
    }

    public synchronized P peek(int n) {
        return (P)((QueueEntry)this.getFirstEntry(n)).payload;
    }

    public int getSize() {
        return this.entries.size();
    }

    public boolean remove(P p) {
        QueueEntry<P> queueEntry = this.entries.remove(p.getKey());
        if (queueEntry != null) {
            queueEntry.remove();
            if (((QueueEntry)this.queues[((QueueEntry)queueEntry).priority]).next == this.queues[((QueueEntry)queueEntry).priority]) {
                this.itemPresenceMask &= ~(1 << 31 - ((QueueEntry)queueEntry).priority);
            }
            return true;
        }
        return false;
    }

    public P find(Object object) {
        QueueEntry<P> queueEntry = this.entries.get(object);
        return (P)(queueEntry != null ? ((QueueEntry)queueEntry).payload : null);
    }

    public void changePriority(P p, int n) {
        QueueEntry<P> queueEntry = this.entries.get(p.getKey());
        if (queueEntry != null) {
            this.changePriority(queueEntry, n);
        }
    }

    private void changePriority(QueueEntry<P> queueEntry, int n) {
        queueEntry.remove();
        if (((QueueEntry)this.queues[((QueueEntry)queueEntry).priority]).next == this.queues[((QueueEntry)queueEntry).priority]) {
            this.itemPresenceMask &= ~(1 << 31 - ((QueueEntry)queueEntry).priority);
        }
        ((QueueEntry)queueEntry).priority = n;
        if (n < 2) {
            queueEntry.insertAfter(this.queues[n]);
        } else {
            queueEntry.insertBefore(this.queues[n]);
        }
        int n2 = this.itemPresenceMask | 1 << 31 - n;
        if (n2 != this.itemPresenceMask) {
            this.itemPresenceMask = n2;
        }
    }

    public synchronized void setIdle(boolean bl) {
        this.consumptionThreshold = bl ? (int)NUM_PRIORITIES : IDLE_THRESHOLD;
        this.notifyAll();
    }

    public boolean raisePriority(P p, int n) {
        QueueEntry<P> queueEntry = this.entries.get(p.getKey());
        if (((QueueEntry)queueEntry).priority >= n) {
            this.changePriority(queueEntry, n);
            return true;
        }
        return false;
    }

    public synchronized void visit(IRequestQueueVisitor<P> iRequestQueueVisitor) {
        int n = Integer.numberOfLeadingZeros(this.itemPresenceMask);
        int n2 = Math.min(this.consumptionThreshold + 1, this.queues.length);
        int n3 = n;
        while (n3 < n2) {
            QueueEntry queueEntry = ((QueueEntry)this.queues[n3]).next;
            while (queueEntry != this.queues[n3]) {
                QueueEntry queueEntry2 = queueEntry.next;
                if (iRequestQueueVisitor.offerRequest((Object)queueEntry.payload)) {
                    queueEntry.remove();
                    this.entries.remove(queueEntry.uid);
                    if (((QueueEntry)this.queues[queueEntry.priority]).next == this.queues[queueEntry.priority]) {
                        this.itemPresenceMask &= ~(1 << 31 - queueEntry.priority);
                    }
                    if (!iRequestQueueVisitor.wantsMore()) {
                        return;
                    }
                }
                queueEntry = queueEntry2;
            }
            ++n3;
        }
    }

    public synchronized int[] getQueueSizes() {
        int[] nArray = new int[NUM_PRIORITIES];
        int n = 0;
        while (n < NUM_PRIORITIES) {
            QueueEntry<P> queueEntry = this.queues[n];
            QueueEntry queueEntry2 = ((QueueEntry)queueEntry).next;
            int n2 = 0;
            while (queueEntry != queueEntry2) {
                ++n2;
                queueEntry2 = queueEntry2.next;
            }
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    private static class QueueEntry<S extends IQueueEntry> {
        private final Object uid;
        private S payload;
        private int priority;
        private QueueEntry<S> next;
        private QueueEntry<S> previous;

        private QueueEntry(S s, int n) {
            this.uid = s.getKey();
            this.payload = s;
            this.priority = n;
        }

        private QueueEntry(int n) {
            this.uid = "HEAD";
            this.priority = n;
            this.payload = null;
        }

        public void remove() {
            this.previous.next = this.next;
            this.next.previous = this.previous;
        }

        public void insertAfter(QueueEntry<S> queueEntry) {
            this.next = queueEntry.next;
            this.previous = queueEntry;
            this.previous.next = this;
            this.next.previous = this;
        }

        public void insertBefore(QueueEntry<S> queueEntry) {
            this.next = queueEntry;
            this.previous = queueEntry.previous;
            this.previous.next = this;
            this.next.previous = this;
        }

        /* synthetic */ QueueEntry(IQueueEntry iQueueEntry, int n, QueueEntry queueEntry) {
            this(iQueueEntry, n);
        }
    }
}

