/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.lw.dicomdir;

import com.agfa.pacs.data.lw.dicomdir.DicomDirDataInfoNodeIdentifier;
import com.agfa.pacs.data.lw.dicomdir.DicomDirDataInfoSource;
import com.agfa.pacs.data.lw.dicomdir.DicomDirPropertiesOwner;
import com.agfa.pacs.data.shared.filter.IFilter;
import com.agfa.pacs.data.shared.icon.impl.ImagePixelIconProvider;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoRetriever;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IDataProviderIdentifier;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.lw.QueryCancelException;
import com.agfa.pacs.data.shared.node.AbstractLocalDataInfoNode;
import com.agfa.pacs.data.shared.node.IDataNodeErrorCounter;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class DicomDirDataInfoNode
extends AbstractLocalDataInfoNode {
    private String dicomdirURL;
    private IDataInfoRetriever retriever;

    public DicomDirDataInfoNode(DicomDirDataInfoNodeIdentifier dicomDirDataInfoNodeIdentifier) {
        super((IDataProviderIdentifier)dicomDirDataInfoNodeIdentifier);
        this.dicomdirURL = dicomDirDataInfoNodeIdentifier.getDicomDirURL();
        this.iconProvider = new ImagePixelIconProvider();
    }

    public String getType() {
        return "DICOMDIR";
    }

    public synchronized IRootInfo getDataInfo(IFilter iFilter) throws Exception {
        this.cancel = false;
        this.retriever = null;
        DicomDirDataInfoSource dicomDirDataInfoSource = new DicomDirDataInfoSource(this.dicomdirURL, (ImagePixelIconProvider)this.iconProvider, (IDataNodeErrorCounter)this);
        dicomDirDataInfoSource.setReadDicomFiles(((DicomDirPropertiesOwner)this.dni.getPropertiesOwner()).isReadingDicomFiles());
        IRootInfo iRootInfo = dicomDirDataInfoSource.getDataInfo(iFilter);
        DataInfoUtilities.setSource((IDataInfo)iRootInfo, (IDataInfoSource)this);
        this.updateFields((IDataInfo)iRootInfo);
        if (this.cancel) {
            throw new QueryCancelException();
        }
        this.retriever = dicomDirDataInfoSource.getRetriever();
        return iRootInfo;
    }

    public List<Attributes> rawDicomSearch(Attributes attributes, String string) {
        throw new UnsupportedOperationException("no raw dicom data fetch yet from dicom dir");
    }

    private void updateFields(IDataInfo iDataInfo) {
        int n;
        if (iDataInfo instanceof ISeriesInfo) {
            iDataInfo.getAttributes().setInt(2101769, VR.IS, new int[]{iDataInfo.children().size()});
        }
        if (iDataInfo instanceof IStudyInfo) {
            n = 0;
            for (IDataInfo iDataInfo2 : iDataInfo.children()) {
                this.updateFields(iDataInfo2);
                n += iDataInfo2.getAttributes().getInt(2101769, 0);
            }
            iDataInfo.getAttributes().setInt(2101766, VR.IS, new int[]{iDataInfo.children().size()});
            iDataInfo.getAttributes().setInt(2101768, VR.IS, new int[]{n});
        }
        if (iDataInfo instanceof IPatientInfo) {
            n = 0;
            int n2 = 0;
            for (IDataInfo iDataInfo3 : iDataInfo.children()) {
                this.updateFields(iDataInfo3);
                n += iDataInfo3.getAttributes().getInt(2101768, 0);
                n2 += iDataInfo3.getAttributes().getInt(2101766, 0);
            }
            iDataInfo.getAttributes().setInt(0x201200, VR.IS, new int[]{iDataInfo.children().size()});
            iDataInfo.getAttributes().setInt(0x201202, VR.IS, new int[]{n2});
            iDataInfo.getAttributes().setInt(2101764, VR.IS, new int[]{n});
        }
    }

    public synchronized IDataInfoRetriever getRetriever() {
        return this.retriever;
    }
}

