/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.integration.impl.factory;

import com.agfa.integration.IScriptInterpreter;
import com.agfa.pacs.core.FactorySelector;
import java.util.Arrays;
import java.util.Comparator;

public abstract class ScriptInterpreterFactory {
    private static ScriptInterpreterFactory implementation;

    public static IScriptInterpreter[] getInterpreters() {
        if (implementation == null) {
            ScriptInterpreterFactory.initialize();
        }
        IScriptInterpreter[] iScriptInterpreterArray = implementation.getScriptInterpretersInt();
        Arrays.sort(iScriptInterpreterArray, new MyComparator());
        return iScriptInterpreterArray;
    }

    protected abstract IScriptInterpreter[] getScriptInterpretersInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)ScriptInterpreterFactory.class.getName()));
            implementation = (ScriptInterpreterFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + ScriptInterpreterFactory.class.getName(), reflectiveOperationException);
        }
    }

    private static class MyComparator
    implements Comparator<IScriptInterpreter> {
        private MyComparator() {
        }

        @Override
        public int compare(IScriptInterpreter iScriptInterpreter, IScriptInterpreter iScriptInterpreter2) {
            return iScriptInterpreter2.getPriority() - iScriptInterpreter.getPriority();
        }
    }
}

