/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.integration.impl;

import com.agfa.integration.IMethodResolver;
import com.agfa.integration.ext.ExtendedFuture;
import com.agfa.integration.ext.IActorMessage;
import com.agfa.integration.ext.INotificationMessage;
import com.agfa.integration.ext.ITransformer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class TransformerInfo {
    public final ITransformer transformer;
    public final String name;
    public final String forActor;
    public final int priority;
    public final boolean inJumpstart;
    public final IMethodResolver methodResolver;
    public final Properties properties;

    public TransformerInfo(ITransformer iTransformer, String string, String string2, int n) {
        this.transformer = iTransformer;
        this.name = string;
        this.forActor = string2;
        this.priority = n;
        this.inJumpstart = false;
        this.methodResolver = this.createMethodResolver();
        this.properties = null;
    }

    public TransformerInfo(ITransformer iTransformer, String string, boolean bl) {
        this.transformer = iTransformer;
        this.name = string;
        this.forActor = null;
        this.priority = 0;
        this.inJumpstart = bl;
        this.methodResolver = this.createMethodResolver();
        this.properties = null;
    }

    public TransformerInfo(ITransformer iTransformer, String string, String string2, int n, boolean bl, Properties properties) {
        this.transformer = iTransformer;
        this.name = string;
        this.forActor = string2;
        this.priority = n;
        this.inJumpstart = bl;
        this.methodResolver = this.createMethodResolver();
        this.properties = properties;
    }

    protected IMethodResolver createMethodResolver() {
        if (this.transformer instanceof IMethodResolver) {
            return (IMethodResolver)((Object)this.transformer);
        }
        return new IMethodResolver(){
            Map<String, Method> inbound;
            Map<String, Method> outbound;
            {
                this.inbound = TransformerInfo.this.getMethods(IActorMessage.class, ExtendedFuture.class);
                this.outbound = TransformerInfo.this.getMethods(INotificationMessage.class, null);
            }

            @Override
            public Map<String, Method> resolveMethods(Class<?> clazz) {
                if (IActorMessage.class.equals(clazz)) {
                    return this.inbound;
                }
                if (INotificationMessage.class.equals(clazz)) {
                    return this.outbound;
                }
                return null;
            }
        };
    }

    protected boolean hasInterface(Class<?> clazz, Class<?> clazz2) {
        if (clazz2.equals(clazz)) {
            return true;
        }
        Class<?>[] classArray = clazz2.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz3 = classArray[n2];
            if (clazz3.equals(clazz)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected Map<String, Method> getMethods(Class<?> clazz, Class<?> clazz2) {
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        Method[] methodArray = this.transformer.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] classArray;
            Method method = methodArray[n2];
            if ((clazz2 == null || method.getReturnType() == clazz2) && Modifier.isPublic(method.getModifiers()) && (classArray = method.getParameterTypes()).length == 1 && this.hasInterface(clazz, classArray[0])) {
                hashMap.put(method.getName(), method);
            }
            ++n2;
        }
        return hashMap;
    }
}

