/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.integration.impl;

import com.agfa.integration.IDesktopIntegrationListener;
import com.agfa.integration.IDesktopIntegrationProvider;
import com.agfa.integration.ext.ExtendedFuture;
import com.agfa.integration.ext.IStatus;
import com.agfa.integration.impl.DesktopIntegrationProviderInfo;
import com.agfa.integration.impl.factory.DesktopIntegrationFactory;
import com.agfa.pacs.logging.ALogger;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;

public class PriorityDesktopIntegrationProvider
implements IDesktopIntegrationProvider {
    private static final ALogger log = ALogger.getLogger(PriorityDesktopIntegrationProvider.class);
    protected IDesktopIntegrationProvider provider;

    public PriorityDesktopIntegrationProvider() {
        this(DesktopIntegrationFactory.getDesktopIntegrations());
    }

    public PriorityDesktopIntegrationProvider(List<DesktopIntegrationProviderInfo> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("No desktop integrator found");
        }
        if (list.size() > 1) {
            log.info("Multiple desktop integrators available " + list.size());
            Collections.sort(list, new Comparator<DesktopIntegrationProviderInfo>(){

                @Override
                public int compare(DesktopIntegrationProviderInfo desktopIntegrationProviderInfo, DesktopIntegrationProviderInfo desktopIntegrationProviderInfo2) {
                    return desktopIntegrationProviderInfo.getPrority() - desktopIntegrationProviderInfo2.getPrority();
                }
            });
        }
        this.provider = list.get(0).getProvider();
    }

    @Override
    public IDesktopIntegrationListener getListener() {
        return this.provider.getListener();
    }

    @Override
    public void awake(String string, String string2, ExtendedFuture<IStatus> extendedFuture) {
        this.provider.awake(string, string2, extendedFuture);
    }

    @Override
    public void shutdown() {
        this.provider.shutdown();
    }

    @Override
    public boolean isActorActive(String string) {
        return this.provider.isActorActive(string);
    }

    @Override
    public Properties getActorProperties(String string) {
        return this.provider.getActorProperties(string);
    }

    @Override
    public String getLoggedUser() {
        return this.provider.getLoggedUser();
    }

    @Override
    public String getLoggedPassword() {
        return this.provider.getLoggedPassword();
    }
}

