/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.integration.impl;

import com.agfa.integration.ext.EventConst;
import com.agfa.integration.ext.INotificationMessage;
import com.agfa.integration.impl.IntegrationFramework;
import com.agfa.integration.impl.TransformerInfo;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.event.IUndoInformation;
import com.agfa.pacs.logging.ALogger;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class NotificationSubDispatcher
implements IEventListener {
    private static ALogger log = ALogger.getLogger(NotificationSubDispatcher.class);
    private String actor;
    private List<TransformerInfo> transformers;
    private IntegrationFramework framework;

    public NotificationSubDispatcher(IntegrationFramework integrationFramework, List<TransformerInfo> list) {
        this.framework = integrationFramework;
        this.actor = list.get((int)0).forActor;
        if (this.actor == null) {
            this.actor = list.get((int)0).name;
        }
        this.transformers = new ArrayList<TransformerInfo>(list);
        Collections.sort(this.transformers, new Comparator<TransformerInfo>(){

            @Override
            public int compare(TransformerInfo transformerInfo, TransformerInfo transformerInfo2) {
                return transformerInfo.priority - transformerInfo2.priority;
            }
        });
    }

    public boolean handleEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
        INotificationMessage iNotificationMessage;
        String string;
        if (iEvent.getEventID() == this.getEventId() & iEvent.getPayload() instanceof INotificationMessage && ((string = (iNotificationMessage = (INotificationMessage)iEvent.getPayload()).getForActor()) == null || string.equals(this.actor))) {
            return this.dispatch(iNotificationMessage);
        }
        return false;
    }

    public boolean dispatch(INotificationMessage iNotificationMessage) throws UnsupportedOperationException {
        if (log.isDebugEnabled()) {
            log.debug("Processing method call [" + iNotificationMessage.getMethodName() + "]");
        }
        Object object = null;
        Method method = null;
        for (TransformerInfo transformerInfo : this.transformers) {
            Map<String, Method> map = transformerInfo.methodResolver.resolveMethods(INotificationMessage.class);
            if (map == null || (method = map.get(iNotificationMessage.getMethodName())) == null) continue;
            object = transformerInfo.transformer;
            break;
        }
        if (method == null) {
            log.info("No transformer for " + this.actor + " implements the method [" + iNotificationMessage.getMethodName() + "]");
            return false;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Invoking method [" + iNotificationMessage.getMethodName() + "] on " + object);
            }
            iNotificationMessage.put("source", this.framework.getName());
            method.invoke(object, iNotificationMessage);
            return true;
        }
        catch (Exception exception) {
            log.error(MessageFormat.format("Problem on parameter handling. Error in {0}#{1}", object.getClass(), method.getName()), (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public String getActorName() {
        return this.actor;
    }

    public boolean handleUndoEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
        return false;
    }

    public IListenerSynchronization getSync() {
        return null;
    }

    protected int getEventId() {
        return EventConst.framework2transformer;
    }
}

