/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ObjectID {
    public static final String FIELD_DELIMETER = "&";
    public static final String STUDY_DELIMETER = "\u00a7";
    private String studyUID = null;
    private String patientID = null;
    private String issuerOfPatientId = null;
    private String accessionNr = null;
    private boolean isFullStudy = true;
    private String modalityInStudy = null;
    private String status;
    private List<String> instanceUIDs = null;
    private int modifier = 0;

    public static ObjectID forStudyUID(String string) {
        ObjectID objectID = new ObjectID();
        objectID.studyUID = string;
        return objectID;
    }

    public static ObjectID[] forStudyUID(List<String> list) {
        ObjectID[] objectIDArray = new ObjectID[list.size()];
        int n = 0;
        while (n < list.size()) {
            objectIDArray[n] = ObjectID.forStudyUID(list.get(n));
            ++n;
        }
        return objectIDArray;
    }

    public static ObjectID forStudyUIDPatient(String string, String string2, String string3) {
        ObjectID objectID = new ObjectID();
        objectID.patientID = string;
        objectID.issuerOfPatientId = string2;
        objectID.studyUID = string3;
        return objectID;
    }

    public static ObjectID create(String string, String string2, String string3, String string4) {
        ObjectID objectID = new ObjectID();
        objectID.patientID = string;
        objectID.issuerOfPatientId = string2;
        objectID.studyUID = string3;
        objectID.accessionNr = string4;
        return objectID;
    }

    public static ObjectID forSingleInstance(String string, String string2) {
        ObjectID objectID = new ObjectID();
        objectID.patientID = string;
        objectID.instanceUIDs = Collections.singletonList(string2);
        return objectID;
    }

    public static ObjectID forPatientAccesion(String string, String string2, String string3) {
        ObjectID objectID = new ObjectID();
        objectID.patientID = string;
        objectID.issuerOfPatientId = string2;
        objectID.accessionNr = string3;
        return objectID;
    }

    public static ObjectID forPatientAccesion(String string, String string2) {
        return ObjectID.forPatientAccesion(string, null, string2);
    }

    public static ObjectID forSingleInstance(List<String> list) {
        ObjectID objectID = new ObjectID();
        objectID.instanceUIDs = list;
        objectID.isFullStudy = false;
        return objectID;
    }

    public static ObjectID forSingleInstance(String[] stringArray) {
        ObjectID objectID = new ObjectID();
        objectID.instanceUIDs = new ArrayList<String>((Collection)Arrays.asList(stringArray));
        objectID.isFullStudy = false;
        return objectID;
    }

    public List<String> getInstanceUIDs() {
        return this.instanceUIDs;
    }

    public boolean isFullStudy() {
        return this.isFullStudy;
    }

    public boolean isEmpty() {
        return this.patientID == null && this.studyUID == null && this.accessionNr == null && this.instanceUIDs == null;
    }

    public String getAccessionNr() {
        return this.accessionNr;
    }

    public String getPatientID() {
        return this.patientID;
    }

    public String getIssuerOfPatientID() {
        return this.issuerOfPatientId;
    }

    public String getStudyUID() {
        return this.studyUID;
    }

    public void setAccessionNr(String string) {
        this.accessionNr = string;
    }

    public void setPatientID(String string) {
        this.patientID = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public String getModalityInStudy() {
        return this.modalityInStudy;
    }

    public void setModalityInStudy(String string) {
        this.modalityInStudy = string;
    }

    public void setIssuerOfPatientID(String string) {
        this.issuerOfPatientId = string;
    }

    public void setStudyUID(String string) {
        this.studyUID = string;
    }

    public int getModifier() {
        return this.modifier;
    }

    public void setModifier(int n) {
        this.modifier = n;
    }

    private String getID() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isFullStudy) {
            stringBuilder.append(this.studyUID == null ? "" : this.studyUID);
            stringBuilder.append(this.patientID == null ? "" : this.patientID);
            stringBuilder.append(this.issuerOfPatientId == null ? "" : this.issuerOfPatientId);
            stringBuilder.append(this.accessionNr == null ? "" : this.accessionNr);
        } else {
            for (String string : this.instanceUIDs) {
                stringBuilder.append(string).append("|");
            }
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ObjectID)) {
            return false;
        }
        String string = this.getID();
        String string2 = ((ObjectID)object).getID();
        return string.equals(string2);
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        if (this.patientID != null) {
            stringBuilder.append("patientID=").append(this.patientID);
        }
        if (this.issuerOfPatientId != null) {
            stringBuilder.append(FIELD_DELIMETER).append(this.issuerOfPatientId);
        }
        if (this.studyUID != null) {
            this.appendParameter(stringBuilder);
            stringBuilder.append("studyUID=").append(this.studyUID);
        }
        if (this.accessionNr != null) {
            this.appendParameter(stringBuilder);
            stringBuilder.append("accessionNr=").append(this.accessionNr);
        }
        if (this.instanceUIDs != null) {
            this.appendParameter(stringBuilder);
            stringBuilder.append("Explizit SOPInstanceUIDs:").append(this.instanceUIDs.size());
        }
        return stringBuilder.toString();
    }

    private void appendParameter(StringBuilder stringBuilder) {
        if (stringBuilder.length() != 0) {
            stringBuilder.append(',');
        }
    }
}

