/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.util;

import com.agfa.pacs.base.Messages;
import com.agfa.pacs.core.ApplicationManagement;
import com.agfa.pacs.core.ApplicationType;
import com.agfa.pacs.core.IApplicationInformation;
import com.agfa.pacs.core.app.ApplicationInformationFactory;
import com.agfa.pacs.tools.BundleContext;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Calendar;
import java.util.Date;
import java.util.Dictionary;

public class Product {
    private static final String DUMMY = "";
    private static final String VERSION_PREFIX = "R20 XV SU2";
    private static String version = null;
    private static final double servicesVersionMinimum = 4.0;
    private static final double servicesVersionRecommended = 4.2;
    private static String longVersion = null;
    private static Date firstReleaseDate = Product.getFirstReleaseDate_Impl();
    private static Date lastReleaseDate = Product.getLastReleaseDate_Impl();
    public static final int copyrightYearFrom = 2008;
    public static final int copyrightYearTo = 2015;
    private static String productName = "IMPAX EE";
    private static boolean isInOfflineMode = false;
    private static final boolean isReleasedVersion = true;
    private static boolean isInEmergencyMode = false;
    private static boolean hasReducedConfiguration = false;
    private static boolean runningAsPasta = false;
    private static final String productVendor = "Agfa HealthCare N.V.";
    private static final String[] ownerInfo = new String[]{"Agfa HealthCare N.V.", "Septestraat 27", "B-2640 Mortsel", "Belgium"};
    private static final String website = "http://www.agfahealthcare.com/";

    static {
        IApplicationInformation iApplicationInformation = ApplicationInformationFactory.getInstance().getApplicationInformation();
        if (iApplicationInformation != null) {
            productName = iApplicationInformation.getName();
            version = iApplicationInformation.getVersion();
        }
    }

    public static String getProductVendor() {
        return productVendor;
    }

    public static String[] getOwnerInfo() {
        return ownerInfo;
    }

    public static boolean hasReducedResources() {
        return Product.isCDViewer() || Product.isReducedVersion();
    }

    public static String getWebsite() {
        return website;
    }

    @SuppressWarnings(value={"DB_DUPLICATE_BRANCHES"}, justification="VERSION_PREFIX is an empty string, but this could change.")
    public static String getVersionString() {
        if (version == null) {
            version = VERSION_PREFIX == null || VERSION_PREFIX.length() == 0 ? DUMMY : VERSION_PREFIX;
        }
        return version;
    }

    public static String getLongVersionString() {
        if (longVersion == null) {
            Dictionary dictionary = BundleContext.getBundleContext().getBundle(Product.class).getHeaders();
            String string = (String)dictionary.get("Bundle-Version");
            int n = string.indexOf("v");
            int n2 = string.indexOf("r");
            if (n > 0 && n2 > 0) {
                String string2 = string.substring(n, n2 - 1);
                longVersion = "R20 XV SU2 " + string2;
            } else {
                longVersion = VERSION_PREFIX;
            }
        }
        return longVersion;
    }

    public static double getServicesVersionRecommended() {
        return 4.2;
    }

    public static double getServicesVersionMinimum() {
        return 4.0;
    }

    public static void setIsPasta() {
        runningAsPasta = true;
        Product.getVersionString();
        version = version.replace("R20 ", DUMMY);
        Product.getLongVersionString();
        longVersion = longVersion.replace("R20 ", DUMMY);
        productName = "Agfa Transport";
    }

    public static void setRestrictedConfiguration() {
        hasReducedConfiguration = true;
    }

    public static boolean isCDViewer() {
        return ApplicationManagement.getInstance().getApplicationType() == ApplicationType.ImpaxEECDViewer;
    }

    public static boolean isReducedVersion() {
        return ApplicationManagement.getInstance().getApplicationType() == ApplicationType.ImpaxEEReduced;
    }

    public static boolean isPasta() {
        return runningAsPasta;
    }

    public static boolean isInOfflineModus() {
        return isInOfflineMode;
    }

    public static void setIsInOfflineModus() {
        isInOfflineMode = true;
    }

    public static boolean isHeadless() {
        String string = System.getProperty("java.awt.headless");
        return string != null && Boolean.parseBoolean(string);
    }

    public static boolean hasFullConfiguration() {
        return !hasReducedConfiguration;
    }

    public static String getProductName() {
        return productName;
    }

    public static Date getFirstReleaseDate() {
        return firstReleaseDate;
    }

    public static Date getLastReleaseDate() {
        return lastReleaseDate;
    }

    public static boolean isReleasedVersion() {
        return true;
    }

    public static boolean isInEmergencyMode() {
        return isInEmergencyMode;
    }

    public static void setInEmergencyMode(boolean bl) {
        isInEmergencyMode = bl;
    }

    public static String getReleaseConstraintsText() {
        return Product.isReleasedVersion() && !Product.isCDViewer() && !Product.isReducedVersion() ? DUMMY : " " + Messages.getString("Product.NotForClinicalUse");
    }

    private static Date getFirstReleaseDate_Impl() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2008, 0, 1);
        return calendar.getTime();
    }

    public static boolean isRunningAutoTests() {
        return System.getProperties().containsKey("script.file");
    }

    private static Date getLastReleaseDate_Impl() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2015, 0, 1);
        return calendar.getTime();
    }

    public static void main(String[] stringArray) {
        if (VERSION_PREFIX == null || VERSION_PREFIX.length() == 0) {
            System.out.println("Unrelesead Version");
        } else {
            System.out.println(VERSION_PREFIX);
        }
        System.exit(0);
    }
}

