/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.util;

import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class PatientMergeUtilities {
    public static void addMPIStudiesToPatient(IPatientInfo iPatientInfo, List<IStudyInfo> list) {
        if (list.isEmpty()) {
            return;
        }
        PatientMergeUtilities.markPatientMerged(iPatientInfo, list.get(0).getPatient());
        for (IStudyInfo iStudyInfo : list) {
            if (iPatientInfo.children().contains(iStudyInfo)) continue;
            iPatientInfo.addChild((IDataInfo)iStudyInfo);
        }
    }

    public static void markPatientMerged(IPatientInfo iPatientInfo, IPatientInfo iPatientInfo2) {
        String string;
        Attributes attributes = iPatientInfo.getAttributes();
        String string2 = attributes.getString(0x100010, null);
        boolean bl = true;
        if (attributes.getProperty("MPI_QUERY", null) != null) {
            bl = attributes.getProperty("MPI_QUERY", null).equals(PatientMergeStatus.MergedSameName.name());
        }
        if (!(string = iPatientInfo2.getAttributes().getString(0x100010, null)).equals(string2)) {
            bl = false;
        }
        attributes.setProperty("MPI_QUERY", (Object)(bl ? PatientMergeStatus.MergedSameName.name() : PatientMergeStatus.MergedDifferentName.name()));
    }

    public static PatientMergeStatus getPatientMergeStatus(Attributes attributes) {
        String string = (String)attributes.getProperty("MPI_QUERY", null);
        if (string == null) {
            return PatientMergeStatus.NotMerged;
        }
        return PatientMergeStatus.valueOf(string);
    }

    public static enum PatientMergeStatus {
        NotMerged,
        MergedSameName,
        MergedDifferentName;

    }
}

