/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.util;

import com.agfa.pacs.base.Messages;
import java.util.Date;

public class AgeUtil {
    private static final long DAY = 86400000L;
    private static final long WEEK = 604800000L;
    private static final long MONTH = 2592000000L;
    private static final long YEAR = 31536000000L;
    private static final long YEAR4 = 126230400000L;

    private static final String formatNumber(long l, boolean bl) {
        String string = Long.toString(l);
        if (bl) {
            while (string.length() < 3) {
                string = "0" + string;
            }
        }
        return string;
    }

    public static final String formatPatientAge(String string) {
        if (string != null) {
            while (string.startsWith("0")) {
                string = string.substring(1);
            }
        }
        return string;
    }

    public static String getCurrentAgeLocalized(Date date) {
        return AgeUtil.getAgeInt(date, new Date(), false);
    }

    public static String getAgeLocalized(Date date, Date date2) {
        return AgeUtil.getAgeInt(date, date2, false);
    }

    public static String getCurrentAge(Date date) {
        return AgeUtil.getAgeInt(date, new Date(), true);
    }

    public static String getAge(Date date, Date date2) {
        return AgeUtil.getAgeInt(date, date2, true);
    }

    private static String getAgeInt(Date date, Date date2, boolean bl) {
        long l = date2.getTime() - date.getTime();
        long l2 = l / 86400000L;
        if (l2 < 14L) {
            return String.valueOf(AgeUtil.formatNumber(l2, bl)) + TimePeriod.Day.getString(!bl);
        }
        l2 = l / 604800000L;
        if (l2 <= 12L) {
            return String.valueOf(AgeUtil.formatNumber(l2, bl)) + TimePeriod.Week.getString(!bl);
        }
        l2 = l / 2592000000L;
        if (l2 < 24L) {
            return String.valueOf(AgeUtil.formatNumber(l2, bl)) + TimePeriod.Month.getString(!bl);
        }
        l2 = l / 126230400000L;
        long l3 = (l - l2 * 126230400000L) / 31536000000L;
        l2 = l2 * 4L + l3;
        return String.valueOf(AgeUtil.formatNumber(l2, bl)) + TimePeriod.Year.getString(!bl);
    }

    public static enum TimePeriod {
        Day("D"),
        Week("W"),
        Month("M"),
        Year("Y");

        private String dicomString;

        private TimePeriod(String string2) {
            this.dicomString = string2;
        }

        public String getString(boolean bl) {
            if (bl) {
                return Messages.getString("TimePeriod." + this.name());
            }
            return this.dicomString;
        }
    }
}

