/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.print.renderer;

import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationSizeMode;
import com.agfa.pacs.listtext.dicomobject.presentation.rendering.PresentationRenderContext;
import com.agfa.pacs.listtext.print.renderer.Annotation;
import com.agfa.pacs.listtext.print.renderer.FilmBox;
import com.agfa.pacs.listtext.print.renderer.FilmBoxSheet;
import com.agfa.pacs.listtext.print.renderer.ImageBox;
import com.agfa.pacs.listtext.print.renderer.exception.FilmBoxLayoutException;
import com.agfa.pacs.listtext.print.renderer.exception.FilmBoxRenderingException;
import com.agfa.pacs.listtext.print.renderer.exception.FilmBoxRenderingImageFittingException;
import com.agfa.pacs.logging.ALogger;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

public class FilmBoxRenderer
implements Printable {
    public static final String PRINTING_OUTPUT_DEVICE = "PRINT";
    private static final ALogger log = ALogger.getLogger(FilmBoxRenderer.class);
    public static final int PRINTING_RESOLUTION = 300;
    private FilmBoxSheet fbs = null;
    protected double width;
    protected double height;
    protected int resolution;
    private int baseResolution;
    private Graphics2D graphics;
    private int biType;
    private boolean painted = true;
    private boolean paintBackground = false;
    private boolean scaleInPixel = true;
    private boolean preview = false;
    private Double zoomRatio = null;

    public FilmBoxRenderer(FilmBoxSheet filmBoxSheet, boolean bl) {
        this.fbs = filmBoxSheet;
        this.setResolutionPixelPerInch(72);
        this.preview = bl;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public void setZoomRatio(Double d) {
        this.zoomRatio = d;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public boolean isPaintBackground() {
        return this.paintBackground;
    }

    public void setPaintBackground(boolean bl) {
        this.paintBackground = bl;
    }

    public void setResolutionPixelPerInch(int n) {
        this.resolution = n;
        this.baseResolution = n;
    }

    public void setGraphics(Graphics2D graphics2D, int n) {
        this.graphics = graphics2D;
        this.biType = n;
    }

    public int toPixel(double d) {
        return (int)(d * (double)this.resolution / 25.4);
    }

    public double fromPixel(int n) {
        return (double)(n / this.resolution) * 25.4;
    }

    public int getPixelWidth() {
        return this.toPixel(this.width);
    }

    public int getPixelHeight() {
        return this.toPixel(this.height);
    }

    private void setPixelSpacing(PresentationRenderContext presentationRenderContext) {
        double d = this.resolution;
        if (this.zoomRatio != null) {
            d *= this.zoomRatio.doubleValue();
        }
        presentationRenderContext.setPixelSpacingDPI(d, d);
    }

    public double getPrintingPixelSpacing() {
        double d = this.resolution;
        if (this.zoomRatio != null) {
            d *= this.zoomRatio.doubleValue();
        }
        return 25.4 / d;
    }

    public void render(FilmBoxSheet filmBoxSheet) {
        this.scaleInPixel = true;
        this.renderFilmBoxImpl(filmBoxSheet.getFilmBox());
    }

    private void renderFilmBoxImpl(FilmBox filmBox) {
        this.renderCustomLogo();
        this.renderLayout(filmBox);
        this.renderImageBoxes(filmBox);
        this.renderAnnotations(filmBox);
    }

    private void renderLayout(FilmBox filmBox) {
        int n = this.toPixel(this.width);
        int n2 = this.toPixel(this.height);
        if (this.paintBackground) {
            this.graphics.setColor(filmBox.getGapColor());
            this.graphics.fillRect(0, 0, n, n2);
        }
    }

    private void renderImageBox(ImageBox imageBox) throws FilmBoxRenderingException {
        if (imageBox.isEmpty()) {
            return;
        }
        double d = 1.0;
        if (!this.scaleInPixel && this.resolution > 300) {
            d = (double)this.resolution / 300.0;
            this.resolution = 300;
        }
        int n = this.toPixel(imageBox.getPosX());
        int n2 = this.toPixel(imageBox.getPosY());
        int n3 = this.toPixel(imageBox.getWidth());
        int n4 = this.toPixel(imageBox.getHeight());
        int n5 = n3;
        int n6 = n4;
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        AffineTransform affineTransform = (AffineTransform)this.graphics.getTransform().clone();
        if (d != 1.0) {
            this.graphics.scale(d, d);
        }
        this.graphics.setClip(rectangle);
        this.graphics.translate(n, n2);
        PresentationRenderContext presentationRenderContext = new PresentationRenderContext(this.graphics, n5, n6, this.biType);
        presentationRenderContext.setPreviewMode(this.preview);
        this.setPixelSpacing(presentationRenderContext);
        presentationRenderContext.setApplyMapping(imageBox.isIncludeMappings(), !imageBox.isMappingsOutside());
        presentationRenderContext.setDevice(PRINTING_OUTPUT_DEVICE);
        presentationRenderContext.setSizeMode(imageBox.getImageFitting() == ImageBox.ImageFitting.Crop ? PresentationSizeMode.TrueSize : PresentationSizeMode.ScaleToFit);
        imageBox.render(presentationRenderContext);
        this.graphics.setTransform(affineTransform);
        if (imageBox.getImageFitting() == ImageBox.ImageFitting.None) {
            if (presentationRenderContext.getWidth() > presentationRenderContext.getGraphicsWidth()) {
                throw new FilmBoxRenderingImageFittingException("No scaling/croping: Image width exceeds image box width", FilmBoxRenderingImageFittingException.Axis.Width);
            }
            if (presentationRenderContext.getHeight() > presentationRenderContext.getGraphicsHeight()) {
                throw new FilmBoxRenderingImageFittingException("No scaling/croping: Image height exceeds image box height", FilmBoxRenderingImageFittingException.Axis.Height);
            }
        }
        this.graphics.setClip(null);
    }

    private void renderImageBoxes(FilmBox filmBox) {
        for (ImageBox imageBox : filmBox.imageBoxes()) {
            try {
                this.resolution = this.baseResolution;
                this.renderImageBox(imageBox);
            }
            catch (FilmBoxRenderingException filmBoxRenderingException) {
                log.error("Error", (Throwable)filmBoxRenderingException);
            }
        }
    }

    private void renderAnnotations(FilmBox filmBox) {
        for (Annotation annotation : filmBox.annotations()) {
            annotation.render(this.graphics, this.resolution);
        }
    }

    private void renderCustomLogo() {
        if (this.fbs.getCustomLogo() != null) {
            int n = this.fbs.getCustomLogo().getWidth(null);
            int n2 = this.fbs.getCustomLogo().getHeight(null);
            int n3 = 0;
            switch (this.fbs.getCustomLogoAlignment()) {
                case 0: {
                    n3 = this.toPixel(FilmBoxSheet.paper2mm(this.fbs.getPaper().getImageableX()));
                    break;
                }
                case 1: {
                    n3 = this.toPixel(FilmBoxSheet.paper2mm(this.fbs.getPaper().getImageableWidth() / 2.0)) - n / 2;
                    break;
                }
                case 2: {
                    n3 = this.toPixel(FilmBoxSheet.paper2mm(this.fbs.getPaper().getImageableWidth() - this.fbs.getPaper().getImageableX())) - n;
                }
            }
            int n4 = this.toPixel(FilmBoxSheet.paper2mm(this.fbs.getPaper().getImageableY())) - n2;
            this.graphics.drawImage(this.fbs.getCustomLogo(), n3, n4, n, n2, null);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        this.scaleInPixel = false;
        if (n == 0) {
            if (!this.painted) {
                try {
                    this.fbs.layout(pageFormat.getPaper());
                }
                catch (FilmBoxLayoutException filmBoxLayoutException) {
                    log.error("Could not layout", (Throwable)filmBoxLayoutException);
                }
                this.width = FilmBoxSheet.paper2mm(pageFormat.getImageableWidth());
                this.height = FilmBoxSheet.paper2mm(pageFormat.getImageableHeight());
                this.setGraphics((Graphics2D)graphics, 2);
                double d = 72.0 / (double)this.resolution;
                ((Graphics2D)graphics).scale(d, d);
                this.renderFilmBoxImpl(this.fbs.getFilmBox());
                this.painted = true;
            }
            this.painted = false;
            return 0;
        }
        return 1;
    }
}

