/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.service.event.TopicPermissionCollection;

public final class TopicPermission
extends Permission {
    static final long serialVersionUID = -5855563886961618300L;
    public static final String PUBLISH = "publish";
    public static final String SUBSCRIBE = "subscribe";
    private static final int ACTION_PUBLISH = 1;
    private static final int ACTION_SUBSCRIBE = 2;
    private static final int ACTION_ALL = 3;
    private static final int ACTION_NONE = 0;
    private transient int action_mask;
    private volatile transient String prefix;
    private volatile String actions = null;

    public TopicPermission(String string, String string2) {
        this(string, TopicPermission.parseActions(string2));
    }

    TopicPermission(String string, int n) {
        super(string);
        this.setTransients(n);
    }

    private synchronized void setTransients(int n) {
        String string = this.getName();
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("invalid name");
        }
        if (n == 0 || (n & 3) != n) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
        this.prefix = string.equals("*") ? "" : (string.endsWith("/*") ? string.substring(0, string.length() - 1) : null);
    }

    synchronized int getActionsMask() {
        return this.action_mask;
    }

    private static int parseActions(String string) {
        boolean bl = false;
        int n = 0;
        if (string == null) {
            return n;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        if (n2 < 0) {
            return n;
        }
        while (n2 != -1) {
            int n3;
            char c;
            while (n2 != -1 && ((c = cArray[n2]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n2;
            }
            if (!(n2 < 8 || cArray[n2 - 8] != 's' && cArray[n2 - 8] != 'S' || cArray[n2 - 7] != 'u' && cArray[n2 - 7] != 'U' || cArray[n2 - 6] != 'b' && cArray[n2 - 6] != 'B' || cArray[n2 - 5] != 's' && cArray[n2 - 5] != 'S' || cArray[n2 - 4] != 'c' && cArray[n2 - 4] != 'C' || cArray[n2 - 3] != 'r' && cArray[n2 - 3] != 'R' || cArray[n2 - 2] != 'i' && cArray[n2 - 2] != 'I' || cArray[n2 - 1] != 'b' && cArray[n2 - 1] != 'B' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 9;
                n |= 2;
            } else if (!(n2 < 6 || cArray[n2 - 6] != 'p' && cArray[n2 - 6] != 'P' || cArray[n2 - 5] != 'u' && cArray[n2 - 5] != 'U' || cArray[n2 - 4] != 'b' && cArray[n2 - 4] != 'B' || cArray[n2 - 3] != 'l' && cArray[n2 - 3] != 'L' || cArray[n2 - 2] != 'i' && cArray[n2 - 2] != 'I' || cArray[n2 - 1] != 's' && cArray[n2 - 1] != 'S' || cArray[n2] != 'h' && cArray[n2] != 'H')) {
                n3 = 7;
                n |= 1;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            bl = false;
            while (n2 >= n3 && !bl) {
                switch (cArray[n2 - n3]) {
                    case ',': {
                        bl = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n2;
            }
            n2 -= n3;
        }
        if (bl) {
            throw new IllegalArgumentException("invalid permission: " + string);
        }
        return n;
    }

    public boolean implies(Permission permission) {
        if (permission instanceof TopicPermission) {
            TopicPermission topicPermission = (TopicPermission)permission;
            int n = topicPermission.getActionsMask();
            if ((this.getActionsMask() & n) == n) {
                String string = topicPermission.getName();
                String string2 = this.prefix;
                if (string2 != null) {
                    return string.startsWith(string2);
                }
                return string.equals(this.getName());
            }
        }
        return false;
    }

    public String getActions() {
        String string = this.actions;
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n = this.getActionsMask();
            if ((n & 1) == 1) {
                stringBuffer.append(PUBLISH);
                bl = true;
            }
            if ((n & 2) == 2) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(SUBSCRIBE);
            }
            this.actions = string = ((Object)stringBuffer).toString();
        }
        return string;
    }

    public PermissionCollection newPermissionCollection() {
        return new TopicPermissionCollection();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TopicPermission)) {
            return false;
        }
        TopicPermission topicPermission = (TopicPermission)object;
        return this.getActionsMask() == topicPermission.getActionsMask() && this.getName().equals(topicPermission.getName());
    }

    public int hashCode() {
        int n = 527 + this.getName().hashCode();
        n = 31 * n + this.getActions().hashCode();
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setTransients(TopicPermission.parseActions(this.actions));
    }
}

