/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Filter;
import org.osgi.service.event.EventProperties;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event {
    private final String topic;
    private final EventProperties properties;

    public Event(String string, Map<String, ?> map) {
        Event.validateTopicName(string);
        this.topic = string;
        this.properties = map instanceof EventProperties ? (EventProperties)map : new EventProperties(map);
    }

    public Event(String string, Dictionary<String, ?> dictionary) {
        Event.validateTopicName(string);
        this.topic = string;
        this.properties = new EventProperties(dictionary);
    }

    public final Object getProperty(String string) {
        if ("event.topics".equals(string)) {
            return this.topic;
        }
        return this.properties.get(string);
    }

    public final boolean containsProperty(String string) {
        if ("event.topics".equals(string)) {
            return true;
        }
        return this.properties.containsKey(string);
    }

    public final String[] getPropertyNames() {
        int n = this.properties.size();
        String[] stringArray = new String[n + 1];
        this.properties.keySet().toArray(stringArray);
        stringArray[n] = "event.topics";
        return stringArray;
    }

    public final String getTopic() {
        return this.topic;
    }

    public final boolean matches(Filter filter) {
        return filter.matchCase((Dictionary)new FilterProperties(this.topic, this.properties));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Event)) {
            return false;
        }
        Event event = (Event)object;
        return this.topic.equals(event.topic) && this.properties.equals(event.properties);
    }

    public int hashCode() {
        int n = 527 + this.topic.hashCode();
        n = 31 * n + this.properties.hashCode();
        return n;
    }

    public String toString() {
        return ((Object)new StringBuffer().append(this.getClass().getName()).append(" [topic=").append(this.topic).append("]")).toString();
    }

    private static void validateTopicName(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (n == 0) {
            throw new IllegalArgumentException("empty topic");
        }
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c == '/') {
                if (i == 0 || i == n - 1) {
                    throw new IllegalArgumentException(((Object)new StringBuffer().append("invalid topic: ").append(string)).toString());
                }
                if (cArray[i - 1] != '/') continue;
                throw new IllegalArgumentException(((Object)new StringBuffer().append("invalid topic: ").append(string)).toString());
            }
            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '_' || c == '-') continue;
            throw new IllegalArgumentException(((Object)new StringBuffer().append("invalid topic: ").append(string)).toString());
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FilterProperties
    extends Dictionary<String, Object> {
        private final String topic;
        private final EventProperties properties;

        FilterProperties(String string, EventProperties eventProperties) {
            this.topic = string;
            this.properties = eventProperties;
        }

        @Override
        public Enumeration<Object> elements() {
            Collection<Object> collection = this.properties.values();
            ArrayList<Object> arrayList = new ArrayList<Object>(collection.size() + 1);
            arrayList.add(this.topic);
            arrayList.addAll(collection);
            return Collections.enumeration(arrayList);
        }

        @Override
        public Object get(Object object) {
            if ("event.topics".equals(object)) {
                return this.topic;
            }
            return this.properties.get(object);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Enumeration<String> keys() {
            Set<String> set = this.properties.keySet();
            ArrayList<String> arrayList = new ArrayList<String>(set.size() + 1);
            arrayList.add("event.topics");
            arrayList.addAll(set);
            return Collections.enumeration(arrayList);
        }

        @Override
        public Object put(String string, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.properties.size() + 1;
        }

        @Override
        public /* synthetic */ Object put(Object object, Object object2) {
            return this.put((String)object, object2);
        }
    }
}

