/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation.rendering;

import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.listtext.dicomobject.presentation.rendering.IRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.rendering.PresentationRenderContext;
import com.agfa.pacs.listtext.dicomobject.presentation.rendering.WindowablePresentationState;
import com.agfa.pacs.listtext.dicomobject.presentationstate.EmptyFramePresentationState;
import com.agfa.pacs.listtext.dicomobject.renderer.DicomObjectRendererFactory;
import com.agfa.pacs.listtext.dicomobject.renderer.IDicomObjectRenderer;
import com.agfa.pacs.logging.ALogger;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.dcm4che3.data.Attributes;

public class ImageRenderer
implements IRenderer {
    private static final ALogger log = ALogger.getLogger(ImageRenderer.class);
    private int maxDimension;
    private BufferedImage back;
    private Image front = null;
    private IDicomObjectRenderer dor;
    private PresentationRenderContext prc;
    private WindowablePresentationState myFPS;
    private Attributes dataset;

    public ImageRenderer(int n) {
        this.maxDimension = n;
    }

    public void prepareRendering(IObjectInfo iObjectInfo, Attributes attributes, IPixelDataFrame iPixelDataFrame, int n) {
        this.dataset = attributes;
        if (iObjectInfo != null && UIDUtilities.getBaseType((String)iObjectInfo.getSOPClassUID()) == UIDType.Image) {
            EmptyFramePresentationState emptyFramePresentationState = new EmptyFramePresentationState(iObjectInfo.getSOPInstanceUID(), this.dataset);
            this.dor = DicomObjectRendererFactory.getInstance().createDicomObjectRenderer(this.dataset, iPixelDataFrame, n, null);
            this.myFPS = new WindowablePresentationState(emptyFramePresentationState);
            this.dor.setPresentationState(this.myFPS);
            this.createRenderContext(iObjectInfo, n);
        }
    }

    public void updateRenderer(Attributes attributes) {
        if (this.dor != null) {
            this.myFPS.updateVOILUT(attributes);
            this.dor.setPresentationState(this.myFPS);
        }
    }

    @Override
    public void render() {
        if (this.dor != null) {
            this.dor.renderTo(this.prc);
            this.finishedRendering();
        } else {
            log.warn("No renderer");
        }
    }

    @Override
    public Image getRenderedImage() {
        if (this.front == null) {
            log.error("No image rendered");
        }
        return this.front;
    }

    protected void createRenderContext(IObjectInfo iObjectInfo, int n) {
        this.back = new BufferedImage(iObjectInfo.getAttributes().getInt(2621457, 512), iObjectInfo.getAttributes().getInt(2621456, 512), 1);
        this.prc = new PresentationRenderContext(this.back);
        this.prc.setApplyMapping(false, false);
        this.prc.setLUTsOnly(true);
    }

    protected void finishedRendering() {
        int n = this.back.getWidth();
        int n2 = this.back.getHeight();
        if (n > this.maxDimension || n2 > this.maxDimension) {
            float f = (float)n2 / (float)this.maxDimension;
            float f2 = (float)n / (float)this.maxDimension;
            if (f > f2) {
                f2 = f;
            }
            n = Math.round((float)n / f2);
            n2 = Math.round((float)n2 / f2);
            Image image = this.back.getScaledInstance(n, n2, 2);
            if (this.front == null) {
                this.front = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            }
            this.front.getGraphics().drawImage(image, 0, 0, null);
        } else {
            if (this.front == null) {
                this.front = new BufferedImage(this.back.getWidth(), this.back.getHeight(), this.back.getType());
            }
            this.front.getGraphics().drawImage(this.back, 0, 0, null);
        }
    }

    @Override
    public Attributes getDataset() {
        return this.dataset;
    }
}

