/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation.overlay;

public abstract class AbstractOverlayRenderer {
    protected int prevBit = 0;
    protected int count = 0;
    protected int x;
    protected int xpos;
    protected int ypos;

    public AbstractOverlayRenderer(int n, int n2) {
        this.x = n;
        this.xpos = n;
        this.ypos = n2;
    }

    public void fillBit(int n) {
        if ((n &= 1) == this.prevBit) {
            ++this.count;
        } else {
            this.renderLine();
            this.prevBit = n;
            this.count = 1;
        }
    }

    public void fillBits(int n, int n2) {
        if ((n &= 1) == this.prevBit) {
            this.count += n2;
        } else {
            this.renderLine();
            this.prevBit = n;
            this.count = n2;
        }
    }

    public void drawBits(int n, int n2) {
        int n3 = (1 << n2) - 1;
        int n4 = n & n3;
        if (n4 == 0 || n4 == n3) {
            this.fillBits(n, n2);
        } else {
            int n5 = 0;
            while (n5 < n2) {
                this.fillBit(n4);
                n4 >>= 1;
                ++n5;
            }
        }
    }

    public void draw8Bits(byte by) {
        int n = by & 0xFF;
        if (n == 0 || n == 255) {
            this.fillBits(by, 8);
        } else {
            int n2 = 0;
            while (n2 < 8) {
                this.fillBit(n);
                n >>= 1;
                ++n2;
            }
        }
    }

    public void drawLine(byte[] byArray, int n) {
        int n2 = n >> 3;
        int n3 = 0;
        while (n3 < n2) {
            this.draw8Bits(byArray[n3]);
            ++n3;
        }
        n3 = n & 7;
        if (n3 > 0) {
            this.drawBits(byArray[n2], n3);
        }
        this.nextLine();
    }

    public void drawLine(byte[] byArray, int n, int n2) {
        int n3 = n2 >> 3;
        int n4 = 0;
        while (n4 < n3) {
            this.draw8Bits(byArray[n + n4]);
            ++n4;
        }
        n4 = n2 & 7;
        if (n4 > 0) {
            this.drawBits(byArray[n + n3], n4);
        }
        this.nextLine();
    }

    public void nextLine() {
        this.renderLine();
        this.xpos = this.x;
        ++this.ypos;
        this.count = 0;
    }

    protected abstract void renderLine();
}

