/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation;

import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.listtext.dicomobject.module.ps.BitmapDisplayShutterModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.DisplayShutterModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.ShutterShape;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayDataFactory;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.OverlayFrame;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.StringOverlayData;
import com.agfa.pacs.logging.ALogger;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.List;

public class DisplayShutter
extends OverlayFrame {
    private int presentationValue = 0;
    private static final ALogger log = ALogger.getLogger(DisplayShutter.class);

    public DisplayShutter(OverlayFrame overlayFrame, BitmapDisplayShutterModule bitmapDisplayShutterModule) {
        super(null, -1);
        this.setOverlayData(overlayFrame.getOrigX(), overlayFrame.getOrigY(), overlayFrame.getWidth(), overlayFrame.getHeight(), overlayFrame.getOverlayData());
        if (bitmapDisplayShutterModule.getShutterPresentationValue() != null) {
            this.presentationValue = bitmapDisplayShutterModule.getShutterPresentationValue();
        }
        overlayFrame.setShutter(true);
    }

    public DisplayShutter(int n, int n2, DisplayShutterModule displayShutterModule, IOverlayDataFactory iOverlayDataFactory) {
        super(null, -1);
        if (displayShutterModule.getShutterPresentationValue() != null) {
            this.presentationValue = displayShutterModule.getShutterPresentationValue();
        }
        byte[] byArray = DataCacheProviderFactory.getCache().allocBytes((long)n * (long)n2);
        Arrays.fill(byArray, (byte)1);
        List list = displayShutterModule.shutterShapes();
        for (ShutterShape shutterShape : list) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            switch (shutterShape) {
                case Circular: {
                    byte[] byArray2 = DataCacheProviderFactory.getCache().allocBytes((long)n * (long)n2);
                    Arrays.fill(byArray2, (byte)0);
                    int n8 = displayShutterModule.getRadiusOfCircularShutter();
                    int[] nArray = displayShutterModule.getCenterOfCircularShutter();
                    n7 = n8 * n8;
                    n6 = 0;
                    while (n6 < n8) {
                        n5 = n6 * n6;
                        n4 = (int)Math.round(Math.sqrt(n7 - n5));
                        int n9 = nArray[1] - n4;
                        int n10 = nArray[1] + n4 - 1;
                        int n11 = nArray[0] - n6 - 1;
                        int n12 = nArray[0] + n6 - 1;
                        if (n9 < 0) {
                            n9 = 0;
                        }
                        if (n10 > n - 1) {
                            n10 = n - 1;
                        }
                        if (n11 > 0) {
                            Arrays.fill(byArray2, n9 + n11 * n, n10 + n11 * n, (byte)1);
                        }
                        if (n12 < n2 - 1) {
                            Arrays.fill(byArray2, n9 + n12 * n, n10 + n12 * n, (byte)1);
                        }
                        ++n6;
                    }
                    n6 = 0;
                    while (n6 < byArray.length) {
                        byArray[n6] = (byte)(byArray[n6] & byArray2[n6]);
                        ++n6;
                    }
                    break;
                }
                case Rectangular: {
                    byte[] byArray3 = DataCacheProviderFactory.getCache().allocBytes((long)n * (long)n2);
                    Arrays.fill(byArray3, (byte)0);
                    int n13 = displayShutterModule.getShutterLeftVerticalEdge() - 1;
                    n3 = displayShutterModule.getShutterRightVerticalEdge() - 1;
                    n7 = displayShutterModule.getShutterUpperHorizontalEdge() - 1;
                    n6 = displayShutterModule.getShutterLowerHorizontalEdge() - 1;
                    if (n13 < 0) {
                        n13 = 0;
                    }
                    if (n3 > n - 1) {
                        n3 = n - 1;
                    }
                    if (n7 < 0) {
                        n7 = 0;
                    }
                    if (n6 > n2 - 1) {
                        n6 = n2 - 1;
                    }
                    n5 = n7;
                    while (n5 <= n6) {
                        n4 = n5 * n;
                        Arrays.fill(byArray3, n4 + Math.min(n13, n3), n4 + Math.max(n13, n3), (byte)1);
                        ++n5;
                    }
                    n5 = 0;
                    while (n5 < byArray.length) {
                        byArray[n5] = (byte)(byArray[n5] & byArray3[n5]);
                        ++n5;
                    }
                    break;
                }
            }
            int n14 = 0;
            byte[] byArray4 = DataCacheProviderFactory.getCache().allocBytes((long)(n * n2 + 7 >> 3));
            n3 = n * n2 % 8;
            if (n3 == 0) {
                n3 = 8;
            }
            n7 = 0;
            n6 = 0;
            n5 = 0;
            while (n5 < byArray4.length - 1) {
                n4 = 0;
                while (n4 <= 7) {
                    n7 = (byte)(1 - byArray[n14 + n4]);
                    n6 = (byte)(n6 << 1 | n7 & 1);
                    ++n4;
                }
                n14 += 8;
                byArray4[n5] = n6;
                ++n5;
            }
            n5 = 0;
            while (n5 <= n3 - 1) {
                if (n14 + n5 >= byArray.length) {
                    log.error("Potential out of bounds exception. Length of array is " + byArray.length + ", index is " + (n14 + n5));
                    n6 = 0;
                    break;
                }
                n7 = (byte)(1 - byArray[n14 + n5]);
                n6 = (byte)(n6 << 1 | n7 & 1);
                ++n5;
            }
            if (n3 != 8) {
                n6 = (byte)(n6 << 8 - n3);
            }
            byArray4[byArray4.length - 1] = n6;
            byArray4[byArray4.length - 1] = (byte)(byArray4[byArray4.length - 1] << (8 - n * n2 % 8) % 8);
            this.setOverlayData(0, 0, n, n2, new StringOverlayData(byArray4, n, n2));
        }
    }

    @Override
    public void renderTo(Graphics graphics) {
        int n = this.presentationValue >> 8 & 0xFF;
        graphics.setColor(new Color(n, n, n));
        this.overlayData.renderTo(this.origX, this.origY, graphics);
    }
}

