/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.login;

import java.io.PrintStream;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class Log4jSystemOutRedirector
extends PrintStream {
    private Logger delegate;
    private Priority priority;
    private StringBuffer buffer = new StringBuffer();

    public Log4jSystemOutRedirector(String string, Priority priority) {
        super(System.out);
        this.delegate = Logger.getLogger((String)string);
        this.priority = priority;
    }

    @Override
    public void flush() {
        this.flushBuffer();
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public void print(boolean bl) {
        this.appendToBuffer(Boolean.toString(bl));
    }

    @Override
    public void print(char c) {
        this.appendToBuffer(c);
    }

    @Override
    public void print(char[] cArray) {
        this.appendToBuffer(cArray);
    }

    @Override
    public void print(double d) {
        this.appendToBuffer(Double.toString(d));
    }

    @Override
    public void print(float f) {
        this.appendToBuffer(Float.toString(f));
    }

    @Override
    public void print(int n) {
        this.write(n);
    }

    @Override
    public void print(long l) {
        this.appendToBuffer(Long.toString(l));
    }

    @Override
    public void print(Object object) {
        this.appendToBuffer("" + object);
    }

    @Override
    public void print(String string) {
        this.appendToBuffer(string);
    }

    @Override
    public void println() {
        this.flushBuffer();
    }

    @Override
    public void println(boolean bl) {
        this.printLoggerLine(Boolean.toString(bl));
    }

    @Override
    public void println(char c) {
        this.printLoggerLine(new String(Character.toChars(c)));
    }

    @Override
    public void println(char[] cArray) {
        this.printLoggerLine(new String(cArray));
    }

    @Override
    public void println(double d) {
        this.printLoggerLine(Double.toString(d));
    }

    @Override
    public void println(float f) {
        this.printLoggerLine(Float.toString(f));
    }

    @Override
    public void println(int n) {
        this.printLoggerLine(Integer.toString(n));
    }

    @Override
    public void println(long l) {
        this.printLoggerLine(Long.toString(l));
    }

    @Override
    public void println(Object object) {
        this.printLoggerLine("" + object);
    }

    @Override
    public void println(String string) {
        this.printLoggerLine(string);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.appendToBuffer(new String(byArray, n, n2));
    }

    @Override
    public void write(int n) {
        this.appendToBuffer(Character.toChars(n));
    }

    private synchronized void printLoggerLine(String string) {
        if (this.buffer.length() > 0) {
            this.appendToBuffer(string);
            this.flushBuffer();
        } else {
            this.delegate.log(this.priority, (Object)string);
        }
    }

    private synchronized void appendToBuffer(char c) {
        if (c == '\r' || c == '\n') {
            this.flushBuffer();
        } else {
            this.buffer.append(c);
        }
    }

    private void appendToBuffer(String string) {
        int n = 0;
        while (n < string.length()) {
            this.appendToBuffer(string.charAt(n));
            ++n;
        }
    }

    private void appendToBuffer(char[] cArray) {
        char[] cArray2 = cArray;
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray2[n2];
            this.appendToBuffer(c);
            ++n2;
        }
    }

    private void flushBuffer() {
        if (this.buffer.length() > 0) {
            String string = this.buffer.toString();
            this.buffer.setLength(0);
            this.printLoggerLine(string);
        }
    }
}

