/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.valuemapping;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.valuemapping.DecayCorrectionMethod;
import com.agfa.pacs.data.shared.valuemapping.IIsotope;
import com.agfa.pacs.data.shared.valuemapping.ISUVData;
import com.agfa.pacs.data.shared.valuemapping.ISUVStudyData;
import com.agfa.pacs.data.shared.valuemapping.IStandardizedUptakeValueMethod;
import com.agfa.pacs.data.shared.valuemapping.NamedIsotope;
import com.agfa.pacs.data.shared.valuemapping.PatientSex;
import com.agfa.pacs.data.shared.valuemapping.SUVIsotope;
import com.agfa.pacs.data.shared.valuemapping.SUVStudyData;
import com.agfa.pacs.tools.DateUtilities;
import java.util.Calendar;
import java.util.Date;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class SUVData
implements ISUVData {
    public static final double MEGABECQUEREL = 1000000.0;
    static final double MILLISECONDS_PER_SECOND = 1000.0;
    private final ISUVStudyData suvStudyData;
    private final IIsotope isotopeFromData;
    private IIsotope isotope;
    private Double injectedDose;
    private Date injectionTime;
    private final Date baseDateTimeOverride;
    private final DecayCorrectionMethod decayCorrectionMethod;

    public SUVData(Attributes attributes, IStandardizedUptakeValueMethod iStandardizedUptakeValueMethod) {
        this(attributes, null, new SUVStudyData(attributes, iStandardizedUptakeValueMethod));
    }

    public SUVData(Attributes attributes, Date date, ISUVStudyData iSUVStudyData) {
        this.suvStudyData = iSUVStudyData;
        Attributes attributes2 = SUVData.extractInjectionData(attributes);
        Double d = SUVData.getDouble(attributes2, 1577077);
        if (d == null) {
            this.isotopeFromData = null;
            this.isotope = NamedIsotope.getIsotopeByCode(Code.create(attributes2, 5505796), Code.create(attributes2, 5505792));
        } else {
            this.isotope = this.isotopeFromData = SUVIsotope.createIsotopeFromData(d);
        }
        this.injectedDose = SUVData.getDouble(attributes2, 1577076);
        if (this.injectedDose != null && this.injectedDose < 1000000.0) {
            this.injectedDose = this.injectedDose * 1000000.0;
        }
        this.injectionTime = SUVData.getInjectionTime(attributes2, attributes.getDate(524322), attributes.getDate(524338));
        this.baseDateTimeOverride = date;
        this.decayCorrectionMethod = DecayCorrectionMethod.create(attributes);
    }

    static Double getDouble(Attributes attributes, int n) {
        if (attributes.contains(n)) {
            return attributes.getDouble(n, 0.0);
        }
        return null;
    }

    private static Attributes extractInjectionData(Attributes attributes) {
        Sequence sequence = attributes.getSequence(5505046);
        if (sequence == null || sequence.size() <= 0) {
            return new Attributes();
        }
        return (Attributes)sequence.get(0);
    }

    private static Date getInjectionTime(Attributes attributes, Date date, Date date2) {
        Date date3;
        if (attributes.containsValue(1577080)) {
            date3 = attributes.getDate(1577080);
        } else if (attributes.containsValue(1577074)) {
            date3 = DateUtilities.createDateTime((Date)date, (Date)attributes.getDate(1577074));
            if (date3 != null && date != null && date2 != null && date3.after(DateUtilities.createDateTime((Date)date, (Date)date2))) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date3);
                calendar.add(5, -1);
                date3 = calendar.getTime();
            }
        } else {
            date3 = null;
        }
        return date3;
    }

    @Override
    public boolean needsData() {
        return this.suvStudyData.needsData() || SUVData.isInvalid(this.isotope.getHalfLife()) || SUVData.isInvalid(this.injectedDose) || this.injectionTime == null;
    }

    public static boolean isInvalid(Double d) {
        return d == null || d == 0.0;
    }

    @Override
    public IStandardizedUptakeValueMethod getMethod() {
        return this.suvStudyData.getMethod();
    }

    @Override
    public void setMethod(IStandardizedUptakeValueMethod iStandardizedUptakeValueMethod) throws IllegalArgumentException {
        this.suvStudyData.setMethod(iStandardizedUptakeValueMethod);
    }

    @Override
    public PatientSex getPatientSex() {
        return this.suvStudyData.getPatientSex();
    }

    @Override
    public void setPatientSex(PatientSex patientSex) {
        this.suvStudyData.setPatientSex(patientSex);
    }

    @Override
    public Double getPatientWeight() {
        return this.suvStudyData.getPatientWeight();
    }

    @Override
    public void setPatientWeight(Double d) {
        this.suvStudyData.setPatientWeight(d);
    }

    @Override
    public Double getPatientHeight() {
        return this.suvStudyData.getPatientHeight();
    }

    @Override
    public void setPatientHeight(Double d) {
        this.suvStudyData.setPatientHeight(d);
    }

    @Override
    public IIsotope getIsotopeFromData() {
        return this.isotopeFromData;
    }

    @Override
    public IIsotope getIsotope() {
        return this.isotope;
    }

    @Override
    public void setIsotope(IIsotope iIsotope) {
        this.isotope = iIsotope == null ? SUVIsotope.CUSTOM : iIsotope;
    }

    @Override
    public Double getInjectedDose() {
        return this.injectedDose;
    }

    @Override
    public void setInjectedDose(Double d) {
        this.injectedDose = d;
    }

    @Override
    public Date getInjectionTime() {
        return this.injectionTime;
    }

    @Override
    public Double getAcquisitionDelay(Attributes attributes) {
        return this.decayCorrectionMethod.getAcquisitionDelay(attributes, this);
    }

    @Override
    public void setAcquisitionDelay(Date date, Double d) {
        this.injectionTime = SUVData.calculateInjectionTime(date, d);
    }

    Date getBaseDateTimeOverride() {
        return this.baseDateTimeOverride;
    }

    public static Double calculateAcquisitionDelay(Date date, Date date2) {
        if (date == null || date2 == null) {
            return null;
        }
        return (double)(date.getTime() - date2.getTime()) / 1000.0;
    }

    public static Date calculateInjectionTime(Date date, Double d) {
        Date date2 = date == null || d == null ? null : new Date(date.getTime() - (long)(d * 1000.0));
        return date2;
    }
}

