/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.valuemapping;

import com.agfa.pacs.data.shared.Messages;
import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.valuemapping.IIsotope;
import com.agfa.pacs.data.shared.valuemapping.SUVIsotope;
import java.util.HashMap;
import java.util.Map;

public enum NamedIsotope implements IIsotope
{
    FLUORINE18(6588.0),
    OXYGEN15(121.8),
    CARBON11(1224.0),
    NITROGEN13(598.8),
    RUBIDIUM82(75.0);

    private static final Map<Code, NamedIsotope> isotopesByCode;
    private final double halfLife;

    static {
        isotopesByCode = new HashMap<Code, NamedIsotope>();
        String string = "SRT";
        isotopesByCode.put(new Code(string, "C-105A1", "^11^Carbon"), CARBON11);
        isotopesByCode.put(new Code(string, "C-107A1", "^13^Nitrogen"), NITROGEN13);
        isotopesByCode.put(new Code(string, "C-111A1", "^18^Fluorine"), FLUORINE18);
        isotopesByCode.put(new Code(string, "C-159A2", "^82^Rubidium"), RUBIDIUM82);
        isotopesByCode.put(new Code(string, "C-B07DC", "Butanol O^15^"), OXYGEN15);
        isotopesByCode.put(new Code(string, "C-B07DE", "Flumazenil C^11^"), CARBON11);
        isotopesByCode.put(new Code(string, "C-B07DF", "Flumazenil F^18^"), FLUORINE18);
        isotopesByCode.put(new Code(string, "C-B07E0", "Fluorethyltyrosin F^18^"), FLUORINE18);
        isotopesByCode.put(new Code(string, "C-B07E1", "Fluoromisonidazole F^18^"), FLUORINE18);
        isotopesByCode.put(new Code(string, "C-B07E2", "Fluoromethane F^18^"), FLUORINE18);
        isotopesByCode.put(new Code(string, "C-B07E3", "Fluorouracil F^18^"), FLUORINE18);
        isotopesByCode.put(new Code(string, "C-B07E4", "Fluorobenzothiazole F^18^"), FLUORINE18);
        isotopesByCode.put(new Code(string, "C-B07E5", "Mespiperone C^11^"), CARBON11);
        isotopesByCode.put(new Code(string, "C-B1031", "Fluorodeoxyglucose F^18^"), FLUORINE18);
        isotopesByCode.put(new Code(string, "C-B1031", "Fluorodeoxyglucose F^18^"), FLUORINE18);
        isotopesByCode.put(new Code(string, "C-B1032", "Sodium fluoride F^18^"), FLUORINE18);
        isotopesByCode.put(new Code(string, "C-B1033", "Spiperone F^18^"), FLUORINE18);
        isotopesByCode.put(new Code(string, "C-B1034", "Fluoro-L-dopa F^18^"), FLUORINE18);
        isotopesByCode.put(new Code(string, "C-B1036", "Thymidine (FLT)F^18^"), FLUORINE18);
        isotopesByCode.put(new Code(string, "C-B1037", "Rubidium chloride Rb^82^"), RUBIDIUM82);
        isotopesByCode.put(new Code(string, "C-B1038", "Oxygen O^15^"), OXYGEN15);
        isotopesByCode.put(new Code(string, "C-B1039", "Oxygen-water O^15^"), OXYGEN15);
        isotopesByCode.put(new Code(string, "C-B103A", "Carbon monoxide O^15^"), OXYGEN15);
        isotopesByCode.put(new Code(string, "C-B103B", "Carbon dioxide O^15^"), OXYGEN15);
        isotopesByCode.put(new Code(string, "C-B103C", "Ammonia N^13^"), NITROGEN13);
        isotopesByCode.put(new Code(string, "C-B103D", "Glutamate N^13^"), NITROGEN13);
        isotopesByCode.put(new Code(string, "C-B103E", "Methionine C^11^"), CARBON11);
        isotopesByCode.put(new Code(string, "C-B103F", "Carfentanil C^11^"), CARBON11);
        isotopesByCode.put(new Code(string, "C-B1042", "Raclopride C^11^"), CARBON11);
        isotopesByCode.put(new Code(string, "C-B1043", "Acetate C^11^"), CARBON11);
        isotopesByCode.put(new Code(string, "C-B1044", "Palmitate C^11^"), CARBON11);
        isotopesByCode.put(new Code(string, "C-B1045", "Carbon monoxide C^11^"), CARBON11);
    }

    private NamedIsotope(double d) {
        this.halfLife = d;
    }

    public static IIsotope getIsotopeByCode(Code ... codeArray) {
        Code[] codeArray2 = codeArray;
        int n = codeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIsotope iIsotope;
            Code code = codeArray2[n2];
            if (code != null && (iIsotope = (IIsotope)isotopesByCode.get(code)) != null) {
                return iIsotope;
            }
            ++n2;
        }
        return SUVIsotope.CUSTOM;
    }

    @Override
    public Double getHalfLife() {
        return this.halfLife;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    public String toString() {
        return Messages.getString("SUV.Isotope." + this.name() + ".Label");
    }
}

