/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.util;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.Arrays;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class OverlayUtils {
    private static final ALogger LOGGER = ALogger.getLogger(OverlayUtils.class);
    public static final String AGILITY_OVERLAY_BIT_PLANE_PRIVATE_CREATOR = "AgilityOverlayBitPlane";
    public static final int AGILITY_OVERLAY_BIT_PLANE_BASE_TAG = 0x60010000;
    private static final IDataCacheProvider cache = DataCacheProviderFactory.getCache();

    public static void extractBitmapOverlays(Attributes attributes) {
        OverlayUtils.extractBitmapOverlays(attributes, true, false, false);
    }

    public static void extractBitmapOverlays(Attributes attributes, boolean bl) {
        OverlayUtils.extractBitmapOverlays(attributes, bl, false, false);
    }

    public static void extractBitmapOverlaysFromSeries(Attributes attributes) {
        OverlayUtils.extractBitmapOverlays(attributes, true, true, false);
    }

    public static void extractBitmapOverlaysIfNotYetDone(Attributes attributes) {
        OverlayUtils.extractBitmapOverlays(attributes, true, false, true);
    }

    private static void extractBitmapOverlays(Attributes attributes, boolean bl, boolean bl2, boolean bl3) {
        int n = 0;
        while (n < 16) {
            block11: {
                int n2;
                int n3;
                block12: {
                    CacheID cacheID;
                    byte[] byArray;
                    n3 = n * 2 << 16;
                    n2 = 0x60003000 + n3;
                    if (!attributes.contains(n2)) break block11;
                    try {
                        byArray = attributes.getBytes(n2);
                    }
                    catch (IOException iOException) {
                        LOGGER.error("Bulk data error", (Throwable)iOException);
                        return;
                    }
                    if (byArray == null) break block11;
                    if (!bl) break block12;
                    CacheID cacheID2 = OverlayUtils.getOverlayCacheID(attributes, n3, bl2);
                    if (byArray.length == 0) break block11;
                    boolean bl4 = false;
                    if (bl3) {
                        cacheID = OverlayUtils.getOverlayCacheID(attributes, n3, true);
                        CacheID cacheID3 = OverlayUtils.getOverlayCacheID(attributes, n3, false);
                        if (cache.exists(byte[].class, cacheID) || cache.exists(byte[].class, cacheID3)) {
                            bl4 = true;
                        }
                    }
                    if (!bl4) {
                        cacheID = attributes.getVR(n2);
                        if (cacheID == VR.OW && attributes.bigEndian()) {
                            byArray = OverlayUtils.changeByteOrderToLittleEndian(byArray);
                        }
                        cache.addPersistentBytes(byArray, cacheID2);
                        byArray = null;
                    }
                }
                attributes.setNull(n2, VR.OB);
                if (bl2) {
                    attributes.setInt(AGILITY_OVERLAY_BIT_PLANE_PRIVATE_CREATOR, 0x60010000 | n3 >> 16, VR.US, new int[]{1});
                }
            }
            ++n;
        }
    }

    public static byte[] changeByteOrderToLittleEndian(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        short s = 0;
        int n = 0;
        while (n < byArray.length) {
            if (n % 2 != 0) {
                s = (short)(s | byArray[n]);
                shortBuffer.put(s);
            } else {
                s = (short)(byArray[n] << 8);
            }
            ++n;
        }
        byte[] byArray2 = byteBuffer.array();
        return byArray2;
    }

    public static CacheID getOverlayCacheID(String string, String string2, int n) {
        return cache.createID(string, String.valueOf(string2) + "o" + n, 1);
    }

    private static CacheID getOverlayCacheID(Attributes attributes, int n, boolean bl) {
        String string = bl ? attributes.getString(0x20000E) : attributes.getString(524312);
        String string2 = attributes.getString(0x20000D);
        if (string2 == null) {
            throw new IllegalArgumentException("Study Instance UID must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("UID must not be null");
        }
        return OverlayUtils.getOverlayCacheID(string2, string, n);
    }

    public static boolean containsBitmapOverlays(Attributes attributes) {
        int n = 0;
        while (n < 16) {
            int n2 = n * 2 << 16;
            if (attributes.getInt(1610612994 + n2, -1) == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void addCachedOverlayData(Attributes attributes) {
        int n = 0;
        while (n < 16) {
            int n2;
            int n3 = n * 2 << 16;
            if (attributes.contains(0x60000040 + n3) && !attributes.containsValue(0x60003000 + n3) && (n2 = attributes.getInt(1610612994 + n3, 0)) == 0) {
                CacheID cacheID = OverlayUtils.getOverlayCacheID(attributes, n3, false);
                byte[] byArray = null;
                if (cache.exists(byte[].class, cacheID)) {
                    byArray = cache.referencePersistentBytes(cacheID);
                } else {
                    cacheID = OverlayUtils.getOverlayCacheID(attributes, n3, true);
                    if (cache.exists(byte[].class, cacheID)) {
                        byArray = cache.referencePersistentBytes(cacheID);
                    }
                }
                if (byArray != null) {
                    try {
                        attributes.setBytes(0x60003000 + n3, VR.OB, Arrays.copyOf(byArray, byArray.length));
                        byArray = null;
                    }
                    finally {
                        cache.releaseReference(cacheID);
                    }
                } else {
                    LOGGER.error("Overlay bitplane '{}' for '{} / {} / {}' not found in cache.", new Object[]{n3, attributes.getString(0x20000D, null), attributes.getString(0x20000E, null), attributes.getString(524312, null)});
                }
            }
            ++n;
        }
    }
}

