/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.node;

import com.agfa.pacs.data.shared.filter.FilterLevel;
import com.agfa.pacs.data.shared.filter.FilterTag;
import com.agfa.pacs.data.shared.lw.IDataProviderIdentifier;
import com.agfa.pacs.data.shared.node.AbstractDataInfoNode;
import com.agfa.pacs.data.shared.node.IDataNodeErrorCounter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractLocalDataInfoNode
extends AbstractDataInfoNode
implements IDataNodeErrorCounter {
    protected volatile boolean cancel;
    protected IDataProviderIdentifier dni;
    protected AtomicInteger numberOfDamagedFiles = new AtomicInteger(0);
    private static final int[] PATIENT_RESULT_TAGS = new int[]{0x100010, 0x100020, 0x100021, 0x100040, 0x100030, 0x201200, 0x201202, 2101764};
    private static final int[] STUDY_RESULT_TAGS = new int[]{524320, 524336, 524368, 0x200010, 524385, 524432, 528432, 2101766, 2101768};
    private static final int[] SERIES_RESULT_TAGS = new int[]{524384, 0x200011, 2101769};
    private static final int[] IMAGE_RESULT_TAGS = new int[]{2097171, 2621456, 2621457, 2621696, 0x280008, 0x700080, 7340161, 7340162, 7340163, 4236433, 4236435, 524323, 524339, 4235314};

    public AbstractLocalDataInfoNode(IDataProviderIdentifier iDataProviderIdentifier) {
        super(iDataProviderIdentifier.getName());
        this.dni = iDataProviderIdentifier;
    }

    @Override
    public String getSourceAET() {
        return null;
    }

    @Override
    public IDataProviderIdentifier getIdentifier() {
        return this.dni;
    }

    @Override
    public List<FilterTag> getSearchTags() {
        return null;
    }

    @Override
    public void cancelQuery() {
        this.cancel = true;
    }

    @Override
    public List<FilterTag> getResultTags() {
        return LazyHolderResultTags.RESULT_FILTER_TAGS;
    }

    private static void createFilterTags(List<FilterTag> list, int[] nArray, FilterLevel filterLevel) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            list.add(FilterTag.createDicomFilterTag(n3, filterLevel));
            ++n2;
        }
    }

    @Override
    public void resetErrorCounter() {
        this.numberOfDamagedFiles.set(0);
    }

    @Override
    public void incrementErrorCounter() {
        this.numberOfDamagedFiles.incrementAndGet();
    }

    @Override
    public int getNumberOfDamagedFiles() {
        return this.numberOfDamagedFiles.get();
    }

    private static class LazyHolderResultTags {
        private static final List<FilterTag> RESULT_FILTER_TAGS = LazyHolderResultTags.createResultTags();

        private LazyHolderResultTags() {
        }

        private static List<FilterTag> createResultTags() {
            ArrayList<FilterTag> arrayList = new ArrayList<FilterTag>();
            AbstractLocalDataInfoNode.createFilterTags(arrayList, PATIENT_RESULT_TAGS, FilterLevel.Patient);
            AbstractLocalDataInfoNode.createFilterTags(arrayList, STUDY_RESULT_TAGS, FilterLevel.Study);
            AbstractLocalDataInfoNode.createFilterTags(arrayList, SERIES_RESULT_TAGS, FilterLevel.Series);
            AbstractLocalDataInfoNode.createFilterTags(arrayList, IMAGE_RESULT_TAGS, FilterLevel.Image);
            return arrayList;
        }
    }
}

