/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.node;

import com.agfa.pacs.data.shared.icon.IIconProvider;
import com.agfa.pacs.data.shared.icon.impl.DefaultIconProvider;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public abstract class AbstractDataInfoNode
implements IDataInfoNode {
    private String name;
    private int orderId;
    private boolean userSearchable = true;
    private boolean servicesSearchable = true;
    protected Map<String, Attributes> studyDefaults;
    protected IIconProvider iconProvider;

    public AbstractDataInfoNode(String string) {
        this.name = string;
        this.orderId = Integer.MAX_VALUE;
        this.iconProvider = new DefaultIconProvider();
    }

    @Override
    public IDataInfoNode getInstance() {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getOrderId() {
        return this.orderId;
    }

    @Override
    public boolean isUserSearchable() {
        return this.userSearchable;
    }

    @Override
    public void setUserSearchable(boolean bl) {
        this.userSearchable = bl;
    }

    @Override
    public boolean isServicesSearchable() {
        return this.servicesSearchable;
    }

    @Override
    public void setServicesSearchable(boolean bl) {
        this.servicesSearchable = bl;
    }

    @Override
    public void setOrderId(int n) {
        this.orderId = n;
    }

    @Override
    public abstract String getType();

    public String toString() {
        if (this.name == null) {
            return super.toString();
        }
        return this.name;
    }

    @Override
    public IIconProvider getIconProvider() {
        return this.iconProvider;
    }

    public boolean supportORQueries() {
        return false;
    }

    public boolean supportsORMatches() {
        return false;
    }

    @Override
    public boolean waitForFullHeader() {
        return true;
    }

    @Override
    public void addURL(URL uRL) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStudyDefaults(Attributes attributes) {
        if (attributes == null) {
            return;
        }
        if (this.studyDefaults == null) {
            this.studyDefaults = new HashMap<String, Attributes>();
        }
        String string = attributes.getString(0x20000D);
        attributes.remove(0x20000D);
        if (string == null) {
            throw new IllegalArgumentException("missing study uid in defaults");
        }
        this.studyDefaults.put(string, attributes);
    }

    protected void applyStudyDefaults(List<IStudyInfo> list) {
        if (this.studyDefaults == null) {
            return;
        }
        for (IStudyInfo iStudyInfo : list) {
            String string = iStudyInfo.getStudyUID();
            Attributes attributes = this.studyDefaults.get(string);
            if (attributes == null) continue;
            iStudyInfo.getAttributes().addAll(attributes);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void updateCountFields(IDataInfo iDataInfo) {
        Attributes attributes = iDataInfo.getAttributes();
        if (iDataInfo instanceof ISeriesInfo && !attributes.containsValue(2101769)) {
            attributes.setInt(2101769, VR.IS, new int[]{iDataInfo.children().size()});
        }
        if (iDataInfo instanceof IStudyInfo) {
            void iDataInfo2;
            boolean n = false;
            for (IDataInfo iDataInfo3 : iDataInfo.children()) {
                AbstractDataInfoNode.updateCountFields(iDataInfo3);
                iDataInfo2 += iDataInfo3.getAttributes().getInt(2101769, 0);
            }
            attributes.setInt(2101766, VR.IS, new int[]{iDataInfo.children().size()});
            attributes.setInt(2101768, VR.IS, new int[]{iDataInfo2});
        }
        if (iDataInfo instanceof IPatientInfo) {
            void var2_5;
            void var3_12;
            boolean bl = false;
            boolean bl2 = false;
            for (IDataInfo iDataInfo4 : iDataInfo.children()) {
                AbstractDataInfoNode.updateCountFields(iDataInfo4);
                Attributes attributes2 = iDataInfo4.getAttributes();
                var2_5 += attributes2.getInt(2101768, 0);
                var3_12 += attributes2.getInt(2101766, 0);
            }
            attributes.setInt(0x201200, VR.IS, new int[]{iDataInfo.children().size()});
            attributes.setInt(0x201202, VR.IS, new int[]{var3_12});
            attributes.setInt(2101764, VR.IS, new int[]{var2_5});
        }
        if (iDataInfo instanceof IRootInfo) {
            for (IDataInfo iDataInfo5 : iDataInfo.children()) {
                AbstractDataInfoNode.updateCountFields(iDataInfo5);
            }
        }
    }
}

