/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.instanceinfo.impl;

import com.agfa.pacs.data.shared.instanceinfo.AbstractInstanceInfo;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class URLInstanceInfo
extends AbstractInstanceInfo {
    public static final String TYPE = "URL";
    protected String url;
    protected SoftReference<URL> urlReference = new SoftReference<Object>(null);
    protected String transferSyntaxUID;

    public URLInstanceInfo() {
    }

    public URLInstanceInfo(String string) {
        this.setURL(string);
    }

    public URLInstanceInfo(URL uRL) {
        this.setURL(uRL);
    }

    public URLInstanceInfo(URL uRL, String string) {
        this(uRL);
        this.transferSyntaxUID = string;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    private void setURL(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("url == null");
        }
        this.url = uRL.toString();
        this.urlReference = new SoftReference<URL>(uRL);
    }

    protected void setURL(String string) {
        try {
            this.setURL(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("malformed url", malformedURLException);
        }
    }

    public URL getURL() {
        URL uRL = this.urlReference.get();
        if (uRL == null) {
            try {
                uRL = new URL(this.url);
                this.urlReference = new SoftReference<URL>(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalStateException("url must not be invalid");
            }
        }
        return uRL;
    }

    public String getTransferSyntaxUID() {
        return this.transferSyntaxUID;
    }

    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="url can be null if default constructor is used")
    public String toString() {
        return String.valueOf(super.toString()) + " " + this.url != null ? this.url : "";
    }

    @Override
    public void readFrom(Attributes attributes) {
        super.readFrom(attributes);
        this.setURL(attributes.getString("AGFA-AG_InstanceInfo", 4390944));
    }

    @Override
    public void writeTo(Attributes attributes) {
        super.writeTo(attributes);
        attributes.setString("AGFA-AG_InstanceInfo", 4390944, VR.ST, this.url.toString());
    }

    @Override
    public String getURIString() {
        return this.url;
    }
}

