/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.icon;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.data.shared.icon.IIconInfo;
import java.util.Map;

public abstract class DefaultIconFactory {
    private static DefaultIconFactory implementation;

    public static synchronized DefaultIconFactory getInstance() {
        if (implementation == null) {
            DefaultIconFactory.initialize();
        }
        return implementation;
    }

    public IIconInfo getDefaultIcon(String string) {
        return implementation.getDefaultIconsInt().get(string);
    }

    protected abstract Map<String, IIconInfo> getDefaultIconsInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)DefaultIconFactory.class.getName()));
            implementation = (DefaultIconFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + DefaultIconFactory.class.getName(), reflectiveOperationException);
        }
    }
}

