/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.hw;

import com.agfa.pacs.data.shared.data.DicomDataListenerAdapter;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.IDicomDataListenerContainer;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dcm4che3.data.Attributes;

public class DicomDataListenerManager
implements IDicomDataListenerContainer {
    private static final DicomDataListenerManager instance = new DicomDataListenerManager();
    private ConcurrentHashMap<String, Object> listenerMap = new ConcurrentHashMap();
    private List<IDicomDataListener> allListeners = new CopyOnWriteArrayList<IDicomDataListener>();

    public static DicomDataListenerManager getInstance() {
        return instance;
    }

    @Override
    public void addListener(String string, IDicomDataListener iDicomDataListener) {
        if (iDicomDataListener == null) {
            return;
        }
        if (this.listenerMap.containsKey(string)) {
            Object object = this.listenerMap.get(string);
            if (object instanceof List) {
                List list = (List)object;
                if (!list.contains(iDicomDataListener)) {
                    list.add(iDicomDataListener);
                }
            } else {
                LinkedList<IDicomDataListener> linkedList = new LinkedList<IDicomDataListener>();
                linkedList.add((IDicomDataListener)object);
                linkedList.add(iDicomDataListener);
                this.listenerMap.replace(string, linkedList);
            }
        } else {
            this.listenerMap.put(string, iDicomDataListener);
        }
    }

    @Override
    public void addGlobalListener(IDicomDataListener iDicomDataListener) {
        if (iDicomDataListener != null) {
            this.allListeners.add(iDicomDataListener);
        }
    }

    @Override
    public void removeGlobalListener(IDicomDataListener iDicomDataListener) {
        if (iDicomDataListener != null) {
            this.allListeners.remove(iDicomDataListener);
        }
    }

    @Override
    public boolean hasListenerFor(String string) {
        return this.listenerMap.containsKey(string);
    }

    @Override
    public IDicomDataListener getListener(String string) {
        Object object = this.listenerMap.remove(string);
        if (object == null) {
            if (!this.allListeners.isEmpty()) {
                return new DicomDataListenerMultiplexer(this.allListeners);
            }
            return new DicomDataListenerAdapter();
        }
        if (object instanceof IDicomDataListener) {
            return (IDicomDataListener)object;
        }
        List list = (List)object;
        return new DicomDataListenerMultiplexer(list);
    }

    private static class DicomDataListenerMultiplexer
    implements IDicomDataListener {
        private final Collection<IDicomDataListener> listeners;

        public DicomDataListenerMultiplexer(Collection<IDicomDataListener> collection) {
            this.listeners = collection;
        }

        @Override
        public void dicomDataAvailable(String string, Attributes attributes, boolean bl) {
            for (IDicomDataListener iDicomDataListener : this.listeners) {
                iDicomDataListener.dicomDataAvailable(string, attributes, bl);
            }
        }

        @Override
        public void dicomDataError(String string, String string2, Throwable throwable) {
            for (IDicomDataListener iDicomDataListener : this.listeners) {
                iDicomDataListener.dicomDataError(string, string2, throwable);
            }
        }

        @Override
        public void dicomDataFinished(String string, IDicomDataListener.Status status, Attributes attributes) {
            for (IDicomDataListener iDicomDataListener : this.listeners) {
                iDicomDataListener.dicomDataFinished(string, status, attributes);
            }
        }

        @Override
        public void pixelDataAvailable(String string, IPixelDataInfo iPixelDataInfo, int n) {
            for (IDicomDataListener iDicomDataListener : this.listeners) {
                iDicomDataListener.pixelDataAvailable(string, iPixelDataInfo, n);
            }
        }
    }
}

