/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.filter;

import com.agfa.pacs.data.shared.dicom.DicomEnum;
import com.agfa.pacs.data.shared.dicom.Level;

public enum FilterLevel implements DicomEnum
{
    Default("DEFAULT", -1),
    Patient("PATIENT", 0),
    Study("STUDY", 1),
    Series("SERIES", 2),
    Image("IMAGE", 3);

    private final String dicomId;
    private final int level;

    private FilterLevel(String string2, int n2) {
        this.dicomId = string2;
        this.level = n2;
    }

    @Override
    public String dicom() {
        return this.dicomId;
    }

    public int getIntLevel() {
        return this.level;
    }

    public static FilterLevel get(String string) {
        FilterLevel[] filterLevelArray = FilterLevel.values();
        int n = filterLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            FilterLevel filterLevel = filterLevelArray[n2];
            if (filterLevel.dicom().equals(string)) {
                return filterLevel;
            }
            ++n2;
        }
        return null;
    }

    public static FilterLevel get(int n) {
        FilterLevel[] filterLevelArray = FilterLevel.values();
        int n2 = filterLevelArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FilterLevel filterLevel = filterLevelArray[n3];
            if (filterLevel.getIntLevel() == n) {
                return filterLevel;
            }
            ++n3;
        }
        return null;
    }

    public static FilterLevel get(Level level) {
        if (Level.Patient.equals(level)) {
            return Patient;
        }
        if (Level.Study.equals(level)) {
            return Study;
        }
        if (Level.Series.equals(level)) {
            return Series;
        }
        if (Level.Object.equals(level)) {
            return Image;
        }
        return null;
    }
}

