/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.dicom;

import com.agfa.pacs.data.shared.dicom.UIDConfiguration;
import com.agfa.pacs.data.shared.dicom.UIDType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.dcm4che3.data.UID;

public class UIDUtilities {
    private static final UIDConfiguration uidMapConfig = UIDConfiguration.getInstance();

    public static UIDType getBaseType(String string) {
        return uidMapConfig.getBaseType(string);
    }

    public static Set<String> getDefaultTransferSyntaxUIDs() {
        return uidMapConfig.getDefaultTransferSyntaxUIDs();
    }

    public static Set<String> getImageTransferSyntaxUIDs() {
        return uidMapConfig.getImageTransferSyntaxUIDs();
    }

    public static Set<String> getVideoTransferSyntaxUIDs() {
        return uidMapConfig.getVideoTransferSyntaxUIDs();
    }

    public static List<String> getSOPClassUIDs() {
        return uidMapConfig.getSOPClassUIDs();
    }

    public static List<String> getSOPClassUIDs(UIDType uIDType) {
        List<String> list = uidMapConfig.getSOPClassUIDs(uIDType);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public static List<UIDType> getSOPClassUIDTypes(String string) {
        Set<UIDType> set = uidMapConfig.getSOPClassUIDTypes(string);
        if (set != null) {
            return new ArrayList<UIDType>(set);
        }
        return Collections.emptyList();
    }

    public static List<String> getTransferSyntaxUIDs() {
        return uidMapConfig.getTransferSyntaxUIDs();
    }

    public static Set<String> getTransferSyntaxUIDs(UIDType uIDType) {
        return uidMapConfig.getTransferSyntaxUIDs(uIDType);
    }

    public static List<UIDType> getTransferSyntaxUIDTypes(String string) {
        return new ArrayList<UIDType>(uidMapConfig.getTransferSyntaxUIDTypes(string));
    }

    public static boolean isTransferSyntaxType(String string, UIDType uIDType) {
        return uidMapConfig.isTransferSyntaxType(string, uIDType);
    }

    public static boolean isType(String string, UIDType uIDType) {
        return uidMapConfig.isType(string, uIDType);
    }

    public static boolean isViewableType(String string) {
        return uidMapConfig.isType(string, UIDType.Image) || uidMapConfig.isType(string, UIDType.USVolume) || uidMapConfig.isType(string, UIDType.Video);
    }

    public static String getCompressionMethod(String string) {
        return uidMapConfig.getCompressionMethod(string);
    }

    public static String nameOf(String string) {
        return UID.nameOf((String)string);
    }

    public static boolean contains(String[] stringArray, String string) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string2.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String selectTransferSyntaxUID(Collection<String> collection, String string) {
        if (collection == null) {
            return string;
        }
        if (collection.contains(string)) {
            return string;
        }
        for (String string2 : collection) {
            if (!UIDUtilities.isTransferSyntaxType(string2, UIDType.Lossless) || !UIDUtilities.isTransferSyntaxType(string2, UIDType.Encapsulated)) continue;
            return string2;
        }
        for (String string2 : collection) {
            if (!UIDUtilities.isTransferSyntaxType(string2, UIDType.Lossless)) continue;
            return string2;
        }
        for (String string2 : collection) {
            if (!UIDUtilities.isTransferSyntaxType(string2, UIDType.Lossy)) continue;
            return string2;
        }
        return null;
    }

    public static String selectTransferSyntaxUID(List<String> list, String string, String string2) {
        return UIDUtilities.selectTransferSyntaxUID(list, string);
    }

    public static String selectTransferSyntaxUID(String[] stringArray, String string) {
        return UIDUtilities.selectTransferSyntaxUID(Arrays.asList(stringArray), string);
    }
}

