/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.dicom;

import com.agfa.pacs.data.shared.dicom.DicomEnum;

public enum UIDType implements DicomEnum
{
    Image("image", true),
    Video("video", true),
    Multiframe("multiframe", false),
    SecondaryCapture("sc", false),
    Content("content", false),
    Waveform("waveform", true),
    Presentation("presentation", true),
    StructuredReport("structuredreport", true),
    KeyObject("keyobject", true),
    Composite("composite", true),
    Default("default", false),
    Lossless("lossless", false),
    Lossy("lossy", false),
    PixelDataProvider("url", false),
    HangingProtocol("hangingprotocol", true),
    Encapsulated("encapsulated", false),
    NoPixelData("nopixeldata", false),
    USVolume("usvolume", true),
    ComputedReport("computedreport", false),
    ForProcessing("forprocessing", false),
    CC("cc", true);

    private final String dicomId;
    private final boolean baseType;

    private UIDType(String string2, boolean bl) {
        this.dicomId = string2;
        this.baseType = bl;
    }

    @Override
    public String dicom() {
        return this.dicomId;
    }

    public boolean isBaseType() {
        return this.baseType;
    }

    public static UIDType get(String string) {
        UIDType[] uIDTypeArray = UIDType.values();
        int n = uIDTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIDType uIDType = uIDTypeArray[n2];
            if (uIDType.dicom().equals(string)) {
                return uIDType;
            }
            ++n2;
        }
        return null;
    }
}

